/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.structdeposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.business.service.builder.AbstractCashFlowBuilder;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.helper.StructDepositHelper;

public class StructDepositCashFlowBuilder
extends AbstractCashFlowBuilder {
    private static final Log logger = LogFactory.getLog(StructDepositCashFlowBuilder.class);

    @Override
    protected List<Map<String, Object>> bulidCashFlow() {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        datas.add(this.createPayCashFlowData("1"));
        Map<String, Object> towCashFlow = this.createPayCashFlowData("2");
        datas.add(towCashFlow);
        datas.add(this.createResetCashFlowData(towCashFlow));
        datas.add(this.createPayCashFlowData("3"));
        return datas;
    }

    protected Map<String, Object> createPayCashFlowData(String index) {
        Map<String, Object> cashFlow = new HashMap<String, Object>(20);
        long payId = DBServiceHelper.genGlobalLongId();
        cashFlow.put("id", payId);
        cashFlow.put("no", index);
        if (index.equals("2")) {
            cashFlow.put("cftype", CashFlowTypeEnum.floatrate);
        } else {
            cashFlow.put("cftype", CashFlowTypeEnum.capital);
        }
        if (index.equals("1")) {
            cashFlow.put("cfpaydate", this.model.getValue("intdate"));
        } else if (this.isBuildCashFlowByRateCfg() && EmptyUtil.isNoEmpty((String)((String)this.model.getParam().get("redeemday")))) {
            cashFlow.put("cfpaydate", TcDateUtils.stringToDate((String)((String)this.model.getParam().get("redeemday")), (String)"yyyy-MM-dd"));
        } else {
            cashFlow.put("cfpaydate", this.model.getValue("adjustsettledate"));
        }
        cashFlow.put("cfcurrency", this.model.getValue("currency"));
        cashFlow = this.buildBillUpdateData(cashFlow);
        return cashFlow;
    }

    protected Map<String, Object> createResetCashFlowData(Map<String, Object> payCashFlow) {
        HashMap<String, Object> cashFlow = new HashMap<String, Object>(8);
        cashFlow.put("pid", payCashFlow.get("id"));
        cashFlow.put("no", "2.1");
        String structType = (String)this.model.getValue("structtype");
        if (this.isBuildCashFlowByRateCfg()) {
            cashFlow.put("cfratefixdate", TcDateUtils.stringToDate((String)((String)this.model.getParam().get("bizdate")), (String)"yyyy-MM-dd"));
        } else if ("break".equals(structType)) {
            cashFlow.put("cfratefixdate", this.model.getValue("firstobsdate"));
            DynamicObjectCollection zones = (DynamicObjectCollection)this.model.getValue("zone");
            for (DynamicObject zone : zones) {
                if (!zone.getBoolean("obstacle")) continue;
                cashFlow.put("cfratefixdate", null);
                break;
            }
        } else if ("total".equals(structType)) {
            cashFlow.put("cfratefixdate", this.model.getValue("lastobsdate"));
        }
        cashFlow.put("cfresetpaydate", this.model.getValue("adjustsettledate"));
        cashFlow.put("cfunadjstartdate", this.model.getValue("intdate"));
        cashFlow.put("cfadjstartdate", this.model.getValue("intdate"));
        String adjustmethod = (String)this.model.getValue("dateadjustmethod");
        boolean isNoAdjust = AdjustMethodEnum.no_adjust.getValue().equals(adjustmethod);
        cashFlow.put("cfisadjust", !isNoAdjust);
        cashFlow.put("cfperioddays", this.getPeriodDays(this.model));
        cashFlow.put("cfbasis", this.model.getValue("basis"));
        BigDecimal predictRate = this.callPredictRate();
        cashFlow.put("cfresetpredictrate", predictRate);
        if (this.isBuildCashFlowByRateCfg()) {
            BigDecimal rate = new BigDecimal((String)this.model.getParam().get("rate"));
            cashFlow.put("cffixrate", rate);
            cashFlow.put("cfuserate", rate);
            cashFlow.put("cfisratecfg", Boolean.TRUE);
            if (EmptyUtil.isNoEmpty((String)((String)this.model.getParam().get("redeemday")))) {
                Date redeemDay = TcDateUtils.stringToDate((String)((String)this.model.getParam().get("redeemday")), (String)"yyyy-MM-dd");
                cashFlow.put("cfunadjenddate", redeemDay);
                cashFlow.put("cfadjenddate", redeemDay);
            } else {
                if (EmptyUtil.isNoEmpty((String)((String)this.model.getParam().get("cfunadjenddate")))) {
                    cashFlow.put("cfunadjenddate", TcDateUtils.stringToDate((String)((String)this.model.getParam().get("cfunadjenddate")), (String)"yyyy-MM-dd"));
                }
                if (EmptyUtil.isNoEmpty((String)((String)this.model.getParam().get("cfadjenddate")))) {
                    cashFlow.put("cfadjenddate", TcDateUtils.stringToDate((String)((String)this.model.getParam().get("cfadjenddate")), (String)"yyyy-MM-dd"));
                }
            }
        } else {
            cashFlow.put("cfuserate", predictRate);
            cashFlow.put("cfunadjenddate", this.model.getValue("settledate"));
            cashFlow.put("cfadjenddate", this.model.getValue("adjustsettledate"));
        }
        return cashFlow;
    }

    private boolean isBuildCashFlowByRateCfg() {
        return this.model.getParam().containsKey("rate_cfg_struct_deposit");
    }

    @Override
    protected Map<String, Object> buildBillUpdateData(Map<String, Object> cashFlow) {
        BigDecimal amount;
        String index = (String)cashFlow.get("no");
        BigDecimal payAmount = amount = (BigDecimal)this.model.getValue("amount");
        BigDecimal D = new BigDecimal(this.getPeriodDays(this.model));
        if ("1".equals(index)) {
            payAmount = amount.negate();
        } else if ("2".equals(index)) {
            BigDecimal usedRate;
            String billStatus = (String)this.model.getValue("billstatus");
            if (TcBillStatusEnum.SAVE.getValue().equals(billStatus)) {
                usedRate = this.callPredictRate();
                logger.info("------\u53d6\u9884\u4f30\u5229\u7387=" + usedRate + "------");
                payAmount = StructDepositHelper.callPredictIntest((ModelAgent)this.model, (BigDecimal)usedRate, (BigDecimal)D);
            } else {
                usedRate = this.callUsedRate(cashFlow);
                logger.info("------\u53d6\u4f7f\u7528\u5229\u7387=" + usedRate + "------");
                payAmount = StructDepositHelper.callPredictIntest((ModelAgent)this.model, (BigDecimal)usedRate, (BigDecimal)D);
            }
            logger.info("------payAmount=" + payAmount + "------");
            cashFlow.put("cfinterest", payAmount);
        }
        cashFlow.put("cfpayamount", payAmount);
        cashFlow.put("cfamount", payAmount);
        PriceRuleInfo info = this.getDiscfactor(cashFlow, this.model);
        Date payDate = this.getIntDate(cashFlow, this.model)[0];
        BigDecimal ds = (BigDecimal)info.getYieldCurve()[0].getDfMap().get(payDate);
        cashFlow.put("cfdiscfactor", ds);
        Date prePayDate = this.getIntDate(cashFlow, this.model)[1];
        BigDecimal bds = (BigDecimal)info.getYieldCurve()[0].getDfMap().get(prePayDate);
        if (EmptyUtil.isNoEmpty((BigDecimal)payAmount)) {
            cashFlow.put("cfpv", payAmount.multiply(ds).setScale(6, 4));
            if (payDate.after(TcDateUtils.getCurrentDate())) {
                cashFlow.put("cftheta", payAmount.negate().multiply(ds.subtract(bds)).setScale(6, 4));
            } else {
                cashFlow.put("cftheta", Constants.ZERO);
            }
        }
        if ("3".equals(index)) {
            cashFlow.put("cfprincipal", amount);
        } else if ("1".equals(index)) {
            cashFlow.put("cfprincipal", amount.negate());
        }
        if ("2".equals(index)) {
            cashFlow.put("cfosprincipal", amount);
        }
        return cashFlow;
    }

    private int getPeriodDays(ModelAgent bill) {
        BasisEnum basis = BasisEnum.valueOf((String)((String)bill.getValue("basis")));
        DynamicObjectCollection workCalendars = (DynamicObjectCollection)bill.getValue("workcalendar");
        if (this.isBuildCashFlowByRateCfg() && EmptyUtil.isNoEmpty((String)((String)this.model.getParam().get("redeemday")))) {
            Date unAdjEndDate = TcDateUtils.stringToDate((String)((String)this.model.getParam().get("redeemday")), (String)"yyyy-MM-dd");
            return TradeBusinessHelper.getBasis_BetweenDay((Date)((Date)bill.getValue("intdate")), (Date)unAdjEndDate, (BasisEnum)basis, (DynamicObject[])((DynamicObject[])workCalendars.toArray((Object[])new DynamicObject[workCalendars.size()])));
        }
        return StructDepositHelper.getPeriodDays((ModelAgent)this.model);
    }

    @Override
    protected Map<String, Map<String, Object>> buildEntrysUpdateData(Map<String, Map<String, Object>> cashFlows) {
        cashFlows.forEach((index, cashFlow) -> {
            BigDecimal predictRate = this.callPredictRate();
            logger.info("------\u53d6\u9884\u4f30\u5229\u7387=" + predictRate + "------");
            boolean isRateCfg = (Boolean)cashFlow.get("cfisratecfg");
            if (cashFlow == null || !isRateCfg) {
                cashFlow.put("cfuserate", predictRate);
                cashFlow.put("cfresetpredictrate", predictRate);
            }
        });
        return cashFlows;
    }

    @Override
    protected Map<String, Object> initCashFlow(DynamicObject info) {
        Map<String, Object> cashFlow = super.initCashFlow(info);
        if (info.getDynamicObjectCollection("entrys").size() > 0) {
            DynamicObject entry = (DynamicObject)info.getDynamicObjectCollection("entrys").get(0);
            cashFlow.put("billno", info.getString("billno"));
            cashFlow.put("cfisratecfg", entry.getBoolean("cfisratecfg"));
            cashFlow.put("cfresetpredictrate", entry.getBigDecimal("cfresetpredictrate"));
            cashFlow.put("cfuserate", entry.getBigDecimal("cfuserate"));
            cashFlow.put("cfratefixdate", entry.getDate("cfratefixdate"));
        }
        return cashFlow;
    }

    protected BigDecimal callUsedRate(Map<String, Object> cashFlow) {
        if (this.isBuildCashFlowByRateCfg()) {
            return new BigDecimal((String)this.model.getParam().get("rate"));
        }
        return this.callPredictRate();
    }

    protected BigDecimal callPredictRate() {
        if (this.isBuildCashFlowByRateCfg()) {
            return new BigDecimal((String)this.model.getParam().get("cfresetpredictrate"));
        }
        String structType = (String)this.model.getValue("structtype");
        if ("break".equals(structType)) {
            Object billStatus = this.model.getValue("billstatus");
            BigDecimal markPrice = (BigDecimal)this.model.getValue("predictmark");
            if (EmptyUtil.isNoEmpty((BigDecimal)markPrice)) {
                return StructDepositHelper.callBreakPredictRate((ModelAgent)this.model, (BigDecimal)markPrice);
            }
            if (EmptyUtil.isEmpty((Object)billStatus) || TcBillStatusEnum.SAVE.getValue().equals(billStatus)) {
                return StructDepositHelper.callBreakPredictRate((ModelAgent)this.model, (boolean)true);
            }
            return StructDepositHelper.callBreakPredictRate((ModelAgent)this.model, (boolean)false);
        }
        return StructDepositHelper.callTotalPredictRate((ModelAgent)this.model);
    }

    @Override
    protected List<String> getTradeBillSelector() {
        List<String> sic = super.getTradeBillSelector();
        sic.add("hooktype");
        sic.add("structtype");
        sic.add("predictmark");
        sic.add("predictrate");
        sic.add("firstobsdate");
        sic.add("obstacle");
        sic.add("lastobsdate");
        sic.add("intdate");
        sic.add("hookmark");
        sic.add("markprice");
        sic.add("marktime");
        sic.add("markzone");
        sic.add("displayform");
        sic.add("zone");
        sic.add("pricex");
        sic.add("pricey");
        sic.add("bwsymbol");
        sic.add("rate");
        sic.add("basis");
        sic.add("redeemtype");
        sic.add("redeemdate");
        sic.add("obsdate");
        sic.add("observe");
        sic.add("obsfreq");
        sic.add("pricemethod");
        sic.add("initialprice");
        sic.add("isstopobs");
        sic.add("firstbreakdate");
        return sic;
    }

    @Override
    protected Long[] getMarket(ModelAgent model) {
        DynamicObject market = (DynamicObject)model.getValue("market");
        return new Long[]{market.getLong("id")};
    }

    @Override
    protected Date[] getIntDate(Map<String, Object> cashFlow, ModelAgent model) {
        Date payDate = (Date)cashFlow.get("cfpaydate");
        return new Date[]{payDate, TcDateUtils.getLastDay((Date)payDate, (int)1)};
    }

    @Override
    protected String getFilter() {
        return null;
    }

    @Override
    protected boolean isRefresh(ModelAgent bill, DynamicObject[] cashFlows) {
        return !TcBillStatusEnum.FINISH.getValue().equals(bill.getValue("billstatus"));
    }

    protected boolean isRefreshRate(ModelAgent bill, Map<String, Object> cashFlow) {
        if (!cashFlow.containsKey("cfisratecfg")) {
            return false;
        }
        String structType = (String)bill.getValue("structtype");
        boolean isStopObs = (Boolean)bill.getValue("isstopobs");
        Date firstObsDate = (Date)bill.getValue("firstobsdate");
        Date lastObsDate = (Date)bill.getValue("lastobsdate");
        Date obsDate = EmptyUtil.isEmpty((Object)lastObsDate) ? firstObsDate : lastObsDate;
        boolean isRateCfg = this.isRateCfg(cashFlow);
        if (!isRateCfg && !isStopObs && "break".equals(structType) && !TcDateUtils.getCurrentDate().after(obsDate)) {
            return true;
        }
        Date rateFixDate = this.getRateCfgDate(cashFlow);
        if (EmptyUtil.isEmpty((Object)rateFixDate)) {
            rateFixDate = lastObsDate;
        }
        if (EmptyUtil.isEmpty((Object)rateFixDate)) {
            rateFixDate = firstObsDate;
        }
        return !isRateCfg && "total".equals(structType) && !TcDateUtils.getCurrentDate().after(rateFixDate);
    }

    private boolean isRateCfg(Map<String, Object> cashFlow) {
        return cashFlow != null && (Boolean)cashFlow.get("cfisratecfg") != false;
    }

    private Date getRateCfgDate(Map<String, Object> cashFlow) {
        Date rateCfgDate = null;
        if ("2".equals(cashFlow.get("billno"))) {
            rateCfgDate = (Date)cashFlow.get("cfratefixdate");
        }
        return rateCfgDate;
    }
}

