/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.swap;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.business.service.builder.AbstractCashFlowBuilder;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.helper.ForexCashFlowHelper;

public abstract class AbstractForexSwapsCashFlowBuilder
extends AbstractCashFlowBuilder {
    private static final Log logger = LogFactory.getLog(AbstractForexSwapsCashFlowBuilder.class);

    @Override
    protected List<Map<String, Object>> bulidCashFlow() {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        int index = 1;
        Map<String, Object> cashFlow = this.createCashFlowData(index);
        dataList.add(cashFlow);
        Map<String, Object> resetCashFlow = this.createResetCashFlowData(cashFlow);
        dataList.add(resetCashFlow);
        String deliveryWay = (String)this.model.getValue("deliveryway");
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
            index = 2;
            cashFlow = this.createCashFlowData(index);
            dataList.add(cashFlow);
            resetCashFlow = this.createResetCashFlowData(cashFlow);
            dataList.add(resetCashFlow);
        }
        return dataList;
    }

    protected Map<String, Object> createResetCashFlowData(Map<String, Object> cashFlow) {
        BigDecimal useRate;
        ForexQuoteInfo fxInfo;
        Date dm;
        BigDecimal exrate;
        HashMap<String, Object> resetRow = new HashMap<String, Object>();
        resetRow.put("id", DBServiceHelper.genGlobalLongId());
        resetRow.put("pid", cashFlow.get("id"));
        resetRow.put("no", cashFlow.get("no") + ".1");
        resetRow.put("cftype", "");
        resetRow.put("cfratefixdate", this.model.getValue("bizdate"));
        Long fqId = ((DynamicObject)this.model.getValue("pricerule")).getDynamicObject("forexquote").getLong("id");
        String fxQuote = (String)this.model.getValue("fxquote");
        String pair = (String)this.model.getValue("pair");
        String dir = (String)this.model.getValue("tradedirect");
        if (cashFlow.get("no").equals("1")) {
            exrate = (BigDecimal)this.model.getValue("spotrate");
            dm = (Date)this.model.getValue("adjustsettledate");
            fxInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, (Date)dm);
            useRate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(fxInfo.getFxquote()) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(fxInfo.getFxquote()) ? fxInfo.getSellPrice() : fxInfo.getBuyPrice();
        } else {
            exrate = (BigDecimal)this.model.getValue("forwrate");
            dm = (Date)this.model.getValue("adjustsettledate_far");
            fxInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, (Date)dm);
            useRate = TradeDirectionEnum.sell.getValue().equals(dir) && pair.equals(fxInfo.getFxquote()) || TradeDirectionEnum.buy.getValue().equals(dir) && !pair.equals(fxInfo.getFxquote()) ? fxInfo.getSellPrice() : fxInfo.getBuyPrice();
        }
        String fq = fxInfo.getFxquote();
        if (!fq.equals(fxQuote)) {
            BigDecimal newExRate = BigDecimal.ONE.divide(useRate, 10, RoundingMode.HALF_UP);
            logger.info("\u53d6\u5230\u7684\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)useRate, (Object)newExRate);
            useRate = newExRate;
        }
        resetRow.put("cffixrate", exrate);
        resetRow.put("cfuserate", useRate);
        return resetRow;
    }

    @Override
    protected List<String> getTradeBillSelector() {
        List<String> sic = super.getTradeBillSelector();
        sic.add("adjustsettledate_far");
        sic.add("sellcurrency_far");
        sic.add("buycurrency_far");
        sic.add("sellmarket_far");
        sic.add("buymarket_far");
        sic.add("buyamount_far");
        sic.add("sellamount_far");
        sic.add("amount");
        sic.add("sellamount");
        return sic;
    }

    protected Map<String, Object> createCashFlowData(int index) {
        Map<String, Object> cashFlow = new HashMap<String, Object>();
        cashFlow.put("id", DBServiceHelper.genGlobalLongId());
        cashFlow.put("no", String.valueOf(index));
        cashFlow.put("cftype", CashFlowTypeEnum.capital);
        cashFlow.put("cfishis", Boolean.FALSE);
        this.initPayDate(cashFlow);
        this.initCurrency(cashFlow);
        this.initPayAmount(cashFlow);
        this.initOtherData(cashFlow);
        cashFlow = this.buildBillUpdateData(cashFlow);
        cashFlow.put("cfdealrival", this.model.getValue("counterparty"));
        return cashFlow;
    }

    @Override
    protected Map<String, Object> initCashFlow(DynamicObject bill) {
        HashMap<String, Object> cashFlow = new HashMap<String, Object>(10);
        cashFlow.put("no", bill.getString("billno"));
        cashFlow.put("cfpaydate", bill.getDate("cfpaydate"));
        cashFlow.put("cfcurrency", bill.getDynamicObject("cfcurrency"));
        cashFlow.put("cfpayamount", bill.getBigDecimal("cfpayamount"));
        cashFlow.put("cfamount", bill.get("cfamount"));
        cashFlow.put("cfpv", bill.get("cfpv"));
        cashFlow.put("cftheta", bill.get("cftheta"));
        cashFlow.put("cfdiscfactor", bill.get("cfdiscfactor"));
        cashFlow.put("cfdealrival", bill.get("cfdealrival"));
        cashFlow.put("cfishis", bill.get("cfishis"));
        return cashFlow;
    }

    @Override
    protected Map<String, Object> buildBillUpdateData(Map<String, Object> cashFlow) {
        if (((Boolean)cashFlow.get("cfishis")).booleanValue()) {
            return cashFlow;
        }
        this.initPayAmount(cashFlow);
        return cashFlow;
    }

    protected abstract void initCurrency(Map<String, Object> var1);

    protected abstract void initPayAmount(Map<String, Object> var1);

    protected void initOtherData(Map<String, Object> cashFlow) {
    }

    protected void initPayDate(Map<String, Object> cashFlow) {
        if (cashFlow.get("no").equals("1")) {
            cashFlow.put("cfpaydate", this.model.getValue("adjustsettledate"));
        } else {
            cashFlow.put("cfpaydate", this.model.getValue("adjustsettledate_far"));
        }
    }

    @Override
    protected Date[] getIntDate(Map<String, Object> cashFlow, ModelAgent model) {
        if (cashFlow.get("no").equals("1")) {
            return new Date[]{(Date)model.getValue("adjustsettledate"), TcDateUtils.getLastDay((Date)((Date)model.getValue("adjustsettledate")), (int)1)};
        }
        return new Date[]{(Date)model.getValue("adjustsettledate_far"), TcDateUtils.getLastDay((Date)((Date)model.getValue("adjustsettledate_far")), (int)1)};
    }

    @Override
    public DynamicObject[] refresh(ModelAgent model) {
        DynamicObject[] cashFlows;
        DynamicObject tradeBill = (DynamicObject)model.getModel();
        Long id = tradeBill.getLong("id");
        QFilter filter = new QFilter("billid", "=", (Object)id);
        String direction = this.getFilter();
        if (EmptyUtil.isNoEmpty((String)direction)) {
            filter.and("cfdirection", "=", (Object)this.getFilter()).and("cfIsHis", "=", (Object)false);
        }
        if (!this.isRefresh(model, cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cfPayDate,cfUseRate,cfBizRecordId", (QFilter[])filter.toArray()))) {
            return null;
        }
        Set bizRecordIds = Arrays.stream(cashFlows).map(o -> o.get("cfBizRecordId")).collect(Collectors.toSet());
        DynamicObjectCollection bizRecordCol = QueryServiceHelper.query((String)"tm_bizRecord", (String)"id,swapDir", (QFilter[])new QFilter("id", "in", bizRecordIds).toArray());
        Map<Object, Object> bizRecordId2swapDirMap = bizRecordCol.stream().collect(Collectors.toMap(o -> o.get("id"), o -> o.get("swapDir")));
        for (DynamicObject cashFlow : cashFlows) {
            DynamicObjectCollection entrys = cashFlow.getDynamicObjectCollection("entrys");
            if (entrys.size() == 0) continue;
            DynamicObject subRow = (DynamicObject)entrys.get(0);
            Date cfPayDate = cashFlow.getDate("cfPayDate");
            Object bizRecordId = cashFlow.get("cfBizRecordId");
            boolean isNear = !"isfar".equals(bizRecordId2swapDirMap.get(bizRecordId));
            BigDecimal exRate = ForexCashFlowHelper.queryExRate_forexSwap((DynamicObject)tradeBill, (Date)cfPayDate, (boolean)isNear);
            subRow.set("cfuserate", (Object)exRate);
        }
        return cashFlows;
    }
}

