/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.swap;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.tm.business.service.builder.swap.AbstractForexSwapsCashFlowBuilder;

public class ForexSwapsSellCashFlowBuilder
extends AbstractForexSwapsCashFlowBuilder {
    @Override
    protected void initPayAmount(Map<String, Object> cashFlow) {
        BigDecimal dir = BigDecimal.ONE;
        String direction = (String)this.model.getValue("tradedirect");
        if (TradeDirectionEnum.buy.getValue().equals(direction)) {
            dir = dir.negate();
        }
        BigDecimal amt = cashFlow.get("no").equals("1") ? ((BigDecimal)this.model.getValue("sellamount")).multiply(dir) : ((BigDecimal)this.model.getValue("sellamount_far")).multiply(dir.negate());
        cashFlow.put("cfpayamount", amt);
    }

    @Override
    protected void initCurrency(Map<String, Object> cashFlow) {
        cashFlow.put("cfcurrency", this.model.getValue("sellcurrency"));
    }

    @Override
    protected void initOtherData(Map<String, Object> cashFlow) {
        cashFlow.put("cfdirection", TradeDirectionEnum.sell);
    }

    @Override
    protected Long[] getMarket(ModelAgent model) {
        Long sellMarketId = ((DynamicObject)model.getValue("sellmarket")).getLong("id");
        return new Long[]{sellMarketId};
    }

    @Override
    protected String getFilter() {
        return TradeDirectionEnum.sell.getValue();
    }
}

