/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.bond;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class BondSubmitOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("bondissue");
        sic.add("amount");
        sic.add("bondissue.totalissueamt");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity data : dataEntitys) {
            DynamicObject info = data.getDataEntity();
            DynamicObject bondIssue = info.getDynamicObject("bondissue");
            QFilter filter = new QFilter("bondissue.id", "=", bondIssue.getPkValue());
            QFilter statusFilter = new QFilter("billstatus", ">", (Object)TcBillStatusEnum.SAVE.getValue());
            DynamicObject[] usedBills = TmcDataServiceHelper.load((String)"tm_bond", (String)"amount", (QFilter[])new QFilter[]{filter, statusFilter});
            BigDecimal total = bondIssue.getBigDecimal("totalissueamt");
            BigDecimal used = BigDecimal.ZERO;
            for (DynamicObject usedBill : usedBills) {
                used = used.add(usedBill.getBigDecimal("amount"));
            }
            if (info.getBigDecimal("amount").compareTo(total.subtract(used)) <= 0) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u503a\u5238\u4ea4\u6613\u91d1\u989d\u8d85\u8fc7\u503a\u5238\u53d1\u884c\u7684\u53d1\u884c\u603b\u989d\u5269\u4f59\u989d\u5ea6\u3002", (String)"BondSubmitOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

