/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.business;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.PlHelper;

public class BizUpdatePlCfgValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(40);
        sic.add("billstatus");
        sic.add("isplconfirm");
        sic.add("execexrate");
        sic.add("plamt");
        sic.add("settleamount");
        sic.add("baseexrate");
        sic.add("baseplamt");
        sic.add("tradebill");
        sic.add("tradebill.protecttype");
        sic.add("tradebill.pricerule");
        sic.add("tradebill.deliveryway");
        sic.add("tradebill.pair");
        sic.add("tradebill.fxquote");
        sic.add("tradebill.tradedirect");
        sic.add("tradebill.currency");
        sic.add("tradebill.sellcurrency");
        sic.add("tradebill.adjustsettledate");
        sic.add("tradebill.tradetype");
        sic.add("tradebill.exchangerate");
        sic.add("tradebill.settlecurrency");
        sic.add("tradebill.premiumcurrency");
        sic.add("tradebill.premium");
        sic.add("tradebill.amount");
        sic.add("tradebill.reccurrency");
        sic.add("tradebill.rateswaptype");
        sic.add("tradebill.settledate");
        sic.add("bizrecordid");
        sic.add("operate");
        sic.add("bizdate");
        sic.add("basecurrency");
        sic.add("plcurrency");
        sic.add("bizamt1");
        sic.add("bizamt2");
        sic.add("exratecalmtd");
        sic.add("deliverydate");
        sic.add("spotrate_dey");
        sic.add("cashflow_pay");
        sic.add("cashflow_rec");
        sic.add("fxquotetype");
        sic.add("settlecurrency");
        return sic;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : entities) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!PlHelper.isEnableCommonForPlConfirm((DynamicObject)bill).booleanValue()) continue;
            DynamicObject productType = bill.getDynamicObject("tradebill").getDynamicObject("protecttype");
            String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
            try {
                switch (entityType) {
                    case "tm_forex": {
                        this.validateForex(bill);
                        break;
                    }
                    case "tm_forex_forward": 
                    case "tm_forex_swaps": {
                        this.validateForexFwd(bill);
                        break;
                    }
                    case "tm_forex_options": {
                        this.validateForexOption(bill);
                        break;
                    }
                    case "tm_structdeposit": {
                        this.validateStructDeposit(bill);
                        break;
                    }
                    case "tm_rateswap": {
                        this.validateRateSwap(bill);
                    }
                }
            }
            catch (Exception e) {
                this.addErrorMessage(dataEntity, e.getMessage());
            }
        }
    }

    protected void validateForex(DynamicObject bill) {
        String billStatus = bill.getString("billstatus");
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        Date bizdate = bill.getDate("bizdate");
        String op = bill.getString("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case flat: {
                if (TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    this.validateForexQuote(tradeBill, bizdate, null);
                }
                BizUpdatePlCfgValidator.validateBasePlForexQuote(bill, tradeBill);
            }
        }
    }

    protected void validateForexFwd(DynamicObject bill) {
        String billStatus = bill.getString("billstatus");
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        Date bizdate = bill.getDate("bizdate");
        String deliveryWay = tradeBill.getString("deliveryway");
        String exrateCalMtd = bill.getString("exratecalmtd");
        String op = bill.getString("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case expiredey: 
            case expiredey_f: 
            case expiredey_n: {
                Boolean enable = DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) ? Boolean.valueOf(TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) : Boolean.TRUE;
                if (enable.booleanValue()) {
                    this.validateForexQuote(tradeBill, bizdate, null);
                }
                BizUpdatePlCfgValidator.validateBasePlForexQuote(bill, tradeBill);
                break;
            }
            case flat: 
            case flat_n: 
            case flat_f: {
                Boolean enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
                if (enable.booleanValue()) {
                    this.validateForexQuote(tradeBill, bizdate, null);
                }
                BizUpdatePlCfgValidator.validateBasePlForexQuote(bill, tradeBill);
                break;
            }
            case bdelivery: 
            case bdelivery_n: 
            case bdelivery_f: {
                if (ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(exrateCalMtd)) {
                    this.validateForexQuote(tradeBill, bizdate, null);
                }
                if (ExRateCalMethodEnum.Rate.getValue().equals(exrateCalMtd) && TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    this.validateForexQuote(tradeBill, bizdate, null);
                }
                BizUpdatePlCfgValidator.validateBasePlForexQuote(bill, tradeBill);
                break;
            }
            case defer: 
            case maudate: 
            case defer_f: 
            case defer_n: 
            case maudate_f: 
            case maudate_n: {
                if (!ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) break;
                if (TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    this.validateForexQuote(tradeBill, bizdate, null);
                }
                BizUpdatePlCfgValidator.validateBasePlForexQuote(bill, tradeBill);
            }
        }
    }

    protected void validateForexOption(DynamicObject bill) {
        String billStatus = bill.getString("billstatus");
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        Date bizdate = bill.getDate("bizdate");
        String op = bill.getString("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case exercise: {
                Boolean enable = Boolean.TRUE;
                String deliveryWay = tradeBill.getString("deliveryway");
                if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                    enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
                }
                if (enable.booleanValue()) {
                    this.validateForexQuote(tradeBill, bizdate, bill.getDate("deliverydate"));
                }
                BizUpdatePlCfgValidator.validateBasePlForexQuote(bill, tradeBill);
                break;
            }
            case giveup: {
                this.validateForexQuote(tradeBill, bizdate, tradeBill.getDate("adjustsettledate"));
                BizUpdatePlCfgValidator.validateBasePlForexQuote(bill, tradeBill);
                break;
            }
            case flat: {
                BizUpdatePlCfgValidator.validateBasePlForexQuote(bill, tradeBill);
            }
        }
    }

    protected void validateStructDeposit(DynamicObject bill) {
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        String op = bill.getString("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case pay: {
                BizUpdatePlCfgValidator.validateBasePlForexQuote(bill, tradeBill);
            }
        }
    }

    protected void validateRateSwap(DynamicObject bill) {
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        String op = bill.getString("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case interestpay: 
            case capitalpay: {
                String swapType = tradeBill.getString("rateswaptype");
                if (SwapTypeEnum.currency.getValue().equals(swapType)) {
                    Boolean isPay = EmptyUtil.isNoEmpty((Long)bill.getLong("cashflow_pay"));
                    Boolean isRec = EmptyUtil.isNoEmpty((Long)bill.getLong("cashflow_rec"));
                    DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
                    if (!(plCurrency == null || isPay.booleanValue() && !isRec.booleanValue() && plCurrency.getLong("id") == tradeBill.getDynamicObject("currency").getLong("id") || !isPay.booleanValue() && isRec.booleanValue() && plCurrency.getLong("id") != tradeBill.getDynamicObject("currency").getLong("id"))) {
                        DynamicObject temp = QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexquote.id,forexquote.issuetime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradeBill.getDynamicObject("pricerule").getLong("id"))});
                        Long fqId = temp.getLong("forexquote.id");
                        DynamicObject payCurrency = tradeBill.getDynamicObject("currency");
                        DynamicObject recCurrency = tradeBill.getDynamicObject("reccurrency");
                        String pair = payCurrency.getString("number") + "/" + recCurrency.getString("number");
                        Date bizdate = bill.getDate("bizdate");
                        MarketDataServiceHelper.getForexQuoteInfoWithIssueTime((Long)fqId, (String)pair, (Date)bizdate, null);
                    }
                }
                BizUpdatePlCfgValidator.validateBasePlForexQuote(bill, tradeBill);
            }
        }
    }

    public void validateForexQuote(DynamicObject tradebill, Date issueTime, Date Dm) {
        DynamicObject priceRule = TmcDataServiceHelper.loadSingle((Object)tradebill.getDynamicObject("pricerule").getLong("id"), (String)"md_pricerule", (String)"forexquote.issuetime");
        Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
        String fxQuote = tradebill.getString("fxquote");
        MarketDataServiceHelper.getForexQuoteInfoWithIssueTime((Long)fqId, (String)fxQuote, (Date)issueTime, (Date)Dm);
    }

    public static void validateBasePlForexQuote(DynamicObject bill, DynamicObject tradeBill) {
        DynamicObject localCurrency = bill.getDynamicObject("basecurrency");
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        if (EmptyUtil.isNoEmpty((DynamicObject)localCurrency) && EmptyUtil.isNoEmpty((DynamicObject)plCurrency) && plCurrency.getLong("id") != localCurrency.getLong("id")) {
            DynamicObject priceRule = TmcDataServiceHelper.loadSingle((Object)tradeBill.getDynamicObject("pricerule").getLong("id"), (String)"md_pricerule", (String)"forexquote.issuetime");
            Date bizdate = bill.getDate("bizdate");
            String pair = localCurrency.getString("number") + "/" + plCurrency.getString("number");
            DynamicObject forexQuote = priceRule.getDynamicObject("forexquote");
            MarketDataServiceHelper.getForexQuoteInfoWithIssueTime((Long)forexQuote.getLong("id"), (String)pair, (Date)bizdate, null);
        }
    }
}

