/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.business;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.resource.TeBizResource;

public class BusinessBillSettleOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("operate");
        sic.add("tradebill");
        sic.add("plamt");
        sic.add("exratecalmtd");
        sic.add("settleamount");
        sic.add("protecttype");
        sic.add("cashflow_pay");
        sic.add("cashflow_rec");
        sic.add("bizamt1");
        sic.add("bizamt2");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        if (this.getOption().containsVariable("call_by_settle_op")) {
            return;
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject tradeBill = bill.getDynamicObject("tradebill");
            DynamicObject productType = bill.getDynamicObject("protecttype");
            String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
            String billStatus = bill.getString("billstatus");
            if (!TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u4f46\u672a\u7ed3\u7b97\u7684\u751f\u547d\u5468\u671f\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BusinessBillSettleOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject newObject = TmcDataServiceHelper.loadSingle((Object)bill.getLong("id"), (String)"tm_businessbill", (String)"billstatus");
            if (!newObject.getString("billstatus").equals(billStatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BusinessBillSettleOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            String operate = bill.getString("operate");
            BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
            switch (bizOp) {
                case exercise: {
                    BigDecimal settleAmount;
                    if (!"tm_forex_options".equals(entityType) || !DeliveryWayEnum.non_deliverable.getValue().equals(tradeBill.get("deliveryway")) || BigDecimal.ZERO.compareTo(settleAmount = bill.getBigDecimal("settleamount")) != 0) break;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u884c\u6743\u635f\u76ca\u4e3a0\uff0c\u65e0\u9700\u8fdb\u884c%s\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BusinessBillSettleOpValidator_12", (String)"tmc-tm-business", (Object[])new Object[]{this.getOperationName()}));
                    break;
                }
                case expiredey: {
                    BigDecimal pl;
                    if (!"tm_forex_forward".equals(entityType) || !DeliveryWayEnum.non_deliverable.getValue().equals(tradeBill.get("deliveryway")) || BigDecimal.ZERO.compareTo(pl = bill.getBigDecimal("plamt")) != 0) break;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6709\u635f\u76ca\u4ea7\u751f\u7684\u751f\u547d\u5468\u671f\u5355\u8fdb\u884c%s\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BusinessBillSettleOpValidator_11", (String)"tmc-tm-business", (Object[])new Object[]{this.getOperationName()}));
                    break;
                }
                case exratecfg: {
                    this.addErrorMessage(data, TeBizResource.checkBusinessSettleOperate((String)BizOperateEnum.exratecfg.getName()));
                    break;
                }
                case ratecfg: {
                    if ("tm_structdeposit".equals(entityType)) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5229\u606f/\u672c\u91d1\u6536\u53d6\u7684\u751f\u547d\u5468\u671f\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BusinessBillSettleOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
                        break;
                    }
                    this.addErrorMessage(data, TeBizResource.checkBusinessSettleOperate((String)BizOperateEnum.ratecfg.getName()));
                    break;
                }
                case giveup: {
                    this.addErrorMessage(data, TeBizResource.checkBusinessSettleOperate((String)BizOperateEnum.giveup.getName()));
                    break;
                }
                case defer: 
                case maudate: 
                case defer_n: 
                case defer_f: 
                case maudate_n: 
                case maudate_f: {
                    if (!"tm_forex_forward".equals(entityType) && !"tm_forex_swaps".equals(entityType)) break;
                    BigDecimal plAmt = bill.getBigDecimal("plamt");
                    if (BigDecimal.ZERO.compareTo(plAmt) == 0) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6709\u635f\u76ca\u4ea7\u751f\u7684\u751f\u547d\u5468\u671f\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BusinessBillSettleOpValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
                    }
                    String exRateCalMtd = bill.getString("exratecalmtd");
                    if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exRateCalMtd)) break;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u751f\u547d\u5468\u671f\u5355\u6ca1\u6709\u73b0\u91d1\u635f\u76ca\u9700\u8981%s\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BusinessBillSettleOpValidator_5", (String)"tmc-tm-business", (Object[])new Object[]{this.getOperationName()}));
                    break;
                }
                case flat: 
                case flat_n: 
                case flat_f: {
                    BigDecimal pl;
                    BigDecimal settleAmount;
                    if ("tm_forex_options".equals(entityType) && BigDecimal.ZERO.compareTo(settleAmount = bill.getBigDecimal("settleamount")) == 0) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u751f\u547d\u5468\u671f\u5355\u5e73\u4ed3\u671f\u6743\u8d39\u4e3a0\uff0c\u65e0\u9700\u8fdb\u884c%s\u64cd\u4f5c\u3002", (String)"BusinessBillSettleOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[]{this.getOperationName()}));
                    }
                    if (!"tm_forex".equals(entityType) && !"tm_forex_forward".equals(entityType) && !"tm_forex_swaps".equals(entityType) || BigDecimal.ZERO.compareTo(pl = bill.getBigDecimal("plamt")) != 0) break;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6709\u635f\u76ca\u4ea7\u751f\u7684\u751f\u547d\u5468\u671f\u5355\u8fdb\u884c%s\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BusinessBillSettleOpValidator_11", (String)"tmc-tm-business", (Object[])new Object[]{this.getOperationName()}));
                    break;
                }
                case interestpay: {
                    BigDecimal settleAmount;
                    if ("tm_rateswap".equals(entityType)) {
                        Long cashflow_rec;
                        Long cashflow_pay;
                        BigDecimal settleAmount2;
                        String swapType = tradeBill.getString("rateswaptype");
                        if (SwapTypeEnum.rate.getValue().equals(swapType) && BigDecimal.ZERO.compareTo(settleAmount2 = !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{cashflow_pay = Long.valueOf(bill.getLong("cashflow_pay")), cashflow_rec = Long.valueOf(bill.getLong("cashflow_rec"))}) ? bill.getBigDecimal("settleamount") : (!EmptyUtil.isEmpty((Long)cashflow_pay) ? bill.getBigDecimal("bizamt1") : bill.getBigDecimal("bizamt2"))) == 0) {
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u751f\u547d\u5468\u671f\u5355\u7ed3\u7b97\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u8fdb\u884c\u7ed3\u7b97\u64cd\u4f5c\u3002", (String)"BusinessBillSettleOpValidator_13", (String)"tmc-tm-business", (Object[])new Object[0]));
                        }
                    }
                    if (!"tm_forwrateagree".equals(entityType) || BigDecimal.ZERO.compareTo(settleAmount = bill.getBigDecimal("settleamount")) != 0) break;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u751f\u547d\u5468\u671f\u5355\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u8fdb\u884c\u7ed3\u7b97\u64cd\u4f5c\u3002", (String)"BusinessBillSettleOpValidator_14", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
            }
            String op = this.getOperateKey();
            if ("settle".equals(op) && TmcBotpHelper.isExistTargetBills((String)bill.getDataEntityType().getName(), (Long)bill.getLong("id"), (String[])new String[]{"cas_recbill", "cas_paybill", "cas_exchangebill"})) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u6536\u6b3e/\u4ed8\u6b3e\u5355\u6216\u5916\u5e01\u5151\u6362\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"BusinessBillSettleOpValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if ("genpaybill".equals(op)) {
                if (TmcBotpHelper.isExistTargetBills((String)bill.getDataEntityType().getName(), (Long)bill.getLong("id"), (String[])new String[]{"cas_paybill", "cas_exchangebill"})) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u4ed8\u6b3e\u5355\u6216\u5916\u5e01\u5151\u6362\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"BusinessBillSettleOpValidator_7", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
                if (this.check(bill, op)) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u65e0\u9700\u751f\u6210\u4ed8\u6b3e\u5355\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusinessBillSettleOpValidator_9", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if (!"genrecbill".equals(op)) continue;
            if (TmcBotpHelper.isExistTargetBills((String)bill.getDataEntityType().getName(), (Long)bill.getLong("id"), (String[])new String[]{"cas_recbill", "cas_exchangebill"})) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u6536\u6b3e\u5355\u6216\u5916\u5e01\u5151\u6362\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"BusinessBillSettleOpValidator_8", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            if (this.check(bill, op)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u65e0\u9700\u751f\u6210\u6536\u6b3e\u5355\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusinessBillSettleOpValidator_10", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private boolean check(DynamicObject bizBill, String op) {
        DynamicObject productType = bizBill.getDynamicObject("protecttype");
        String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String operate = bizBill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case bdelivery: 
            case bdelivery_n: 
            case bdelivery_f: {
                if (!"tm_forex_forward".equals(entityType) && !"tm_forex_swaps".equals(entityType)) break;
                return true;
            }
            case expiredey: 
            case expiredey_n: 
            case expiredey_f: {
                if ("tm_forex".equals(entityType) || "tm_forex_swaps".equals(entityType)) {
                    return true;
                }
                if (!"tm_forex_forward".equals(entityType)) break;
                String deliveryWay = tradeBill.getString("deliveryway");
                if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    return true;
                }
                if (!DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) break;
                BigDecimal plAmt = bizBill.getBigDecimal("plamt");
                if (BigDecimal.ZERO.compareTo(plAmt) < 0 && "genrecbill".equals(op)) {
                    return true;
                }
                if (BigDecimal.ZERO.compareTo(plAmt) <= 0 || !"genpaybill".equals(op)) break;
                return true;
            }
            case flat_n: 
            case flat_f: {
                if (!"tm_forex_swaps".equals(entityType)) break;
                BigDecimal plAmt = bizBill.getBigDecimal("plamt");
                if (BigDecimal.ZERO.compareTo(plAmt) < 0 && "genrecbill".equals(op)) {
                    return true;
                }
                if (BigDecimal.ZERO.compareTo(plAmt) <= 0 || !"genpaybill".equals(op)) break;
                return true;
            }
            case exercise: {
                if ("tm_forex_options".equals(entityType)) {
                    String deliveryWay = tradeBill.getString("deliveryway");
                    if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                        return true;
                    }
                    BigDecimal settleamount = bizBill.getBigDecimal("settleamount");
                    if (settleamount.compareTo(Constants.ZERO) < 0 && "genpaybill".equals(op)) {
                        return true;
                    }
                    if (settleamount.compareTo(Constants.ZERO) > 0 && "genrecbill".equals(op)) {
                        return true;
                    }
                }
                if (!"tm_ratebound".equals(entityType)) break;
                BigDecimal settleamount = bizBill.getBigDecimal("settleamount");
                if (settleamount.compareTo(Constants.ZERO) < 0 && "genpaybill".equals(op)) {
                    return true;
                }
                if (settleamount.compareTo(Constants.ZERO) <= 0 || !"genrecbill".equals(op)) break;
                return true;
            }
            case flat: {
                if ("tm_forex_forward".equals(entityType) || "tm_forex".equals(entityType)) {
                    BigDecimal plAmt = bizBill.getBigDecimal("plamt");
                    if (BigDecimal.ZERO.compareTo(plAmt) < 0 && "genrecbill".equals(op)) {
                        return true;
                    }
                    if (BigDecimal.ZERO.compareTo(plAmt) > 0 && "genpaybill".equals(op)) {
                        return true;
                    }
                }
                if (!"tm_forex_options".equals(entityType)) break;
                String tradeDirect = tradeBill.getString("tradedirect");
                if (TradeDirectionEnum.buy.getValue().equals(tradeDirect) && "genrecbill".equals(op)) {
                    return true;
                }
                if (!TradeDirectionEnum.sell.getValue().equals(tradeDirect) || !"genpaybill".equals(op)) break;
                return true;
            }
            case defer: 
            case maudate: 
            case defer_n: 
            case defer_f: 
            case maudate_n: 
            case maudate_f: {
                if (!"tm_forex_forward".equals(entityType) && !"tm_forex_swaps".equals(entityType)) break;
                BigDecimal plAmt = bizBill.getBigDecimal("plamt");
                if (BigDecimal.ZERO.compareTo(plAmt) < 0 && "genrecbill".equals(op)) {
                    return true;
                }
                if (BigDecimal.ZERO.compareTo(plAmt) <= 0 || !"genpaybill".equals(op)) break;
                return true;
            }
            case pay: {
                if (!"tm_structdeposit".equals(entityType) || !"genrecbill".equals(op)) break;
                return true;
            }
            case interestpay: {
                if ("tm_rateswap".equals(entityType)) {
                    Long cashflow_rec;
                    Long cashflow_pay = bizBill.getLong("cashflow_pay");
                    if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{cashflow_pay, cashflow_rec = Long.valueOf(bizBill.getLong("cashflow_rec"))})) {
                        String rateswapType = tradeBill.getString("rateswaptype");
                        if (SwapTypeEnum.rate.getValue().equals(rateswapType)) {
                            BigDecimal settleamount = bizBill.getBigDecimal("settleamount");
                            if (settleamount.compareTo(Constants.ZERO) < 0 && "genpaybill".equals(op)) {
                                return true;
                            }
                            if (settleamount.compareTo(Constants.ZERO) > 0 && "genrecbill".equals(op)) {
                                return true;
                            }
                        }
                        if (SwapTypeEnum.currency.getValue().equals(rateswapType)) {
                            return true;
                        }
                    } else {
                        if (EmptyUtil.isNoEmpty((Long)cashflow_pay) && "genpaybill".equals(op)) {
                            return true;
                        }
                        if (EmptyUtil.isNoEmpty((Long)cashflow_rec) && "genrecbill".equals(op)) {
                            return true;
                        }
                    }
                }
                if (!"tm_forwrateagree".equals(entityType)) break;
                BigDecimal settleamount = bizBill.getBigDecimal("settleamount");
                if (settleamount.compareTo(Constants.ZERO) < 0 && "genpaybill".equals(op)) {
                    return true;
                }
                if (settleamount.compareTo(Constants.ZERO) <= 0 || !"genrecbill".equals(op)) break;
                return true;
            }
            case capitalpay: {
                if (!"tm_rateswap".equals(entityType)) break;
                return true;
            }
        }
        return false;
    }
}

