/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.helper.PlHelper;
import kd.tmc.tm.common.resource.TeBizResource;

public class BusinessBillSubmitOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("org");
        list.add("billno");
        list.add("tradebill");
        list.add("operate");
        list.add("deliverydate");
        list.add("exratecalmtd");
        list.add("plsettledate");
        list.add("isdaterange");
        list.add("expireddate");
        list.add("expired_start");
        list.add("expired_end");
        list.add("deydate_start");
        list.add("deydate_end");
        list.add("execexrate");
        list.add("plamt");
        list.add("plcurrency");
        list.add("baseplamt");
        list.add("baseexrate");
        list.add("bizamt1");
        list.add("spotrate_dey");
        list.add("bizrecordid");
        list.add("cashflow_pay");
        list.add("cashflow_rec");
        list.add("fixedrate_pay");
        list.add("fixedrate_rec");
        list.add("totalrate_pay");
        list.add("totalrate_rec");
        list.add("rate");
        list.add("settlecurrency");
        list.add("premium_pl_exrate");
        return list;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        String exrateCalMtdIsNull = ResManager.loadKDString((String)"\u6c47\u7387\u8ba1\u7b97\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExrateCalMtdIsNull", (String)"tmc-tm-business", (Object[])new Object[0]);
        String maudate_RateNotLargerZero = ResManager.loadKDString((String)"\u63d0\u524d\u6c47\u7387\u9700\u5927\u4e8e0\u3002", (String)"Maudate_RateNotLargerZero", (String)"tmc-tm-business", (Object[])new Object[0]);
        String defer_RateNotLargerZero = ResManager.loadKDString((String)"\u5c55\u671f\u6c47\u7387\u9700\u5927\u4e8e0\u3002", (String)"Defer_RateNotLargerZero", (String)"tmc-tm-business", (Object[])new Object[0]);
        String spot_RateNotLargerZero = ResManager.loadKDString((String)"\u5e02\u573a\u6c47\u7387\u9700\u5927\u4e8e0\u3002", (String)"BusinessBillSubmitOpValidator_18", (String)"tmc-tm-business", (Object[])new Object[0]);
        String fixedRateIsNull = ResManager.loadKDString((String)"\u786e\u5b9a\u5229\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_11", (String)"tmc-tm-business", (Object[])new Object[0]);
        String totalRateIsNull = ResManager.loadKDString((String)"\u652f\u4ed8\u65b9/\u6536\u53d6\u65b9\u603b\u5229\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_12", (String)"tmc-tm-business", (Object[])new Object[0]);
        HashMap<Long, Boolean> cache = new HashMap<Long, Boolean>();
        for (ExtendedDataEntity data : this.dataEntities) {
            Long plId;
            DynamicObject premiumCur;
            DynamicObject plCurrency;
            Long bizRecordId;
            QFilter qFilter;
            boolean recordExists;
            DynamicObject bill = data.getDataEntity();
            DynamicObject tradebill = bill.getDynamicObject("tradebill");
            Long sid = tradebill.getLong("id");
            if (cache.get(sid) != null) {
                if (((Boolean)cache.get(sid)).booleanValue()) {
                    this.addErrorMessage(data, TeBizResource.SaveCheckExistBizDealBill());
                    continue;
                }
            } else {
                QFilter filter = new QFilter("billstatus", "<", (Object)TcBillStatusEnum.AUDIT.getValue()).and("tradebill", "=", (Object)sid).and("id", "!=", (Object)bill.getLong("id"));
                DynamicObjectCollection businessBillCol = QueryServiceHelper.query((String)"tm_businessbill", (String)"id", (QFilter[])filter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)businessBillCol)) {
                    cache.put(sid, Boolean.TRUE);
                    this.addErrorMessage(data, TeBizResource.SaveCheckExistBizDealBill());
                    continue;
                }
                cache.put(sid, Boolean.FALSE);
            }
            DynamicObject productType = tradebill.getDynamicObject("protecttype");
            String srcBillType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
            if (!ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(productType.getString("number")) && !(recordExists = TmcDataServiceHelper.exists((String)"tm_bizrecord", (QFilter[])(qFilter = new QFilter("id", "=", (Object)(bizRecordId = Long.valueOf(bill.getLong("bizrecordid"))))).toArray()))) {
                this.addErrorMessage(data, TeBizResource.checkBizRecord());
            }
            String operate = bill.getString("operate");
            BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
            switch (bizOp) {
                case flat: 
                case flat_n: 
                case flat_f: {
                    if ("tm_forex_forward".equals(srcBillType) || "tm_forex".equals(srcBillType) || "tm_forex_swaps".equals(srcBillType)) {
                        this.verifyBizAmt(data, bill);
                        this.verifyPlSettleDate(data, bill);
                        this.verifyPlInfoRate(data, bill);
                        this.verifyPlInfo(data, bill);
                    }
                    if (!"tm_forex_options".equals(srcBillType)) break;
                    this.verifyBizAmt(data, bill);
                    this.verifyPlSettleDate(data, bill);
                    DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
                    if (settleCurrency == null) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u5e73\u4ed3\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_20", (String)"tmc-tm-business", (Object[])new Object[0]));
                    }
                    if ((plCurrency = bill.getDynamicObject("plcurrency")) != null) break;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u635f\u76ca\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_15", (String)"tmc-tm-business", (Object[])new Object[0]));
                    break;
                }
                case expiredey: {
                    if ("tm_forex".equals(srcBillType)) {
                        this.verifyDeliveryDate(data, bill);
                        this.verifyBizAmt(data, bill);
                    }
                    if (!"tm_forex_forward".equals(srcBillType)) break;
                    this.verifyDeliveryDate(data, bill);
                    this.verifyBizAmt(data, bill);
                    this.verifyPlInfoRate(data, bill);
                    this.verifyPlInfo(data, bill);
                    break;
                }
                case expiredey_f: 
                case expiredey_n: {
                    if (!"tm_forex_swaps".equals(srcBillType)) break;
                    this.verifyDeliveryDate(data, bill);
                    this.verifyBizAmt(data, bill);
                    if (!PlHelper.isNeedPl_ForexSwapExpireDey((Long)tradebill.getLong("id"), (String)operate).booleanValue()) break;
                    this.verifyPlInfoRate(data, bill);
                    this.verifyPlInfo(data, bill);
                    break;
                }
                case bdelivery: 
                case bdelivery_f: 
                case bdelivery_n: {
                    if (!"tm_forex_forward".equals(srcBillType) && !"tm_forex_swaps".equals(srcBillType)) break;
                    this.verifyDeliveryDate(data, bill);
                    String exrateCalMtd = bill.getString("exratecalmtd");
                    if (EmptyUtil.isEmpty((String)exrateCalMtd)) {
                        this.addErrorMessage(data, exrateCalMtdIsNull);
                    }
                    if (ExRateCalMethodEnum.Rate.getValue().equals(exrateCalMtd)) {
                        this.verifyPlSettleDate(data, bill);
                    }
                    this.verifyPlInfoRate(data, bill);
                    this.verifyPlInfo(data, bill);
                    if (!EmptyUtil.isEmpty((Object)bill.get("spotrate_dey"))) break;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u63d0\u524d\u4ea4\u5272\u6c47\u7387\u9700\u5927\u4e8e0\u3002", (String)"BusinessBillSubmitOpValidator_16", (String)"tmc-tm-business", (Object[])new Object[0]));
                    break;
                }
                case maudate: 
                case defer: {
                    if (!"tm_forex_forward".equals(srcBillType)) break;
                    String exrateCalMtd = bill.getString("exratecalmtd");
                    if (EmptyUtil.isEmpty((String)exrateCalMtd)) {
                        this.addErrorMessage(data, exrateCalMtdIsNull);
                    }
                    if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) {
                        this.verifyPlSettleDate(data, bill);
                        this.verifyPlInfoRate(data, bill);
                        this.verifyPlInfo(data, bill);
                    }
                    this.verifyDate_Fwd(data, bill);
                    BigDecimal spotRate = bill.getBigDecimal("spotrate_dey");
                    if (BigDecimal.ZERO.compareTo(spotRate) < 0) break;
                    if (bizOp == BizOperateEnum.maudate) {
                        this.addErrorMessage(data, maudate_RateNotLargerZero);
                        break;
                    }
                    this.addErrorMessage(data, defer_RateNotLargerZero);
                    break;
                }
                case maudate_f: 
                case maudate_n: 
                case defer_f: 
                case defer_n: {
                    String exrateCalMtd;
                    BigDecimal spotRate;
                    Date deliveryDate;
                    if (!"tm_forex_swaps".equals(srcBillType)) break;
                    Date deyDate = bill.getDate("expireddate");
                    if (EmptyUtil.isEmpty((Object)deyDate)) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
                    }
                    if (EmptyUtil.isEmpty((Object)(deliveryDate = bill.getDate("deliverydate")))) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u8c03\u6574\u4ea4\u5272\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
                    }
                    if (BigDecimal.ZERO.compareTo(spotRate = bill.getBigDecimal("spotrate_dey")) >= 0) {
                        if (bizOp == BizOperateEnum.maudate_f || bizOp == BizOperateEnum.maudate_n) {
                            this.addErrorMessage(data, maudate_RateNotLargerZero);
                        } else {
                            this.addErrorMessage(data, defer_RateNotLargerZero);
                        }
                    }
                    if (EmptyUtil.isEmpty((String)(exrateCalMtd = bill.getString("exratecalmtd")))) {
                        this.addErrorMessage(data, exrateCalMtdIsNull);
                    }
                    if (!ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) break;
                    this.verifyPlSettleDate(data, bill);
                    this.verifyPlInfoRate(data, bill);
                    this.verifyPlInfo(data, bill);
                    break;
                }
                case exercise: {
                    if (!"tm_forex_options".equals(srcBillType)) break;
                    BigDecimal execexRate = bill.getBigDecimal("execexrate");
                    if (BigDecimal.ZERO.compareTo(execexRate) >= 0) {
                        this.addErrorMessage(data, spot_RateNotLargerZero);
                    }
                    this.verifyDeliveryDate(data, bill);
                    this.verifyPlInfo(data, bill);
                    break;
                }
                case giveup: {
                    if (!"tm_forex_options".equals(srcBillType)) break;
                    BigDecimal execexRate = bill.getBigDecimal("execexrate");
                    if (BigDecimal.ZERO.compareTo(execexRate) >= 0) {
                        this.addErrorMessage(data, spot_RateNotLargerZero);
                    }
                    if (bill.getDynamicObject("plcurrency") != null) break;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u635f\u76ca\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_15", (String)"tmc-tm-business", (Object[])new Object[0]));
                    return;
                }
                case ratecfg: {
                    if ("tm_rateswap".equals(srcBillType) && (EmptyUtil.isNoEmpty((Long)bill.getLong("cashflow_pay")) && EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("fixedrate_pay")) || EmptyUtil.isNoEmpty((Long)bill.getLong("cashflow_rec")) && EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("fixedrate_rec")))) {
                        this.addErrorMessage(data, fixedRateIsNull);
                    }
                    if (!"tm_structdeposit".equals(srcBillType) || bill.getBigDecimal("rate").compareTo(BigDecimal.ZERO) > 0) break;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5bf9\u5e94\u5229\u7387\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6570\u503c\u3002", (String)"BusinessBillSubmitOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
                    break;
                }
                case interestpay: {
                    if ("tm_rateswap".equals(srcBillType)) {
                        BigDecimal bizamt2;
                        BigDecimal bizamt1;
                        if (EmptyUtil.isNoEmpty((Long)bill.getLong("cashflow_pay")) && EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("totalrate_pay")) || EmptyUtil.isNoEmpty((Long)bill.getLong("cashflow_rec")) && EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("totalrate_rec"))) {
                            this.addErrorMessage(data, totalRateIsNull);
                        }
                        boolean verifyamt = false;
                        if (EmptyUtil.isNoEmpty((Long)bill.getLong("cashflow_pay")) && (bizamt1 = bill.getBigDecimal("bizamt1")).compareTo(BigDecimal.ZERO) <= 0) {
                            verifyamt = true;
                        }
                        if (EmptyUtil.isNoEmpty((Long)bill.getLong("cashflow_rec")) && (bizamt2 = bill.getBigDecimal("bizamt2")).compareTo(BigDecimal.ZERO) <= 0) {
                            verifyamt = true;
                        }
                        if (verifyamt) {
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u91d1\u989d\u6570\u503c\u3002", (String)"BusinessBillSubmitOpValidator_14", (String)"tmc-tm-business", (Object[])new Object[0]));
                        }
                        this.verifyPlSettleDate(data, bill);
                        this.verifyPlInfo(data, bill);
                    }
                    if (!"tm_forwrateagree".equals(srcBillType)) break;
                    this.verifyPlSettleDate(data, bill);
                    break;
                }
                case capitalpay: {
                    if (!"tm_rateswap".equals(srcBillType)) break;
                    this.verifyPlSettleDate(data, bill);
                    this.verifyPlInfoRate(data, bill);
                    this.verifyPlInfo(data, bill);
                }
            }
            if (!ProductTypeEnum.FOREXOPTION.getValue().equals(productType.getString("number"))) continue;
            BigDecimal exRate = bill.getBigDecimal("premium_pl_exrate");
            plCurrency = bill.getDynamicObject("plcurrency");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, premiumCur = tradebill.getDynamicObject("premiumcurrency")}) || exRate == null || (plId = Long.valueOf(plCurrency.getLong("id"))).equals(premiumCur.getLong("id")) || exRate.compareTo(BigDecimal.ZERO) > 0) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u671f\u6743\u8d39\u652f\u4ed8\u5e01\u79cd\u6298\u635f\u76ca\u5e01\u79cd\u6c47\u7387\u9700\u5927\u4e8e0\u3002", (String)"BusinessBillSubmitOpValidator_19", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private void verifyPlSettleDate(ExtendedDataEntity data, DynamicObject bill) {
        Date settledate_pl = bill.getDate("plsettledate");
        if (EmptyUtil.isEmpty((Object)settledate_pl)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_13", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private void verifyDate_Fwd(ExtendedDataEntity data, DynamicObject bill) {
        boolean isDateRange = bill.getBoolean("isdaterange");
        if (isDateRange) {
            Date expired_start = bill.getDate("expired_start");
            Date expired_end = bill.getDate("expired_end");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{expired_start, expired_end})) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u533a\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            Date deydate_start = bill.getDate("deydate_start");
            Date deydate_end = bill.getDate("deydate_end");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{deydate_start, deydate_end})) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8c03\u6574\u4ea4\u5272\u65e5\u533a\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_5", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        } else {
            Date deliveryDate;
            Date expiredDate = bill.getDate("expireddate");
            if (EmptyUtil.isEmpty((Object)expiredDate)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)(deliveryDate = bill.getDate("deliverydate")))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8c03\u6574\u4ea4\u5272\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }

    private void verifyPlInfoRate(ExtendedDataEntity data, DynamicObject bill) {
        if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("execexrate")) >= 0) {
            String operate = bill.getString("operate");
            BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
            if (BizOperateEnum.flat == bizOp || BizOperateEnum.flat_n == bizOp || BizOperateEnum.flat_f == bizOp) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5e73\u4ed3\u6c47\u7387\u9700\u5927\u4e8e0\u3002", (String)"BusinessBillSubmitOpValidator_7", (String)"tmc-tm-business", (Object[])new Object[0]));
            } else if (BizOperateEnum.expiredey == bizOp || BizOperateEnum.expiredey_n == bizOp || BizOperateEnum.expiredey_f == bizOp || (BizOperateEnum.bdelivery == bizOp || BizOperateEnum.bdelivery_n == bizOp || BizOperateEnum.bdelivery_f == bizOp) && ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(bill.get("exratecalmtd")) || BizOperateEnum.capitalpay == bizOp) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5373\u671f\u6c47\u7387\u9700\u5927\u4e8e0\u3002", (String)"BusinessBillSubmitOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
            } else if ((BizOperateEnum.maudate == bizOp || BizOperateEnum.maudate_n == bizOp || BizOperateEnum.maudate_f == bizOp) && ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(bill.get("exratecalmtd")) || (BizOperateEnum.defer == bizOp || BizOperateEnum.defer_n == bizOp || BizOperateEnum.defer_f == bizOp) && ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(bill.get("exratecalmtd")) || (BizOperateEnum.bdelivery == bizOp || BizOperateEnum.bdelivery_n == bizOp || BizOperateEnum.bdelivery_f == bizOp) && ExRateCalMethodEnum.Rate.getValue().equals(bill.get("exratecalmtd"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5e73\u4ed3\u8fdc\u671f\u6c47\u7387\u9700\u5927\u4e8e0\u3002", (String)"BusinessBillSubmitOpValidator_17", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }

    private void verifyPlInfo(ExtendedDataEntity data, DynamicObject bill) {
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        if (plCurrency == null) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u635f\u76ca\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_15", (String)"tmc-tm-business", (Object[])new Object[0]));
            return;
        }
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)bill.getDynamicObject("org").getLong("id"));
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        if (plCurrency.getLong("id") != localCurrencyId.longValue() && BigDecimal.ZERO.compareTo(bill.getBigDecimal("baseexrate")) >= 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u635f\u76ca\u4fe1\u606f\u7684\u6298\u672c\u4f4d\u5e01\u6c47\u7387\u9700\u5927\u4e8e0\u3002", (String)"BusinessBillSubmitOpValidator_8", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private void verifyBizAmt(ExtendedDataEntity data, DynamicObject bill) {
        BigDecimal bizAmt1 = bill.getBigDecimal("bizamt1");
        if (BigDecimal.ZERO.compareTo(bizAmt1) == 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"BusinessBillSubmitOpValidator_10", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private void verifyDeliveryDate(ExtendedDataEntity data, DynamicObject bill) {
        Date deliveryDate = bill.getDate("deliverydate");
        if (EmptyUtil.isEmpty((Object)deliveryDate)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessBillSubmitOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

