/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.combreqnote;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.CombReqNoteEnum;

public class CombReqNotePushTradeValidator
extends AbstractTmcBizOppValidator {
    CombReqNoteEnum combReqNoteEnum;

    public CombReqNotePushTradeValidator() {
    }

    public CombReqNotePushTradeValidator(CombReqNoteEnum combReqNoteEnum) {
        this.combReqNoteEnum = combReqNoteEnum;
    }

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("composeno");
        for (CombReqNoteEnum combReqNote : CombReqNoteEnum.values()) {
            selector.add(combReqNote.getEntryName());
            selector.add(combReqNote.getBillIdName());
            selector.add(combReqNote.getGenbizbillField());
        }
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        for (ExtendedDataEntity data : entities) {
            boolean hasNotPushBizBill;
            DynamicObject bill = data.getDataEntity();
            String billStatus = bill.getString("billstatus");
            if (!TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u4ea4\u6613\u7533\u8bf7\u5355\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CombReqNotePushTradeValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            if (!(hasNotPushBizBill = this.hasNotPushBizBill(bill))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u63a8\u7684\u6570\u636e\u3002", (String)"CombReqNotePushTradeValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if (!EmptyUtil.isNotEmpty((CharSequence)bill.getString("composeno"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u63a8\u7684\u4ea4\u6613\u5355\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u7ec4\u5408\u4ea4\u6613\u5355\u3002", (String)"CombReqNotePushTradeValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private boolean hasNotPushBizBill(DynamicObject bill) {
        if (this.getCombReqNote() == null) {
            for (CombReqNoteEnum combReqNote : CombReqNoteEnum.values()) {
                if (!this.hasNotPush(bill, combReqNote)) continue;
                return true;
            }
        } else {
            CombReqNoteEnum combReqNote = this.getCombReqNote();
            if (this.hasNotPush(bill, combReqNote)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasNotPush(DynamicObject bill, CombReqNoteEnum combReqNote) {
        DynamicObjectCollection entries = bill.getDynamicObjectCollection(combReqNote.getEntryName());
        for (DynamicObject entry : entries) {
            boolean isGenBizBill = entry.getBoolean(combReqNote.getGenbizbillField());
            if (isGenBizBill) continue;
            return true;
        }
        return false;
    }

    protected CombReqNoteEnum getCombReqNote() {
        return this.combReqNoteEnum;
    }
}

