/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.combreqnote;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.ReqNoteEnum;

public class CombReqNoteSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("spotinfo");
        selector.add("spotcurrencytypein");
        selector.add("spotcurrencytypeout");
        selector.add("spotamountin");
        selector.add("spotamountout");
        selector.add("spbizdate");
        selector.add("swapsinfo");
        selector.add("currin");
        selector.add("currout");
        selector.add("amtin");
        selector.add("amtout");
        selector.add("swbizdate");
        selector.add("swsettledate");
        selector.add("forwardinfo");
        selector.add("currencytypein");
        selector.add("currencytypeout");
        selector.add("amountin");
        selector.add("amountout");
        selector.add("fobizdate");
        selector.add("isoptionaltraction");
        selector.add("deliverydate");
        selector.add("deliveryenddate");
        selector.add("producttype");
        selector.add("limtno");
        selector.add("optionsinfo");
        selector.add("opcurrin");
        selector.add("opcurrout");
        selector.add("opamtin");
        selector.add("opamtout");
        selector.add("opbizdate");
        selector.add("opdeliverydate");
        selector.add("opbustype");
        selector.add("exerate");
        selector.add("deliverystartdate");
        selector.add("deliveryenddate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        for (ExtendedDataEntity data : entities) {
            DynamicObject entity = data.getDataEntity();
            DynamicObjectCollection productTypes = entity.getDynamicObjectCollection("producttype");
            for (DynamicObject productType : productTypes) {
                String productTypeNumber = productType.getDynamicObject("fbasedataid").getString("number");
                String entryName = ReqNoteEnum.getEntryByNumber((String)productTypeNumber);
                String entityName = ReqNoteEnum.getEnityByNumber((String)productTypeNumber);
                DynamicObjectCollection entry = entity.getDynamicObjectCollection(entryName);
                if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u7533\u8bf7\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReqNoteSubmitValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                    continue;
                }
                this.checkDeldate(data, entityName, entry);
                this.checkBusinesstype(data, entity, productTypeNumber);
            }
        }
    }

    private void checkDeldate(ExtendedDataEntity data, String entityName, DynamicObjectCollection entry) {
        if ("tm_reqnote_forward".equals(entityName)) {
            for (DynamicObject row : entry) {
                if (row.getBoolean("isoptionaltraction")) {
                    Date delstdate = row.getDate("deliverystartdate");
                    Date delenddate = row.getDate("deliveryenddate");
                    if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{delstdate, delenddate})) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u533a\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReqNoteSubmitValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
                    continue;
                }
                Date deldate = row.getDate("deliverydate");
                if (!EmptyUtil.isEmpty((Object)deldate)) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReqNoteSubmitValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkBusinesstype(ExtendedDataEntity data, DynamicObject entity, String productTypeNumber) {
        DynamicObjectCollection spotInfos = entity.getDynamicObjectCollection("spotinfo");
        DynamicObjectCollection forwardInfos = entity.getDynamicObjectCollection("forwardinfo");
        if (ProductTypeEnum.FOREXSPOT.getValue().equals(productTypeNumber) && spotInfos != null) {
            for (DynamicObject spotInfo : spotInfos) {
                this.validateAmount(data, spotInfo, "spotamountin", "spotamountout");
            }
        }
        if (ProductTypeEnum.FOREXFORWARD.getValue().equals(productTypeNumber) && forwardInfos != null) {
            for (DynamicObject forwardInfo : forwardInfos) {
                this.validateAmount(data, forwardInfo, "amountin", "amountout");
            }
        }
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(productTypeNumber)) {
            for (DynamicObject forwardInfo : entity.getDynamicObjectCollection("optionsinfo")) {
                this.validateAmount(data, forwardInfo, "opamtin", "opamtout");
                if (!EmptyUtil.isEmpty((Object)forwardInfo.get("exerate"))) continue;
                this.addErrorMessage(data, "");
            }
        }
        if (ProductTypeEnum.FOREXSWAPS.getValue().equals(productTypeNumber)) {
            for (DynamicObject forwardInfo : entity.getDynamicObjectCollection("swapsinfo")) {
                this.validateAmount(data, forwardInfo, "amtin", "amtout");
            }
        }
    }

    protected void validateAmount(ExtendedDataEntity data, DynamicObject info, String amountInName, String amountOutName) {
        BigDecimal amountIn = info.getBigDecimal(amountInName);
        BigDecimal amountOut = info.getBigDecimal(amountOutName);
        if (EmptyUtil.isEmpty((BigDecimal)amountIn) && EmptyUtil.isEmpty((BigDecimal)amountOut)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e70\u5165\u91d1\u989d\u548c\u5356\u51fa\u91d1\u989d\u81f3\u5c11\u586b\u4e00\u4e2a\u3002", (String)"ReqNoteSubmitValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

