/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.combreqnote;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.CombReqNoteEnum;

public class CombReqNoteUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("composeno");
        for (CombReqNoteEnum combReqNote : CombReqNoteEnum.values()) {
            selector.add(combReqNote.getEntryName());
            selector.add(combReqNote.getBillIdName());
        }
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        for (ExtendedDataEntity data : entities) {
            DynamicObject bill = data.getDataEntity();
            String composeno = bill.getString("composeno");
            if (!EmptyUtil.isNotEmpty((CharSequence)composeno) && !this.hasBizBill(bill)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5173\u8054\u7684\u4ea4\u6613\u5355\u636e\u5df2\u505a\u540e\u7eed\u64cd\u4f5c\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CombReqNoteUnAuditValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private boolean hasBizBill(DynamicObject bill) {
        ArrayList list = new ArrayList();
        for (CombReqNoteEnum combReqNote : CombReqNoteEnum.values()) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(combReqNote.getEntryName());
            List ids = entries.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            list.addAll(ids);
        }
        QFilter qFilter = new QFilter("sourcebillid", "in", list);
        return TmcDataServiceHelper.exists((String)"tm_trade", (QFilter[])qFilter.toArray());
    }
}

