/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.combtrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CombTradeSubmitOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        List sel = super.getSelector();
        sel.add("billno");
        sel.add("tradebill");
        sel.add("name");
        sel.add("protecttype");
        sel.add("tradedirect");
        sel.add("tradedate");
        sel.add("tradebillentity");
        sel.add("tradeorg");
        sel.add("entryentity");
        sel.add("tradebillno");
        sel.add("reqnoteno");
        return sel;
    }

    public void validate(ExtendedDataEntity[] DataEntity) throws KDBizException {
        ArrayList<Long> tradeIds = new ArrayList<Long>(10);
        for (ExtendedDataEntity entity : DataEntity) {
            String composeno;
            DynamicObject combreqnote;
            DynamicObject dataEntity = entity.getDataEntity();
            String reqnoteno = dataEntity.getString("reqnoteno");
            String billno = dataEntity.getString("billno");
            if (EmptyUtil.isNotEmpty((CharSequence)reqnoteno) && (combreqnote = QueryServiceHelper.queryOne((String)"tm_combreqnote", (String)"composeno", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reqnoteno)})) != null && EmptyUtil.isNotEmpty((CharSequence)(composeno = combreqnote.getString("composeno"))) && !StringUtils.equals((CharSequence)composeno, (CharSequence)billno)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ec4\u5408\u4ea4\u6613\u5df2\u4e0b\u63a8\uff0c\u4e0d\u80fd\u91cd\u590d\u4e0b\u63a8\u3002", (String)"CombTradeSubmitOpValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
            if (entryentity.size() <= 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ec4\u5408\u4fe1\u606f\u6ca1\u6709\u4ea4\u6613\u8bb0\u5f55\uff0c\u8bf7\u589e\u52a0\u3002", (String)"CombTradeSubmitOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection currOrgs = entity.getDataEntity().getDynamicObjectCollection("org");
            List<Object> orgIds = new ArrayList(currOrgs.size());
            if (currOrgs != null) {
                orgIds = currOrgs.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
            }
            HashSet<String> dupTradeNoSet = new HashSet<String>(5);
            for (DynamicObject dynamicObject : entryentity) {
                Long billId = dynamicObject.getLong("tradebill");
                String tradeBillNO = dynamicObject.getString("tradebillno");
                String tradeBillEntity = dynamicObject.getString("tradebillentity");
                DynamicObject bill = QueryServiceHelper.queryOne((String)tradeBillEntity, (String)"org,billno, composeno, billstatus,composeaudit", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billId)});
                if (bill != null) {
                    boolean validStatus;
                    if (!orgIds.contains(bill.getLong("org"))) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4ea4\u6613\u53f7\uff1a{0}\u7684\u7ec4\u7ec7\u4e0d\u662f\u4ea4\u6613\u4e3b\u4f53\u5305\u542b\u7684\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CombTradeSubmitOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[]{tradeBillNO}));
                    }
                    String composeno2 = bill.getString("composeno");
                    String billstatus = bill.getString("billstatus");
                    Boolean composeaudit = bill.getBoolean("composeaudit");
                    boolean bl = validStatus = "C,D".contains(billstatus) || "B".equals(billstatus) && Boolean.TRUE.equals(composeaudit);
                    if (!validStatus || composeno2 != null && !StringUtils.equals((CharSequence)"", (CharSequence)composeno2) && !StringUtils.equals((CharSequence)" ", (CharSequence)composeno2)) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4ea4\u6613\u53f7\uff1a{0}\u4e0d\u6ee1\u8db3\u6784\u5efa\u7ec4\u5408\u7684\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CombTradeSubmitOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[]{bill.getString("billno")}));
                    }
                } else {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4ea4\u6613\u53f7\uff1a{0}\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CombTradeSubmitOpValidator_5", (String)"tmc-tm-business", (Object[])new Object[]{tradeBillNO}));
                }
                if (!tradeIds.contains(billId)) {
                    tradeIds.add(billId);
                    continue;
                }
                dupTradeNoSet.add(tradeBillNO);
            }
            if (dupTradeNoSet.size() <= 0) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u4ea4\u6613\u4e2d\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CombTradeSubmitOpValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

