/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.lifecycle;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LifeCycleApplySaveOrSubmitOpValidator
extends AbstractTmcBizOppValidator {
    private static final String OP_TYPE_DEFER = "defer";
    private static final String OP_TYPE_MAUDATE = "maudate";
    private static final String OP_TYPE_BDELIVERY = "bdelivery";
    private static final String OP_TYPE_EXERCISE = "exercise";

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("applydate");
        sic.add("tradetype");
        sic.add("lifecycleoperation");
        sic.add("applydeliverydate");
        sic.add("ischoosedate");
        sic.add("expiredatestart");
        sic.add("tradeno");
        sic.add("opdate");
        sic.add("currentselectedcardid");
        return sic;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : entities) {
            DynamicObject tradeBill = dataEntity.getDataEntity().getDynamicObject("tradeno");
            Object currentSelectedCardId = dataEntity.getDataEntity().get("currentselectedcardid");
            if (EmptyUtil.isNoEmpty((DynamicObject)tradeBill) && !QueryServiceHelper.exists((String)"tm_forex_forward", (QFilter[])new QFilter("id", "=", tradeBill.getPkValue()).and("billstatus", "=", (Object)TcBillStatusEnum.SURVIVAL.getValue()).toArray())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4ea4\u6613\u5355\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4ea4\u6613\u6267\u884c\u751f\u547d\u5468\u671f\u64cd\u4f5c\u7533\u8bf7\u3002", (String)"LifeCycleApplyHelper_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if (EmptyUtil.isNoEmpty((Object)currentSelectedCardId) && !QueryServiceHelper.exists((String)"tm_bizrecord", (QFilter[])new QFilter("id", "=", currentSelectedCardId).toArray())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4ea4\u6613\u5355\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4ea4\u6613\u6267\u884c\u751f\u547d\u5468\u671f\u64cd\u4f5c\u7533\u8bf7\u3002", (String)"LifeCycleApplyHelper_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            this.validate(dataEntity);
        }
    }

    private void validate(ExtendedDataEntity dataEntity) {
        DynamicObject tradeType;
        this.validateBaseInfo(dataEntity);
        if (dataEntity.getValue("applydate") == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u65e5\u3002", (String)"LifeCycleApplySaveOrSubmitOp_1", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if ((tradeType = (DynamicObject)dataEntity.getValue("tradetype")) == null) {
            return;
        }
        String tradeTypeNumber = tradeType.getString("number");
        if (OP_TYPE_BDELIVERY.equals(dataEntity.getValue("lifecycleoperation")) || OP_TYPE_EXERCISE.equals(dataEntity.getValue("lifecycleoperation"))) {
            if (dataEntity.getValue("applydeliverydate") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea4\u5272\u65e5\u3002", (String)"LifeCycleApplySaveOrSubmitOp_3", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        } else if (ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber) && (OP_TYPE_DEFER.equals(dataEntity.getValue("lifecycleoperation")) || OP_TYPE_MAUDATE.equals(dataEntity.getValue("lifecycleoperation")))) {
            if (dataEntity.getValue("applydeliverydate") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea4\u5272\u65e5\u3002", (String)"LifeCycleApplySaveOrSubmitOp_3", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        } else if (ProductTypeEnum.FOREXFORWARD.getValue().equals(tradeTypeNumber) && (OP_TYPE_DEFER.equals(dataEntity.getValue("lifecycleoperation")) || OP_TYPE_MAUDATE.equals(dataEntity.getValue("lifecycleoperation")))) {
            if (((Boolean)dataEntity.getValue("ischoosedate")).booleanValue() && dataEntity.getValue("expiredatestart") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea4\u5272\u65e5\u533a\u95f4\u3002", (String)"LifeCycleApplySaveOrSubmitOp_5", (String)"tmc-tm-business", (Object[])new Object[0]));
            } else if (!((Boolean)dataEntity.getValue("ischoosedate")).booleanValue() && dataEntity.getValue("applydeliverydate") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea4\u5272\u65e5\u3002", (String)"LifeCycleApplySaveOrSubmitOp_3", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateBaseInfo(ExtendedDataEntity dataEntity) {
        if (dataEntity.getValue("tradetype") == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea7\u54c1\u7c7b\u578b\u3002", (String)"LifeCycleApplySaveOrSubmitOp_7", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if (dataEntity.getValue("tradeno") == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea4\u6613\u53f7\u3002", (String)"LifeCycleApplySaveOrSubmitOp_8", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)dataEntity.getValue("lifecycleoperation"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u547d\u5468\u671f\u64cd\u4f5c\u3002", (String)"LifeCycleApplySaveOrSubmitOp_9", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)dataEntity.getValue("opdate"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u65e5\u3002", (String)"LifeCycleApplySaveOrSubmitOp_10", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

