/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.rate;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.SwapTypeEnum;

public class RateSwapSaveOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("pricerule");
        sic.add("currency");
        sic.add("reccurrency");
        sic.add("rateswaptype");
        sic.add("org");
        return sic;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            this.checkForexQuote(data, bill);
        }
    }

    private void checkForexQuote(ExtendedDataEntity data, DynamicObject bill) {
        String swapType = bill.getString("rateswaptype");
        if (SwapTypeEnum.currency.getValue().equals(swapType)) {
            Long baseCurrencyID;
            boolean isBaseCurrency;
            DynamicObject pricerule;
            DynamicObject currency = bill.getDynamicObject("currency");
            DynamicObject recCurrency = bill.getDynamicObject("reccurrency");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{recCurrency, currency, pricerule = bill.getDynamicObject("pricerule")})) {
                return;
            }
            String pair = recCurrency.getString("number") + "/" + currency.getString("number");
            DynamicObject fqInfo = pricerule.getDynamicObject("forexquote");
            MarketDataServiceHelper.getForexQuoteInfo((Long)fqInfo.getLong("id"), (String)pair, null, null);
            Long orgId = (Long)bill.getDynamicObject("org").getPkValue();
            Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
            if (EmptyUtil.isNoEmpty((Object)result) && !(isBaseCurrency = this.isBaseCurrency(bill, baseCurrencyID = (Long)result.get("baseCurrencyID")))) {
                DynamicObject baseCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)baseCurrencyID, (String)"bd_currency", (String)"number");
                String currencyPair = currency.getString("number") + "/" + baseCurrency.getString("number");
                MarketDataServiceHelper.getForexQuoteInfo((Long)fqInfo.getLong("id"), (String)currencyPair, null, null);
                String recCurrencyPair = recCurrency.getString("number") + "/" + baseCurrency.getString("number");
                MarketDataServiceHelper.getForexQuoteInfo((Long)fqInfo.getLong("id"), (String)recCurrencyPair, null, null);
            }
        }
    }

    protected boolean isBaseCurrency(DynamicObject bill, Long baseCurrencyID) {
        DynamicObject payCurrency = bill.getDynamicObject("currency");
        DynamicObject recCurrency = bill.getDynamicObject("reccurrency");
        boolean isBaseCurrency = !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{baseCurrencyID, payCurrency}) && baseCurrencyID.equals(payCurrency.getPkValue()) || !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{baseCurrencyID, recCurrency}) && baseCurrencyID.equals(recCurrency.getPkValue());
        return isBaseCurrency;
    }
}

