/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.rate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.RateSwapsPayTypeEnum;
import kd.tmc.tm.common.enums.RateTypeEnum;
import kd.tmc.tm.common.enums.SwapExchangeType;
import kd.tmc.tm.common.enums.SwapTypeEnum;

public class RateSwapSubmitOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("initexamount");
        sic.add("recinitexamount");
        sic.add("amount");
        sic.add("recamount");
        sic.add("valuedate");
        sic.add("recvaluedate");
        sic.add("payfrequency");
        sic.add("recpayfrequency");
        sic.add("firstpaycopdate");
        sic.add("recfirstpaycopdate");
        sic.add("enddate");
        sic.add("rateswaptype");
        sic.add("paytype");
        sic.add("recpaytype");
        sic.add("stub");
        sic.add("stubtype");
        sic.add("firstpaycopdate");
        sic.add("penupaycopdate");
        sic.add("recstub");
        sic.add("recstubtype");
        sic.add("recfirstpaycopdate");
        sic.add("recpenupaycopdate");
        sic.add("initpriextype");
        sic.add("ratetype");
        sic.add("recratetype");
        sic.add("fixedrate");
        sic.add("recfixedrate");
        sic.add("firstreferrate");
        sic.add("recfirstreferrate");
        sic.add("penureferrate");
        sic.add("recpenureferrate");
        sic.add("pricerule");
        sic.add("currency");
        sic.add("reccurrency");
        sic.add("ratequotafreq");
        sic.add("recratequotafreq");
        sic.add("rateresetfreq");
        sic.add("recrateresetfreq");
        sic.add("term");
        sic.add("org");
        sic.add("counterparty");
        sic.add("bizdate");
        sic.add("settledelay");
        sic.add("startdate");
        sic.add("endadjmethod");
        sic.add("refindex");
        sic.add("endpriextype");
        sic.add("basis");
        sic.add("recbasis");
        sic.add("market");
        sic.add("recmarket");
        sic.add("beforeinitdate");
        sic.add("recbeforeinitdate");
        sic.add("rateadjustmethod");
        sic.add("recrateadjustmethod");
        sic.add("rateresetoffset");
        sic.add("recrateresetoffset");
        sic.add("rateresettype");
        sic.add("recrateresettype");
        sic.add("refindex");
        sic.add("recrefindex");
        sic.add("adjustedenddate");
        sic.add("paycashflow");
        sic.add("reccashflow");
        return sic;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            this.checkPayFreq(data, bill, Boolean.TRUE);
            this.checkPayFreq(data, bill, Boolean.FALSE);
            this.checkStub(data, bill, Boolean.TRUE);
            this.checkStub(data, bill, Boolean.FALSE);
            this.checkFixedRate(data, bill, Boolean.TRUE);
            this.checkFixedRate(data, bill, Boolean.FALSE);
            this.checkRateResetFreq(data, bill, Boolean.TRUE);
            this.checkRateResetFreq(data, bill, Boolean.FALSE);
            this.checkInitExAmt(data, bill);
            this.checkPricerule(data, bill);
            this.checkForexQuote(bill);
            this.checkMustInput(data, bill);
        }
    }

    private void checkMustInput(ExtendedDataEntity data, DynamicObject bill) {
        String swapType = bill.getString("rateswaptype");
        boolean isCurency = SwapTypeEnum.currency.getValue().equals(swapType);
        this.checkEmpty(data, bill, "term", "enddate", "org", "counterparty", "rateswaptype", "bizdate", "startdate", "endadjmethod", "adjustedenddate");
        this.checkLargeEqualsZero(data, bill, "settledelay");
        if (isCurency) {
            this.checkEmpty(data, bill, "initpriextype", "endpriextype");
        }
        this.checkEmpty(data, bill, "ratetype", "currency", "market", "amount", "valuedate", "basis");
        String ratetype = bill.getString("ratetype");
        boolean isPayFloat = RateTypeEnum.rate_float.getValue().equals(ratetype);
        if (isPayFloat) {
            this.checkEmpty(data, bill, "refindex", "rateresettype");
            this.checkLargeEqualsZero(data, bill, "rateresetoffset");
        }
        this.checkEmpty(data, bill, "recratetype", "reccurrency", "recmarket", "recamount", "recvaluedate", "recbasis");
        String recratetype = bill.getString("recratetype");
        boolean isrecFloat = RateTypeEnum.rate_float.getValue().equals(recratetype);
        if (isrecFloat) {
            this.checkEmpty(data, bill, "recrefindex", "recrateresettype");
            this.checkLargeEqualsZero(data, bill, "recrateresetoffset");
        }
        this.checkCashFlowEmpty(data, bill);
    }

    private void checkCashFlowEmpty(ExtendedDataEntity data, DynamicObject bill) {
        if (this.getOption().containsVariable("cashFlowParam")) {
            return;
        }
        DynamicObjectCollection paycashflow = bill.getDynamicObjectCollection("paycashflow");
        DynamicObjectCollection reccashflow = bill.getDynamicObjectCollection("reccashflow");
        QFilter filter = new QFilter("billid", "=", bill.get("id"));
        QFilter filter_buy = new QFilter("cfdirection", "=", (Object)"buy");
        QFilter filter_sell = new QFilter("cfdirection", "=", (Object)"sell");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)paycashflow) && !QueryServiceHelper.exists((String)"tm_cashflow", (QFilter[])new QFilter[]{filter, filter_buy})) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u652f\u4ed8\u73b0\u91d1\u6d41\u672a\u751f\u6210\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RateSwapSubmitOpValidator_15", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)reccashflow) && !QueryServiceHelper.exists((String)"tm_cashflow", (QFilter[])new QFilter[]{filter, filter_sell})) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u6536\u53d6\u73b0\u91d1\u6d41\u672a\u751f\u6210\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RateSwapSubmitOpValidator_16", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private void checkEmpty(ExtendedDataEntity data, DynamicObject bill, String ... fields) {
        for (String field : fields) {
            DynamicObject dataEntity = data.getDataEntity();
            DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
            Object value = bill.get(field);
            if (!EmptyUtil.isEmpty((Object)value)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"RateSwapSubmitOpValidator_14", (String)"tmc-tm-business", (Object[])new Object[]{dynamicObjectType.getProperty(field).getDisplayName().getLocaleValue()}));
        }
    }

    private void checkLargeEqualsZero(ExtendedDataEntity data, DynamicObject bill, String ... fields) {
        for (String field : fields) {
            DynamicObject dataEntity = data.getDataEntity();
            DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
            Object value = bill.get(field);
            if (value == null) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"RateSwapSubmitOpValidator_14", (String)"tmc-tm-business", (Object[])new Object[]{dynamicObjectType.getProperty(field).getDisplayName().getLocaleValue()}));
                continue;
            }
            String str = String.valueOf(value);
            boolean contains = str.contains("-");
            if (!contains) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"RateSwapSubmitOpValidator_14", (String)"tmc-tm-business", (Object[])new Object[]{dynamicObjectType.getProperty(field).getDisplayName().getLocaleValue()}));
        }
    }

    private void checkForexQuote(DynamicObject bill) {
        String swapType = bill.getString("rateswaptype");
        if (SwapTypeEnum.currency.getValue().equals(swapType)) {
            DynamicObject currency = bill.getDynamicObject("currency");
            DynamicObject recCurrency = bill.getDynamicObject("reccurrency");
            DynamicObject pricerule = bill.getDynamicObject("pricerule");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currency, recCurrency, pricerule})) {
                String pair = recCurrency.getString("number") + "/" + currency.getString("number");
                DynamicObject fqInfo = pricerule.getDynamicObject("forexquote");
                MarketDataServiceHelper.getForexQuoteInfo((Long)fqInfo.getLong("id"), (String)pair, null, null);
            }
        }
    }

    private void checkPricerule(ExtendedDataEntity data, DynamicObject bill) {
        DynamicObject pricerule = bill.getDynamicObject("pricerule");
        if (pricerule == null) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b9a\u4ef7\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RateSwapSubmitOpValidator_12", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private void checkFixedRate(ExtendedDataEntity data, DynamicObject bill, Boolean isPay) {
        String rateType;
        String string = rateType = isPay != false ? bill.getString("ratetype") : bill.getString("recratetype");
        if (RateTypeEnum.rate_fixed.getValue().equals(rateType)) {
            BigDecimal fixedRate;
            BigDecimal bigDecimal = fixedRate = isPay != false ? bill.getBigDecimal("fixedrate") : bill.getBigDecimal("recfixedrate");
            if (EmptyUtil.isEmpty((BigDecimal)fixedRate)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u56fa\u5b9a\u5229\u7387\u9700\u5927\u4e8e0\u3002", (String)"RateSwapSubmitOpValidator_7", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkRateResetFreq(ExtendedDataEntity data, DynamicObject bill, Boolean isPay) {
        String ratetype;
        String ratequotafreq = isPay != false ? bill.getString("ratequotafreq") : bill.getString("recratequotafreq");
        String string = ratetype = isPay != false ? bill.getString("ratetype") : bill.getString("recratetype");
        if (RateTypeEnum.rate_float.getValue().equals(ratetype) && "regular".equals(ratequotafreq)) {
            BigDecimal rateresetfreq = isPay != false ? bill.getBigDecimal("rateresetfreq") : bill.getBigDecimal("recrateresetfreq");
            BigDecimal bigDecimal = rateresetfreq = rateresetfreq == null ? BigDecimal.ZERO : rateresetfreq;
            if (rateresetfreq.compareTo(BigDecimal.ZERO) <= 0 || rateresetfreq.compareTo(BigDecimal.valueOf(12L)) > 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53c2\u8003\u5229\u7387\u91cd\u7f6e\u9891\u7387\u5fc5\u987b\u4e3a1\u81f312\u7684\u6574\u6570\u3002", (String)"RateSwapSubmitOpValidator_13", (String)"tmc-tm-business", (Object[])new Object[0]));
            } else if (new BigDecimal(rateresetfreq.intValue()).compareTo(rateresetfreq) != 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53c2\u8003\u5229\u7387\u91cd\u7f6e\u9891\u7387\u5fc5\u987b\u4e3a1\u81f312\u7684\u6574\u6570\u3002", (String)"RateSwapSubmitOpValidator_13", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            String beforeinitdate = isPay != false ? "beforeinitdate" : "recbeforeinitdate";
            String rateadjustmethod = isPay != false ? "rateadjustmethod" : "recrateadjustmethod";
            this.checkEmpty(data, bill, beforeinitdate, rateadjustmethod);
        }
    }

    private void checkInitExAmt(ExtendedDataEntity data, DynamicObject bill) {
        if (bill.getString("rateswaptype").equals(SwapTypeEnum.currency.getValue()) && SwapExchangeType.Actual.getValue().equals(bill.getString("initpriextype"))) {
            BigDecimal recInitExAmount;
            BigDecimal initExAmount = bill.getBigDecimal("initexamount");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{initExAmount, recInitExAmount = bill.getBigDecimal("recinitexamount")})) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u671f\u521d\u672c\u91d1\u4ea4\u6362\u91d1\u989d\u3002", (String)"RateSwapSubmitOpValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]));
            } else {
                BigDecimal amount = bill.getBigDecimal("amount");
                BigDecimal recAmount = bill.getBigDecimal("recamount");
                if (EmptyUtil.isEmpty((BigDecimal)recAmount)) {
                    return;
                }
                if (initExAmount.divide(recInitExAmount, 6, RoundingMode.HALF_UP).abs().compareTo(amount.divide(recAmount, 6, RoundingMode.HALF_UP).abs()) != 0) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8f93\u5165\u7684\u671f\u521d\u672c\u91d1\u4ea4\u6362\u91d1\u989d\u4e0d\u5408\u6cd5\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RateSwapSubmitOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
            }
        }
    }

    private void checkPayFreq(ExtendedDataEntity data, DynamicObject bill, Boolean isPay) {
        String payType;
        String string = payType = isPay != false ? bill.getString("paytype") : bill.getString("recpaytype");
        if (RateSwapsPayTypeEnum.pay_stages.getValue().equals(payType)) {
            String payFreq;
            String string2 = payFreq = isPay != false ? bill.getString("payfrequency") : bill.getString("recpayfrequency");
            if (EmptyUtil.isEmpty((String)payFreq)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u652f\u4ed8\u9891\u7387\u3002", (String)"RateSwapSubmitOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkStub(ExtendedDataEntity data, DynamicObject bill, Boolean isPay) {
        if (isPay != false ? bill.getBoolean("stub") : bill.getBoolean("recstub")) {
            String rateType;
            String stubType;
            String string = stubType = isPay != false ? bill.getString("stubtype") : bill.getString("recstubtype");
            if (EmptyUtil.isEmpty((String)stubType)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u606f\u6b8b\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RateSwapSubmitOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            String string2 = rateType = isPay != false ? bill.getString("ratetype") : bill.getString("recratetype");
            if ("front".equals(stubType)) {
                DynamicObject firstRefRate;
                Date firstDate;
                Date date = firstDate = isPay != false ? bill.getDate("firstpaycopdate") : bill.getDate("recfirstpaycopdate");
                if (EmptyUtil.isEmpty((Object)firstDate)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u9996\u6b21\u4ed8\u606f\u65e5\u671f\u3002", (String)"RateSwapSubmitOpValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
                DynamicObject dynamicObject = firstRefRate = isPay != false ? bill.getDynamicObject("firstreferrate") : bill.getDynamicObject("recfirstreferrate");
                if (RateTypeEnum.rate_float.getValue().equals(rateType) && EmptyUtil.isEmpty((DynamicObject)firstRefRate)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u9996\u6b21\u53c2\u8003\u5229\u7387\u3002", (String)"RateSwapSubmitOpValidator_8", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
            }
            if ("end".equals(stubType)) {
                DynamicObject penuRefRate;
                Date penuDate;
                Date date = penuDate = isPay != false ? bill.getDate("penupaycopdate") : bill.getDate("recpenupaycopdate");
                if (EmptyUtil.isEmpty((Object)penuDate)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5012\u6570\u7b2c\u4e8c\u6b21\u4ed8\u606f\u65e5\u671f\u3002", (String)"RateSwapSubmitOpValidator_5", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
                DynamicObject dynamicObject = penuRefRate = isPay != false ? bill.getDynamicObject("penureferrate") : bill.getDynamicObject("recpenureferrate");
                if (RateTypeEnum.rate_float.getValue().equals(rateType) && EmptyUtil.isEmpty((DynamicObject)penuRefRate)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5012\u6570\u7b2c\u4e8c\u6b21\u53c2\u8003\u5229\u7387\u3002", (String)"RateSwapSubmitOpValidator_9", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
            }
        }
    }
}

