/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.requestnote;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.CombReqNoteEnum;
import kd.tmc.tm.common.helper.ReqNoteHelper;

public class ReqNoteLimitOccValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("spotinfo");
        selector.add("spotcurrencytypein");
        selector.add("spotcurrencytypeout");
        selector.add("spotamountin");
        selector.add("spotamountout");
        selector.add("swapsinfo");
        selector.add("currin");
        selector.add("currout");
        selector.add("amtin");
        selector.add("amtout");
        selector.add("forwardinfo");
        selector.add("currencytypein");
        selector.add("currencytypeout");
        selector.add("amountin");
        selector.add("amountout");
        selector.add("optionsinfo");
        selector.add("opcurrin");
        selector.add("opcurrout");
        selector.add("opamtin");
        selector.add("opamtout");
        selector.add("limtno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDException {
        HashMap<Long, List> datas = new HashMap<Long, List>(entities.length);
        for (ExtendedDataEntity data : entities) {
            DynamicObject product;
            String productType;
            DynamicObject dataEntity = data.getDataEntity();
            DynamicObject limit = dataEntity.getDynamicObject("limtno");
            if (EmptyUtil.isEmpty((DynamicObject)limit) || EmptyUtil.isEmpty((String)(productType = (product = dataEntity.getDynamicObject("producttype")).getString("number")))) continue;
            this.validateProductType(data, productType);
            long limitId = limit.getLong("id");
            if (datas.containsKey(limitId)) {
                List list = (List)datas.get(limitId);
                list.add(data);
                datas.put(limitId, list);
                continue;
            }
            ArrayList<ExtendedDataEntity> reqNoteBills = new ArrayList<ExtendedDataEntity>();
            reqNoteBills.add(data);
            datas.put(limitId, reqNoteBills);
        }
        for (Map.Entry entry : datas.entrySet()) {
            Long limitId = (Long)entry.getKey();
            List reqNoteList = (List)entry.getValue();
            DynamicObject limitDb = TmcDataServiceHelper.loadSingle((Object)limitId, (String)"tm_reqlimit");
            if (EmptyUtil.isEmpty((DynamicObject)limitDb)) continue;
            DynamicObjectCollection limitEntries = limitDb.getDynamicObjectCollection("entryentity");
            HashMap<Long, DynamicObject> limitCurrAmtMap = new HashMap<Long, DynamicObject>();
            for (DynamicObject limitEntry : limitEntries) {
                DynamicObject curr = limitEntry.getDynamicObject("currency");
                Long currId = (Long)curr.getPkValue();
                limitCurrAmtMap.put(currId, limitEntry);
            }
            this.validateLimitAmt(limitDb, limitCurrAmtMap, reqNoteList);
        }
    }

    private void validateLimitAmt(DynamicObject limit, Map<Long, DynamicObject> limitCurrAmtMap, List<ExtendedDataEntity> reqNoteList) {
        HashMap<Long, BigDecimal> reqnoteCurrencyAmtMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, String> reqnoteCurrencyMap = new HashMap<Long, String>();
        for (ExtendedDataEntity extendedDataEntity : reqNoteList) {
            String entryName;
            DynamicObjectCollection reqNoteEntries;
            DynamicObject entity = extendedDataEntity.getDataEntity();
            DynamicObject product = entity.getDynamicObject("producttype");
            String productType = product.getString("number");
            CombReqNoteEnum combReqNoteEnum = CombReqNoteEnum.getByProductType((String)productType);
            if (combReqNoteEnum == null || EmptyUtil.isEmpty((DynamicObjectCollection)(reqNoteEntries = entity.getDynamicObjectCollection(entryName = combReqNoteEnum.getEntryName())))) continue;
            this.validateIsUsed(extendedDataEntity, limit);
            ReqNoteHelper.sumReqNoteCurrAndAmt((DynamicObjectCollection)reqNoteEntries, (CombReqNoteEnum)combReqNoteEnum, reqnoteCurrencyAmtMap, reqnoteCurrencyMap);
        }
        this.validateLimitCurrencyAmt(limit, limitCurrAmtMap, reqnoteCurrencyAmtMap, reqnoteCurrencyMap);
    }

    private void validateIsUsed(ExtendedDataEntity extendedDataEntity, DynamicObject limit) {
        DynamicObject entity = extendedDataEntity.getDataEntity();
        long reqId = entity.getLong("id");
        long limitId = limit.getLong("id");
        String limitBillNo = limit.getString("billno");
        QFilter qf = new QFilter("limitid", "=", (Object)limitId);
        qf.and(new QFilter("entryentity.billid", "=", (Object)reqId));
        if (QueryServiceHelper.exists((String)"tm_reqlimit_use", (QFilter[])qf.toArray())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u5360\u7528\u8fc7\u5916\u6c47\u989d\u5ea6\u5355%s\u3002", (String)"ReqNoteLimitOccValidator_4", (String)"tmc-tm-business", (Object[])new Object[]{limitBillNo}));
        }
    }

    private void validateProductType(ExtendedDataEntity data, String productType) {
        DynamicObjectCollection limitProductType;
        List collect;
        DynamicObject entity = data.getDataEntity();
        DynamicObject limit = entity.getDynamicObject("limtno");
        if (!EmptyUtil.isEmpty((DynamicObject)limit) && !(collect = (limitProductType = limit.getDynamicObjectCollection("producttype")).stream().map(e -> e.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList())).contains(productType)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5355\u7684\u4ea7\u54c1\u7c7b\u578b\u4e0d\u5305\u542b\u8be5\u4ea7\u54c1\u7c7b\u578b\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7684\u989d\u5ea6\u5355\u3002", (String)"ReqNoteLimitOccValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private void validateLimitCurrencyAmt(DynamicObject limit, Map<Long, DynamicObject> limitCurrencyMap, Map<Long, BigDecimal> reqnoteCurrencyAmtMap, Map<Long, String> reqnoteCurrencyMap) {
        boolean isContainCurr = true;
        ArrayList<String> currs = new ArrayList<String>();
        for (Map.Entry<Long, BigDecimal> entry : reqnoteCurrencyAmtMap.entrySet()) {
            Long currencyId = entry.getKey();
            BigDecimal amt = entry.getValue();
            if (EmptyUtil.isEmpty((BigDecimal)amt)) continue;
            if (!limitCurrencyMap.containsKey(currencyId)) {
                isContainCurr = false;
                if (reqnoteCurrencyMap.get(currencyId) == null) continue;
                currs.add(reqnoteCurrencyMap.get(currencyId));
                continue;
            }
            DynamicObject currEntry = limitCurrencyMap.get(currencyId);
            BigDecimal remainamt = currEntry.getBigDecimal("remainamt");
            DynamicObject entryCurrency = currEntry.getDynamicObject("currency");
            if (remainamt.compareTo(amt) >= 0) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5355%1$s\u7684%2$s\u5bf9\u5e94\u7684\u5269\u4f59\u989d\u5ea6\u4e0d\u8db3\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u3002", (String)"ReqNoteLimitOccValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]), limit.getString("billno"), entryCurrency.getString("number")));
        }
        if (!isContainCurr) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7533\u8bf7\u5355\u7684%1$s\u4ea4\u6613\u5e01\u79cd\u4e0e\u9009\u5b9a\u7684\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5355%2$s\u7684\u989d\u5ea6\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u3002", (String)"ReqNoteLimitOccValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]), String.join((CharSequence)",", currs), limit.getString("billno")));
        }
    }
}

