/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.requestnote;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.ReqNoteEnum;

public class ReqNotePushTradeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("producttype");
        selector.add("spotinfo");
        selector.add("forwardinfo");
        selector.add("swapsinfo");
        selector.add("optionsinfo");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        for (ExtendedDataEntity entity : entities) {
            DynamicObjectCollection col;
            DynamicObject protectType;
            String entityName;
            Set<Object> rowIds;
            String billStatus = (String)entity.getValue("billstatus");
            if (!TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u53ea\u80fd\u4e0b\u63a8\u5df2\u5ba1\u6838\u6570\u636e\u3002", (String)"RequestNoteList_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject dataEntity = entity.getDataEntity();
            if (!"tm_reqnote".equals(entity.getDataEntity().getDataEntityType().getName()) || !EmptyUtil.isNoEmpty(rowIds = dataEntity.getDynamicObjectCollection(entityName = ReqNoteEnum.getEntryByNumber((String)(protectType = dataEntity.getDynamicObject("producttype")).getString("number"))).stream().map(e -> e.get("id")).collect(Collectors.toSet())) || !this.isSameCollection(col = QueryServiceHelper.query((String)"tm_forex", (String)"sourcebillid", (QFilter[])new QFilter("sourcebillid", "in", rowIds).toArray()), rowIds)) continue;
            String billNo = dataEntity.getString("billno");
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u4e0b\u63a8\u5e76\u4fdd\u5b58\u8fc7\u4ea4\u6613\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u4ea4\u6613\u5355\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReqNotePushTradeValidator_0", (String)"tmc-tm-business", (Object[])new Object[]{billNo}));
        }
    }

    private boolean isSameCollection(DynamicObjectCollection col, Set<Object> rowIds) {
        if (col.size() != rowIds.size()) {
            return false;
        }
        for (DynamicObject o : col) {
            if (rowIds.contains(o.get("sourcebillid"))) continue;
            return false;
        }
        return true;
    }
}

