/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.requestnote;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class ReqNoteUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("forwardinfo");
        selector.add("producttype.number");
        selector.add("forwardinfo.foisbizbill");
        selector.add("spotinfo");
        selector.add("spotinfo.spisbizbill");
        selector.add("swapsinfo");
        selector.add("swapsinfo.swisbizbill");
        selector.add("optionsinfo");
        selector.add(StringUtils.join((Object[])new String[]{"optionsinfo", ".", "opisbizbill"}));
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        for (ExtendedDataEntity data : entities) {
            List ids;
            QFilter qFilter;
            DynamicObject entity = data.getDataEntity();
            if (!"tm_reqnote".equals(entity.getDataEntityType().getName())) continue;
            String number = entity.getDynamicObject("producttype").getString("number");
            DynamicObjectCollection entryInfo = entity.getDynamicObjectCollection(this.getEntryName(number));
            ProductTypeEnum productTypeEnum = ProductTypeEnum.getEnumByValue((String)number);
            String entityName = productTypeEnum.getEntity();
            boolean exists = TmcDataServiceHelper.exists((String)entityName, (QFilter[])(qFilter = new QFilter("sourcebillid", "in", ids = entryInfo.stream().map(e -> e.getLong("id")).collect(Collectors.toList()))).toArray());
            if (!exists) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5173\u8054\u7684\u4ea4\u6613\u5355\u636e\u5df2\u505a\u540e\u7eed\u64cd\u4f5c\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ReqNoteUnAuditValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private String getEntryName(String number) {
        if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number)) {
            return "forwardinfo";
        }
        if (ProductTypeEnum.FOREXSPOT.getValue().equals(number)) {
            return "spotinfo";
        }
        if (ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
            return "swapsinfo";
        }
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
            return "optionsinfo";
        }
        return "forwardinfo";
    }
}

