/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.requestnote;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RequestNoteSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("limtno");
        selector.add("producttype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        for (ExtendedDataEntity data : entities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject limitNo = bill.getDynamicObject("limtno");
            if (EmptyUtil.isNoEmpty((DynamicObject)limitNo)) {
                String billStatus = limitNo.getString("billstatus");
                if (!TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u6240\u9009\u4ea4\u6613\u989d\u5ea6\u7533\u8bf7\u5355\u975e\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u540e\u64cd\u4f5c\u3002", (String)"RequestNoteSaveValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
            }
            if (!EmptyUtil.isEmpty((DynamicObject)bill.getDynamicObject("producttype"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RequestNoteSaveValidator_2", (String)"tmc-tm-business", (Object[])new Object[]{((IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)"producttype")).getDisplayName().getLocaleValue()}));
        }
    }
}

