/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.setting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class SettlementSettingValidator
extends AbstractTmcBizOppValidator {
    private static final int MAX_TIP_COUNT = 10;

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject dataEntity = data.getDataEntity();
            Map<String, Set<Long>> map = this.queryExistOrgIds(dataEntity);
            ArrayList<String> tipStrList = new ArrayList<String>(8);
            for (DynamicObject org : dataEntity.getDynamicObjectCollection("orgcol")) {
                if (tipStrList.size() == 10) break;
                String tipStr = this.contains(map, org);
                if (tipStr == null) continue;
                tipStrList.add(tipStr);
            }
            if (tipStrList.isEmpty()) continue;
            for (String tipStr : tipStrList) {
                this.addErrorMessage(data, tipStr);
            }
        }
    }

    private String contains(Map<String, Set<Long>> map, DynamicObject org) {
        for (Map.Entry<String, Set<Long>> entry : map.entrySet()) {
            if (!entry.getValue().contains(org.getDynamicObject("fbasedataid").getLong("id"))) continue;
            return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %1$s \u5df2\u5728\u7ed3\u7b97\u5355\u636e\u914d\u7f6e %2$s \u4e2d\u8fdb\u884c\u914d\u7f6e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SettlementSettingValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]), org.getDynamicObject("fbasedataid").getString("name"), entry.getKey());
        }
        return null;
    }

    private Map<String, Set<Long>> queryExistOrgIds(DynamicObject dataEntity) {
        DynamicObject[] existSettings = BusinessDataServiceHelper.load((String)"tm_settlement_setting", (String)"number,orgcol", (QFilter[])new QFilter("id", "!=", dataEntity.get("id")).toArray());
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        for (DynamicObject bill : existSettings) {
            Set orgIds = bill.getDynamicObjectCollection("orgcol").stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            map.put(bill.getString("number"), orgIds);
        }
        return map;
    }
}

