/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.trade;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.SwapExchangeType;
import kd.tmc.tm.common.enums.SwapTypeEnum;

public abstract class AbstractRecOrPayOpValidator
extends AbstractTmcBizOppValidator {
    protected void validateBillStatus(ExtendedDataEntity extendedDataEntity, String billStatus) {
        if (!TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u7684\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractRecOrPayOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    protected void validateRepeatedPushPayBill(ExtendedDataEntity extendedDataEntity, String entityType, Long id) {
        Object[] targetBill = TmcBotpHelper.getTargetBills((String)entityType, (Object)id, (String)"cas_paybill", null);
        if (EmptyUtil.isNoEmpty((Object[])targetBill)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"AbstractRecOrPayOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    protected void validateRepeatedPushRecBill(ExtendedDataEntity extendedDataEntity, String entityType, Long id) {
        Object[] targetBill = TmcBotpHelper.getTargetBills((String)entityType, (Object)id, (String)"cas_recbill", null);
        if (EmptyUtil.isNoEmpty((Object[])targetBill)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u6536\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"AbstractRecOrPayOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    protected void validateSwapConditionsOfSettle(ExtendedDataEntity extendedDataEntity, DynamicObject bill) {
        this.validateBillStatus(extendedDataEntity, bill.getString("billstatus"));
        String swapType = bill.getString("rateswaptype");
        String initPriExType = bill.getString("initpriextype");
        if (!SwapTypeEnum.currency.getValue().equals(swapType) || !SwapExchangeType.Actual.getValue().equals(initPriExType)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u671f\u521d\u672c\u91d1\u4ea4\u6362\u4e3a\u5b9e\u9645\u672c\u91d1\u7684\u8d27\u5e01\u4e92\u6362\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractRecOrPayOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if (bill.getBoolean("isbuysettle")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6ca1\u6709\u4e70\u5165\u7ed3\u7b97\u7684\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractRecOrPayOpValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    protected void validateStructDepositConditionsOfSettle(ExtendedDataEntity extendedDataEntity, DynamicObject bill) {
        this.validateBillStatus(extendedDataEntity, bill.getString("billstatus"));
        if (bill.getBoolean("isbuysettle")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6ca1\u6709\u4e70\u5165\u7ed3\u7b97\u7684\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractRecOrPayOpValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    protected void validateForexOptionConditionsOfSettle(ExtendedDataEntity extendedDataEntity, DynamicObject bill, boolean pay) {
        this.validateBillStatus(extendedDataEntity, bill.getString("billstatus"));
        if (EmptyUtil.isEmpty((Object)bill.get("buysettleamt"))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u5355\u636e\u671f\u6743\u8d39\u4e3a0\uff0c\u65e0\u9700\u8fdb\u884c\u7ed3\u7b97\u64cd\u4f5c\u3002", (String)"AbstractRecOrPayOpValidator_5", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        BigDecimal buySettleAmt = bill.getBigDecimal("buysettleamt");
        if (pay) {
            if (buySettleAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7ed3\u7b97\u91d1\u989d\u4e3a\u6b63\u6570\uff0c\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"AbstractRecOrPayOpValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        } else if (buySettleAmt.compareTo(BigDecimal.ZERO) < 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7ed3\u7b97\u91d1\u989d\u4e3a\u8d1f\u6570\uff0c\u4e0d\u80fd\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"AbstractRecOrPayOpValidator_7", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if (bill.getBoolean("isbuysettle")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6ca1\u6709\u4e70\u5165\u7ed3\u7b97\u7684\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractRecOrPayOpValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

