/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.trade;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.resource.TeBizResource;

public class TradeBillSaveOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("protecttype");
        sic.add("billno");
        return sic;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        String error1 = new TeBizResource().getTradeNoEmpty();
        String error2 = new TeBizResource().ProductTypeNoEmpty();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            if (EmptyUtil.isEmpty((String)bill.getString("billno"))) {
                this.addErrorMessage(data, error1);
            }
            if (EmptyUtil.isEmpty((Object)bill.get("protecttype"))) {
                this.addErrorMessage(data, error2);
            }
            this.checkAmountMaxValue(data);
        }
    }

    protected void checkAmountMaxValue(ExtendedDataEntity data) {
        DynamicObject bill = data.getDataEntity();
        TeBizResource bizResource = new TeBizResource();
        for (IDataEntityProperty prop : bill.getDataEntityType().getProperties()) {
            if (!(prop instanceof AmountProp) || bill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0 && bill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT.negate()) >= 0) continue;
            this.addErrorMessage(data, bizResource.checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
        }
    }
}

