/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.opservice.archives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.compare.concurrent.MultiThreadOperationExecutor;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.business.opservice.archives.ArchiveDataParam;
import kd.tmc.tmbrm.business.opservice.archives.IArchiveDataLoader;
import kd.tmc.tmbrm.business.opservice.archives.loader.FinOrgAccountBankLoader;
import kd.tmc.tmbrm.business.opservice.archives.loader.FinOrgBondLoader;
import kd.tmc.tmbrm.business.opservice.archives.loader.FinOrgCreditLoader;
import kd.tmc.tmbrm.business.opservice.archives.loader.FinOrgDepositLoader;
import kd.tmc.tmbrm.business.opservice.archives.loader.FinOrgLoanLoader;
import kd.tmc.tmbrm.business.opservice.archives.loader.FinOrgSettleLoader;
import kd.tmc.tmbrm.common.helper.FinOrgCoDataHelper;
import kd.tmc.tmbrm.common.model.FinOrgDataItem;
import org.apache.commons.collections4.CollectionUtils;

public class ArchiveGenerateCoDataService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ArchiveGenerateCoDataService.class);
    private static final IArchiveDataLoader[] DATA_LOADERS;
    private static final MultiThreadOperationExecutor<ArchiveDataParam, Tuple<IArchiveDataLoader, List<Object[]>>> EXECUTOR;
    private Long chinaId = FinOrgCoDataHelper.getChinaId();

    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("finorg");
        selectors.add("orgview");
        selectors.add("datacurrency");
        selectors.add("dataunit");
        return selectors;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Date dataTime = new Date();
        logger.info("ArchiveGenerateCoDataService at {}", (Object)DateUtils.formatString((Date)dataTime, (String)"yyyy-MM-dd HH:mm:ss"));
        Map<Long, List<FinOrgDataItem>> itemMap = Arrays.stream(dataEntities).filter(t -> EmptyUtil.isNoEmpty((DynamicObject)t.getDynamicObject("finorg"))).map(t -> FinOrgCoDataHelper.initFinOrgData((DynamicObject)t.getDynamicObject("finorg"), (Long)this.chinaId, (Long)t.getDynamicObject("orgview").getLong("id"))).collect(Collectors.groupingBy(FinOrgDataItem::getOrgViewId));
        if (itemMap.isEmpty()) {
            logger.info("not fund org");
            return;
        }
        for (Map.Entry<Long, List<FinOrgDataItem>> entry : itemMap.entrySet()) {
            List allOrgIds = TmcOrgDataHelper.getAllOrgIdsByViewId((Long)entry.getKey());
            if (EmptyUtil.isEmpty((Collection)allOrgIds)) continue;
            Collection allBank = FinOrgCoDataHelper.getAllBank(entry.getValue());
            List dataParams = Arrays.stream(DATA_LOADERS).map(t -> new ArchiveDataParam((IArchiveDataLoader)t, allBank, allOrgIds, dataTime, (Long)entry.getKey())).collect(Collectors.toList());
            EXECUTOR.doBatchOperation(dataParams, DATA_LOADERS.length, this::doOperation).stream().filter(t -> CollectionUtils.isNotEmpty((Collection)((Collection)t.item2))).forEach(t -> ((IArchiveDataLoader)t.item1).processByArea((List)entry.getValue(), (List)t.item2));
        }
        logger.info("load data finish");
        DynamicObject[] dataArr = (DynamicObject[])itemMap.values().stream().flatMap(Collection::stream).map(FinOrgDataItem::getCoData).toArray(DynamicObject[]::new);
        TmcDataServiceHelper.save((DynamicObject[])dataArr);
        logger.info("save all data");
    }

    private List<Tuple<IArchiveDataLoader, List<Object[]>>> doOperation(List<ArchiveDataParam> list) {
        ArrayList<Tuple<IArchiveDataLoader, List<Object[]>>> resList = new ArrayList<Tuple<IArchiveDataLoader, List<Object[]>>>(list.size() * 2);
        for (ArchiveDataParam param : list) {
            List<Object> dataList;
            try {
                dataList = param.getDataLoader().loadPlainData(param);
            }
            catch (Exception e) {
                logger.error("process loader " + param.getDataLoader().getClass().getName() + " error", (Throwable)e);
                dataList = Collections.emptyList();
            }
            resList.add((Tuple<IArchiveDataLoader, List<Object[]>>)Tuple.create((Object)param.getDataLoader(), dataList));
        }
        return resList;
    }

    static {
        EXECUTOR = new MultiThreadOperationExecutor();
        DATA_LOADERS = new IArchiveDataLoader[]{new FinOrgAccountBankLoader(), new FinOrgDepositLoader(), new FinOrgLoanLoader(), new FinOrgCreditLoader(), new FinOrgBondLoader(), new FinOrgSettleLoader()};
    }
}

