/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.opservice.archives;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.ArchivesStatusEnum;
import kd.tmc.tmbrm.common.helper.AttachmentHelper;

public class ArchivesChangeUnAuditService
extends AbstractTmcBizOppService {
    private final List<String> entryList = new ArrayList<String>(10);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("srcbillpk");
        selector.add("srcbilltype");
        selector.add("entryentity");
        selector.add("entryentity.srcentryid");
        selector.add("entryentity.fieldname");
        selector.add("entryentity.entryname");
        selector.add("entryentity.srcbillentryid");
        selector.add("entryentity.newvalue");
        selector.add("entryentity.infotype");
        selector.add("entryentity.changeattachment");
        selector.add("entryentity.srcbillid");
        selector.add("beforechginfo_tag");
        return selector;
    }

    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        super.beforeProcess(dataEntities);
        ArrayList<DynamicObject> oldBillList = new ArrayList<DynamicObject>(dataEntities.size());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            String srcBillInfo = changeBill.getString("beforechginfo_tag");
            long srcBillPk = changeBill.getLong("srcbillpk");
            String srcBillType = changeBill.getString("srcbilltype");
            this.delChangeHistory(srcBillPk, srcBillType);
            DynamicObject srcBill = TmcDataServiceHelper.loadSingle((Object)srcBillPk, (String)srcBillType);
            DynamicObjectCollection changeEntry = changeBill.getDynamicObjectCollection("entryentity");
            try {
                String uncompress = GzipUtils.uncompress((String)srcBillInfo, (String)"UTF-8");
                DynamicObject oldBill = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)uncompress);
                this.copyValue(oldBill, srcBill, changeEntry);
                srcBill.set("archivestatus", (Object)ArchivesStatusEnum.CHANGING.getValue());
                oldBillList.add(srcBill);
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
            long billId = changeBill.getLong("id");
            DynamicObjectCollection oldAttCol = AttachmentHelper.getAttachements((String)"tmbrm_finorg_archives", (long)srcBillPk, (String)"attachmentpanelap", (String)"id");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)oldAttCol)) {
                AttachmentHelper.deleteAttachements((String)"tmbrm_finorg_archives", (long)srcBillPk, (String)"attachmentpanelap");
            }
            AttachmentHelper.copyAttachment((String)"tmbrm_archives_chg", (long)billId, (String)"oldattachmentpanel", (String)"tmbrm_finorg_archives", (long)srcBillPk, (String)"attachmentpanelap");
            DynamicObjectCollection oldAttCol2 = AttachmentHelper.getAttachements((String)"tmbrm_finorg_archives", (long)srcBillPk, (String)"attachmentpanelap1", (String)"id");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)oldAttCol2)) {
                AttachmentHelper.deleteAttachements((String)"tmbrm_finorg_archives", (long)srcBillPk, (String)"attachmentpanelap1");
            }
            AttachmentHelper.copyAttachment((String)"tmbrm_archives_chg", (long)billId, (String)"oldrelattachmentpanel", (String)"tmbrm_finorg_archives", (long)srcBillPk, (String)"attachmentpanelap1");
        }
        SaveServiceHelper.save((DynamicObject[])oldBillList.toArray(new DynamicObject[0]));
    }

    private void delChangeHistory(long srcBillPk, String srcBillType) {
        BillChangeHistoryHelper.genDelChangeHistory((Long)srcBillPk, (String)srcBillType, (String)"t_tmbrm_arch_chghistory", (String)"tmbrm_archives_chghistory");
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    private void copyValue(DynamicObject fromBill, DynamicObject toBill, DynamicObjectCollection changeEntry) {
        for (DynamicObject row : changeEntry) {
            String fieldName = row.getString("fieldname");
            String entryName = row.getString("entryname").trim();
            if (EmptyUtil.isNoEmpty((String)entryName)) {
                if (this.entryList.contains(entryName)) continue;
                toBill.getDynamicObjectCollection(entryName).clear();
                DynamicObjectCollection oldEntry = fromBill.getDynamicObjectCollection(entryName);
                for (DynamicObject entry_a : oldEntry) {
                    DynamicObject entry_l = toBill.getDynamicObjectCollection(entryName).addNew();
                    for (IDataEntityProperty property : entry_a.getDataEntityType().getProperties()) {
                        if (!entry_l.getDataEntityType().getProperties().containsKey((Object)property.getName())) continue;
                        entry_l.set(property, entry_a.get(property));
                    }
                    entry_l.set("id", entry_a.get("id"));
                }
                this.entryList.add(entryName);
                continue;
            }
            toBill.set(fieldName, fromBill.get(fieldName));
        }
    }
}

