/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.opservice.archives;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.tmbrm.business.opservice.archives.ArchiveDataParam;
import kd.tmc.tmbrm.common.enums.FinOrgDataAreaEnum;
import kd.tmc.tmbrm.common.helper.FinOrgCoDataHelper;
import kd.tmc.tmbrm.common.model.FinOrgDataItem;
import org.apache.commons.collections4.CollectionUtils;

public interface IArchiveDataLoader {
    public List<Object[]> loadPlainData(ArchiveDataParam var1);

    public int getResultDataIndex();

    public void putRowData(DynamicObject var1, Map<String, Object[]> var2);

    default public void processByArea(List<FinOrgDataItem> dataItems, List<Object[]> origin) {
        Map<Long, List<Object[]>> areaMap = origin.stream().collect(Collectors.groupingBy(this::getBankId));
        for (FinOrgDataItem dataItem : dataItems) {
            List<Object[]> tuple;
            HashMap<String, Object[]> rowMap = new HashMap<String, Object[]>(16);
            for (Long bank : dataItem.getDomesticIds()) {
                tuple = areaMap.get(bank);
                if (CollectionUtils.isEmpty(tuple)) continue;
                this.itemBankMerge(FinOrgDataAreaEnum.DOMESTIC.getValue(), rowMap, tuple, this::getDataUniqKey);
            }
            for (Long bank : dataItem.getOverseaIds()) {
                tuple = areaMap.get(bank);
                if (CollectionUtils.isEmpty(tuple)) continue;
                this.itemBankMerge(FinOrgDataAreaEnum.OVERSEA.getValue(), rowMap, tuple, this::getDataUniqKey);
            }
            this.putRowData(dataItem.getCoData(), rowMap);
        }
    }

    default public void processAllArea(List<FinOrgDataItem> dataItems, List<Object[]> origin) {
        for (FinOrgDataItem dataItem : dataItems) {
            HashMap<String, Object[]> rowMap = new HashMap<String, Object[]>(16);
            this.itemBankMerge(null, rowMap, origin, this::getDataUniqKey);
            this.putRowData(dataItem.getCoData(), rowMap);
        }
    }

    default public Long getBankId(Object[] data) {
        return Long.parseLong(data[0].toString());
    }

    default public Object[] itemAreaMap(String areaValue, Object[] row) {
        Object[] data = new Object[row.length + 1];
        data[0] = areaValue;
        System.arraycopy(row, 1, data, 1, row.length - 1);
        return data;
    }

    default public String getDataUniqKey(Object[] data) {
        return IntStream.range(0, this.getResultDataIndex()).boxed().map(t -> data[t].toString()).collect(Collectors.joining(":"));
    }

    default public void itemBankMerge(String areaValue, Map<String, Object[]> rowMap, List<Object[]> dataList, Function<Object[], String> keyFun) {
        for (Object[] data : dataList) {
            String key;
            Object[] row;
            if (null != areaValue) {
                data = this.itemAreaMap(areaValue, data);
            }
            if (null != (row = rowMap.get(key = keyFun.apply(data)))) {
                data = FinOrgCoDataHelper.mergeArr((Object[])row, (Object[])data, (int)this.getResultDataIndex());
            }
            rowMap.put(key, data);
        }
    }
}

