/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.opservice.archives.loader;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.tmbrm.business.opservice.archives.ArchiveDataParam;
import kd.tmc.tmbrm.business.opservice.archives.IArchiveDataLoader;
import kd.tmc.tmbrm.business.opservice.archives.loader.FinOrgCreditLoader;
import kd.tmc.tmbrm.common.enums.FinOrgDataAreaEnum;
import kd.tmc.tmbrm.common.enums.FinOrgDateScopeEnum;
import kd.tmc.tmbrm.common.helper.FinOrgCoDataHelper;
import kd.tmc.tmbrm.common.model.FinOrgDataItem;

public class FinOrgBondLoader
implements IArchiveDataLoader {
    private static final Log logger = LogFactory.getLog(FinOrgBondLoader.class);
    private static final String[] AMOUNT_FIELD = new String[]{"amount"};
    private static final String[] UNIT_FIELD = FinOrgCoDataHelper.calcFieldExpress((String[])AMOUNT_FIELD);

    @Override
    public List<Object[]> loadPlainData(ArchiveDataParam param) {
        logger.info("start load data " + this.getClass().getName());
        ArrayList<Object[]> resList = new ArrayList<Object[]>(10);
        this.loadByYear(param, FinOrgDateScopeEnum.YEAR, resList);
        this.loadByYear(param, FinOrgDateScopeEnum.LAST_YEAR, resList);
        this.loadByYear(param, FinOrgDateScopeEnum.YEAR_BEFORE_LAST, resList);
        return resList;
    }

    @Override
    public void processByArea(List<FinOrgDataItem> dataItems, List<Object[]> origin) {
        IArchiveDataLoader.super.processAllArea(dataItems, origin);
    }

    @Override
    public int getResultDataIndex() {
        return 3;
    }

    private void loadByYear(ArchiveDataParam param, FinOrgDateScopeEnum dateScopeEnum, List<Object[]> resList) {
        BigDecimal amount;
        String domestic;
        String region;
        Throwable throwable;
        DataSet unitSet2;
        Throwable throwable2;
        DataSet tranDataSetRate2;
        Throwable throwable3;
        DataSet rows;
        QFilter dateFilter = FinOrgCoDataHelper.getDateFilter((String)"bizdate", (FinOrgDateScopeEnum)dateScopeEnum, (Date)param.getDataTime());
        QFilter[] filters = new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("investor_entry.e_investortype", "in", Arrays.asList("bank", "finorg")), new QFilter("investor_entry.e_investorid", "in", param.getAllBank()), new QFilter("org.id", "in", param.getAllOrgIds()), dateFilter};
        try (DataSet accountRows = QueryServiceHelper.queryDataSet((String)FinOrgCreditLoader.class.getName(), (String)"cfm_loanbill_bond", (String)"region,currency,investor_entry.e_investamount as amount", (QFilter[])filters, null);){
            rows = accountRows.groupBy(new String[]{"region", "currency"}).sum("amount").finish();
            throwable3 = null;
            try {
                tranDataSetRate2 = AmountTransHelper.tranDataSetRate((DataSet)rows, (Long)param.getViewId(), (Long)param.getBaseCurrency(), (String)"currency", Collections.singleton("amount"), (Date)param.getDataTime());
                throwable2 = null;
                try {
                    unitSet2 = tranDataSetRate2.updateFields(AMOUNT_FIELD, UNIT_FIELD);
                    throwable = null;
                    try {
                        for (Row next : unitSet2) {
                            region = next.getString("region");
                            domestic = "R1".equals(region) ? FinOrgDataAreaEnum.DOMESTIC.getValue() : FinOrgDataAreaEnum.OVERSEA.getValue();
                            amount = next.getBigDecimal("amount");
                            resList.add(new Object[]{domestic, dateScopeEnum.getValue(), param.getBaseCurrency(), amount, BigDecimal.ZERO});
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (unitSet2 != null) {
                            if (throwable != null) {
                                try {
                                    unitSet2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                unitSet2.close();
                            }
                        }
                    }
                }
                catch (Throwable unitSet2) {
                    throwable2 = unitSet2;
                    throw unitSet2;
                }
                finally {
                    if (tranDataSetRate2 != null) {
                        if (throwable2 != null) {
                            try {
                                tranDataSetRate2.close();
                            }
                            catch (Throwable unitSet2) {
                                throwable2.addSuppressed(unitSet2);
                            }
                        } else {
                            tranDataSetRate2.close();
                        }
                    }
                }
            }
            catch (Throwable tranDataSetRate2) {
                throwable3 = tranDataSetRate2;
                throw tranDataSetRate2;
            }
            finally {
                if (rows != null) {
                    if (throwable3 != null) {
                        try {
                            rows.close();
                        }
                        catch (Throwable tranDataSetRate2) {
                            throwable3.addSuppressed(tranDataSetRate2);
                        }
                    } else {
                        rows.close();
                    }
                }
            }
        }
        filters = new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("underwriter_entry.e_underwriter", "in", param.getAllBank()), new QFilter("org.id", "in", param.getAllOrgIds()), dateFilter};
        accountRows = QueryServiceHelper.queryDataSet((String)FinOrgCreditLoader.class.getName(), (String)"cfm_loanbill_bond", (String)"region,currency,underwriter_entry.e_underwriteamount as amount", (QFilter[])filters, null);
        var7_7 = null;
        try {
            rows = accountRows.groupBy(new String[]{"region", "currency"}).sum("amount").finish();
            throwable3 = null;
            try {
                tranDataSetRate2 = AmountTransHelper.tranDataSetRate((DataSet)rows, (Long)param.getViewId(), (Long)param.getBaseCurrency(), (String)"currency", Collections.singleton("amount"), (Date)param.getDataTime());
                throwable2 = null;
                try {
                    unitSet2 = tranDataSetRate2.updateFields(AMOUNT_FIELD, UNIT_FIELD);
                    throwable = null;
                    try {
                        for (Row next : unitSet2) {
                            region = next.getString("region");
                            domestic = "R1".equals(region) ? FinOrgDataAreaEnum.DOMESTIC.getValue() : FinOrgDataAreaEnum.OVERSEA.getValue();
                            amount = next.getBigDecimal("amount");
                            resList.add(new Object[]{domestic, dateScopeEnum.getValue(), param.getBaseCurrency(), BigDecimal.ZERO, amount});
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (unitSet2 != null) {
                            if (throwable != null) {
                                try {
                                    unitSet2.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                unitSet2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (tranDataSetRate2 != null) {
                        if (throwable2 != null) {
                            try {
                                tranDataSetRate2.close();
                            }
                            catch (Throwable throwable9) {
                                throwable2.addSuppressed(throwable9);
                            }
                        } else {
                            tranDataSetRate2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable10) {
                throwable3 = throwable10;
                throw throwable10;
            }
            finally {
                if (rows != null) {
                    if (throwable3 != null) {
                        try {
                            rows.close();
                        }
                        catch (Throwable throwable11) {
                            throwable3.addSuppressed(throwable11);
                        }
                    } else {
                        rows.close();
                    }
                }
            }
        }
        catch (Throwable throwable12) {
            var7_7 = throwable12;
            throw throwable12;
        }
        finally {
            if (accountRows != null) {
                if (var7_7 != null) {
                    try {
                        accountRows.close();
                    }
                    catch (Throwable throwable13) {
                        var7_7.addSuppressed(throwable13);
                    }
                } else {
                    accountRows.close();
                }
            }
        }
    }

    @Override
    public void putRowData(DynamicObject coData, Map<String, Object[]> dataMap) {
        DynamicObjectCollection list = coData.getDynamicObjectCollection("bondentry");
        for (Object[] row : dataMap.values()) {
            DynamicObject data = list.addNew();
            int i = 0;
            data.set("bondarea", row[i++]);
            data.set("bonddatescope", row[i++]);
            data.set("bondcurrency", row[i++]);
            data.set("bondinveamount", row[i++]);
            data.set("bondconamount", row[i]);
        }
    }
}

