/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.opservice.archives.loader;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.tmbrm.business.opservice.archives.ArchiveDataParam;
import kd.tmc.tmbrm.business.opservice.archives.IArchiveDataLoader;
import kd.tmc.tmbrm.common.enums.FinOrgDateScopeEnum;
import kd.tmc.tmbrm.common.helper.FinOrgCoDataHelper;

public class FinOrgCreditLoader
implements IArchiveDataLoader {
    private static final Log logger = LogFactory.getLog(FinOrgCreditLoader.class);
    private static final String[] AMOUNT_FIELD = new String[]{"amount"};
    private static final String[] UNIT_FIELD = FinOrgCoDataHelper.calcFieldExpress((String[])AMOUNT_FIELD);

    @Override
    public List<Object[]> loadPlainData(ArchiveDataParam param) {
        logger.info("start load data " + this.getClass().getName());
        ArrayList<Object[]> resList = new ArrayList<Object[]>(10);
        QFilter[] filters = new QFilter[]{new QFilter("banktype", "=", (Object)"bd_finorginfo"), new QFilter("bank.id", "in", param.getAllBank()), new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("org.id", "in", param.getAllOrgIds()), new QFilter("isclose", "=", (Object)"0")};
        try (DataSet accountRows = QueryServiceHelper.queryDataSet((String)FinOrgCreditLoader.class.getName(), (String)"cfm_creditlimit", (String)"bank.id as bank,currency,totalamt as amount", (QFilter[])filters, null);
             DataSet rows = accountRows.groupBy(new String[]{"bank", "currency"}).sum("amount").finish();
             DataSet tranDataSetRate = AmountTransHelper.tranDataSetRate((DataSet)rows, (Long)param.getViewId(), (Long)param.getBaseCurrency(), (String)"currency", Collections.singleton("amount"), (Date)param.getDataTime());
             DataSet unitSet = tranDataSetRate.updateFields(AMOUNT_FIELD, UNIT_FIELD);){
            for (Row next : unitSet) {
                Long bank = next.getLong("bank");
                BigDecimal amount = next.getBigDecimal("amount");
                resList.add(new Object[]{bank, param.getBaseCurrency(), amount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
            }
        }
        filters = new QFilter[]{new QFilter("banktype", "=", (Object)"bd_finorginfo"), new QFilter("bank.id", "in", param.getAllBank()), new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("org.id", "in", param.getAllOrgIds())};
        var5_5 = null;
        try (DataSet limitRows = QueryServiceHelper.queryDataSet((String)FinOrgCreditLoader.class.getName(), (String)"cfm_creditlimit", (String)"id,bank.id as bank", (QFilter[])filters, null);){
            this.loadByYear(limitRows.copy(), FinOrgDateScopeEnum.YEAR, param, resList);
            this.loadByYear(limitRows.copy(), FinOrgDateScopeEnum.LAST_YEAR, param, resList);
            this.loadByYear(limitRows, FinOrgDateScopeEnum.YEAR_BEFORE_LAST, param, resList);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        return resList;
    }

    @Override
    public int getResultDataIndex() {
        return 2;
    }

    private void loadByYear(DataSet limitRows, FinOrgDateScopeEnum dateScopeEnum, ArchiveDataParam param, List<Object[]> resList) {
        try (DataSet yearUse = QueryServiceHelper.queryDataSet((String)FinOrgCreditLoader.class.getName(), (String)"cfm_credituse", (String)"creditlimit,currency,amount", (QFilter[])FinOrgCoDataHelper.getDateFilter((String)"startdate", (FinOrgDateScopeEnum)dateScopeEnum, (Date)param.getDataTime()).toArray(), null).groupBy(new String[]{"creditlimit", "currency"}).sum("amount").finish();
             DataSet rows = limitRows.join(yearUse).on("id", "creditlimit").select(new String[]{"bank"}, new String[]{"currency", "amount"}).finish().groupBy(new String[]{"bank", "currency"}).sum("amount").finish();
             DataSet tranDataSetRate = AmountTransHelper.tranDataSetRate((DataSet)rows, (Long)param.getViewId(), (Long)param.getBaseCurrency(), (String)"currency", Collections.singleton("amount"), (Date)param.getDataTime());
             DataSet unitSet = tranDataSetRate.updateFields(AMOUNT_FIELD, UNIT_FIELD);){
            for (Row next : unitSet) {
                Object[] paramArr;
                Long bank = next.getLong("bank");
                BigDecimal amount = next.getBigDecimal("amount");
                switch (dateScopeEnum) {
                    case YEAR: {
                        paramArr = new Object[]{bank, param.getBaseCurrency(), BigDecimal.ZERO, amount, BigDecimal.ZERO, BigDecimal.ZERO};
                        break;
                    }
                    case LAST_YEAR: {
                        paramArr = new Object[]{bank, param.getBaseCurrency(), BigDecimal.ZERO, BigDecimal.ZERO, amount, BigDecimal.ZERO};
                        break;
                    }
                    default: {
                        paramArr = new Object[]{bank, param.getBaseCurrency(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, amount};
                    }
                }
                resList.add(paramArr);
            }
        }
    }

    @Override
    public void putRowData(DynamicObject coData, Map<String, Object[]> dataMap) {
        DynamicObjectCollection list = coData.getDynamicObjectCollection("creditentry");
        for (Object[] row : dataMap.values()) {
            DynamicObject data = list.addNew();
            int i = 0;
            data.set("creditarea", row[i++]);
            data.set("credcurrency", row[i++]);
            data.set("creditamount", row[i++]);
            data.set("credityear", row[i++]);
            data.set("creditlastyear", row[i++]);
            data.set("creditnextyear", row[i]);
        }
    }
}

