/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.opservice.archives.loader;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.InvestCommonHelper;
import kd.tmc.fbp.common.model.tda.invest.InvestRequest;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tmbrm.business.opservice.archives.ArchiveDataParam;
import kd.tmc.tmbrm.business.opservice.archives.IArchiveDataLoader;
import kd.tmc.tmbrm.common.enums.FinOrgDateScopeEnum;
import kd.tmc.tmbrm.common.helper.FinOrgCoDataHelper;
import org.apache.commons.lang3.StringUtils;

public class FinOrgDepositLoader
implements IArchiveDataLoader {
    private static final Log logger = LogFactory.getLog(FinOrgDepositLoader.class);
    private static final List<String> INVEST_TYPE_LIST = Arrays.asList(InvestTypeEnum.notice.getValue(), InvestTypeEnum.fixed.getValue(), InvestTypeEnum.structure.getValue(), InvestTypeEnum.huge.getValue());
    private static final String[] AMOUNT_FIELD = new String[]{"amount"};
    private static final String[] UNIT_AMOUNT = FinOrgCoDataHelper.calcFieldExpress((String[])AMOUNT_FIELD);
    private static final String[] RATE_FIELD = new String[]{"expectprofit", "avgprinciple"};
    private static final String[] UNIT_FIELD = FinOrgCoDataHelper.calcFieldExpress((String[])RATE_FIELD);
    private static final Map<String, String> INVEST_CODE_MAP = ImmutableMap.builder().put((Object)InvestTypeEnum.notice.getValue(), (Object)"1").put((Object)InvestTypeEnum.fixed.getValue(), (Object)"2").put((Object)InvestTypeEnum.structure.getValue(), (Object)"3").put((Object)InvestTypeEnum.huge.getValue(), (Object)"4").put((Object)InvestTypeEnum.finance.getValue(), (Object)"5").put((Object)"balance", (Object)"0").build();

    @Override
    public List<Object[]> loadPlainData(ArchiveDataParam param) {
        logger.info("start load data " + this.getClass().getName());
        ArrayList<Object[]> resList = new ArrayList<Object[]>(10);
        this.loadAmount(param, resList);
        this.loadRate(param, resList);
        return resList;
    }

    @Override
    public int getResultDataIndex() {
        return 3;
    }

    @Override
    public void putRowData(DynamicObject coData, Map<String, Object[]> dataMap) {
        DynamicObjectCollection list = coData.getDynamicObjectCollection("depositentry");
        list.clear();
        for (Object[] row : dataMap.values()) {
            DynamicObject data = list.addNew();
            int i = 0;
            data.set("depositarea", row[i++]);
            data.set("deposittype", row[i++]);
            data.set("depocurrency", row[i++]);
            data.set("depositamount", row[i++]);
            data.set("depositincome", row[i++]);
            data.set("depositavgamount", row[i]);
        }
    }

    /*
     * Exception decompiling
     */
    private void loadAmount(ArchiveDataParam param, List<Object[]> resList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadRate(ArchiveDataParam param, List<Object[]> resList) {
        InvestRequest request = new InvestRequest(FinOrgDepositLoader.class.getName(), param.getDataTime(), param.getBaseCurrency(), param.getViewId(), FinOrgCoDataHelper.getTdaDateListParam((Date)param.getDataTime(), (FinOrgDateScopeEnum[])new FinOrgDateScopeEnum[]{FinOrgDateScopeEnum.CURRENT}), this.getFinSubscribeFilter(param), this.getDepositFilter(param));
        try (DataSet investDataSet = InvestCommonHelper.getAllViewData((InvestRequest)request).updateFields(new String[]{"expectprofit"}, new String[]{"expectrate * avgprinciple / 100"}).groupBy(new String[]{"bank", "investtype"}).sum("expectprofit").sum("avgprinciple").finish();
             DataSet unitSet = investDataSet.updateFields(RATE_FIELD, UNIT_FIELD);){
            for (Row row : unitSet) {
                String investtype = INVEST_CODE_MAP.get(row.get("investtype"));
                if (StringUtils.isBlank((CharSequence)investtype)) continue;
                resList.add(new Object[]{row.get("bank"), investtype, param.getBaseCurrency(), BigDecimal.ZERO, row.getBigDecimal("expectprofit"), row.getBigDecimal("avgprinciple")});
            }
        }
    }

    private QFilter getDepositFilter(ArchiveDataParam param) {
        int year = DateUtils.getYear((Date)param.getDataTime());
        int beginYear = year - 10;
        Date queryStartDate = DateUtils.getYearFirst((int)beginYear);
        Date queryEndDate = param.getDataTime();
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("investvarieties.investtype", "in", INVEST_TYPE_LIST);
        filter.and("bizstatus", "!=", (Object)"subscribe_ing");
        FinOrgDepositLoader.appendTradeChannelFilter(filter);
        filter.and(FinOrgDepositLoader.getDateFilter(queryStartDate, queryEndDate, "intdate"));
        filter.and("org", "in", param.getAllOrgIds());
        filter.and("finorginfo.id", "in", param.getAllBank());
        return filter;
    }

    private QFilter getFinSubscribeFilter(ArchiveDataParam param) {
        int year = DateUtils.getYear((Date)param.getDataTime());
        int beginYear = year - 10;
        Date queryStartDate = DateUtils.getYearFirst((int)beginYear);
        Date queryEndDate = param.getDataTime();
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("finservicestatus", "!=", (Object)"subscribe_ing");
        FinOrgDepositLoader.appendTradeChannelFilter(filter);
        filter.and(FinOrgDepositLoader.getDateFilter(queryStartDate, queryEndDate, "valuedate"));
        filter.and("org.id", "in", param.getAllOrgIds());
        filter.and("finorginfo.id", "in", param.getAllBank());
        return filter;
    }

    private static QFilter getDateFilter(Date queryStartDate, Date queryEndDate, String intdateName) {
        String cleardateName = "cleardate";
        QFilter dateFilter = new QFilter(intdateName, "<=", (Object)queryEndDate);
        QFilter clearDateFilter = QFilter.isNull((String)cleardateName).or(new QFilter(cleardateName, ">", (Object)queryStartDate));
        return dateFilter.and(clearDateFilter);
    }

    private static void appendTradeChannelFilter(QFilter qFilter) {
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ?)", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        qFilter.and(channelFilter);
    }
}

