/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.opservice.archives.loader;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.FinanceCostCommonHelper;
import kd.tmc.fbp.common.model.tda.finance.FinCostRequest;
import kd.tmc.tmbrm.business.opservice.archives.ArchiveDataParam;
import kd.tmc.tmbrm.business.opservice.archives.IArchiveDataLoader;
import kd.tmc.tmbrm.common.enums.FinOrgDataAreaEnum;
import kd.tmc.tmbrm.common.enums.FinOrgDateScopeEnum;
import kd.tmc.tmbrm.common.helper.FinOrgCoDataHelper;
import kd.tmc.tmbrm.common.model.FinOrgDataItem;
import org.apache.commons.lang3.StringUtils;

public class FinOrgLoanLoader
implements IArchiveDataLoader {
    private static final Log logger = LogFactory.getLog(FinOrgLoanLoader.class);
    private static final String[] AMOUNT_FIELD = new String[]{"amount"};
    private static final String[] UNIT_FIELD = FinOrgCoDataHelper.calcFieldExpress((String[])AMOUNT_FIELD);
    private static final String[] RATE_FIELD = new String[]{"avgbalance", "interest"};
    private static final String[] UNIT_RATE = FinOrgCoDataHelper.calcFieldExpress((String[])RATE_FIELD);

    @Override
    public List<Object[]> loadPlainData(ArchiveDataParam param) {
        logger.info("start load data " + this.getClass().getName());
        List<Object[]> list = this.loadAmount(param, FinOrgDateScopeEnum.YEAR);
        list.addAll(this.loadAmount(param, FinOrgDateScopeEnum.LAST_YEAR));
        list.addAll(this.loadAmount(param, FinOrgDateScopeEnum.YEAR_BEFORE_LAST));
        list.addAll(this.loadAmount(param, FinOrgDateScopeEnum.CURRENT));
        list.addAll(this.loadLoanCost(param));
        return list;
    }

    @Override
    public void processByArea(List<FinOrgDataItem> dataItems, List<Object[]> origin) {
        IArchiveDataLoader.super.processAllArea(dataItems, origin);
    }

    @Override
    public int getResultDataIndex() {
        return 3;
    }

    @Override
    public String getDataUniqKey(Object[] data) {
        return StringUtils.joinWith((String)":", (Object[])new Object[]{data[0].toString(), data[1].toString(), data[2].toString()});
    }

    @Override
    public void putRowData(DynamicObject coData, Map<String, Object[]> dataMap) {
        DynamicObjectCollection list = coData.getDynamicObjectCollection("loanentry");
        for (Object[] row : dataMap.values()) {
            DynamicObject data = list.addNew();
            int i = 0;
            data.set("loanarea", row[i++]);
            data.set("loandatescope", row[i++]);
            data.set("loancurrency", row[i++]);
            data.set("loanamount", row[i++]);
            data.set("loancost", row[i++]);
            data.set("loanavgbalance", row[i++]);
            data.set("loancurbalance", row[i]);
        }
    }

    private List<Object[]> loadAmount(ArchiveDataParam param, FinOrgDateScopeEnum dateScopeEnum) {
        ArrayList<Object[]> resList = new ArrayList<Object[]>(10);
        boolean isCurrentAmount = FinOrgDateScopeEnum.CURRENT == dateScopeEnum;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filters.add(new QFilter("loantype", "=", (Object)"loan"));
        filters.add(new QFilter("org.id", "in", param.getAllOrgIds()));
        filters.add(new QFilter("creditor", "in", param.getAllBank()));
        if (isCurrentAmount) {
            filters.add(new QFilter("cleardate", ">", (Object)param.getDataTime()).or(QFilter.isNull((String)"cleardate")));
        } else {
            filters.add(FinOrgCoDataHelper.getDateFilter((String)"startintdate", (FinOrgDateScopeEnum)dateScopeEnum, (Date)param.getDataTime()));
        }
        String amountField = isCurrentAmount ? "notrepayamount" : "drawamount";
        try (DataSet accountRows = QueryServiceHelper.queryDataSet((String)FinOrgLoanLoader.class.getName(), (String)"cfm_loanbill", (String)("region,currency," + amountField + " as amount"), (QFilter[])filters.toArray(new QFilter[0]), null);
             DataSet rows = accountRows.groupBy(new String[]{"region", "currency"}).sum("amount").finish();
             DataSet tranDataSetRate = AmountTransHelper.tranDataSetRate((DataSet)rows, (Long)param.getViewId(), (Long)param.getBaseCurrency(), (String)"currency", Collections.singleton("amount"), (Date)param.getDataTime());
             DataSet unitSet = tranDataSetRate.updateFields(AMOUNT_FIELD, UNIT_FIELD);){
            for (Row next : unitSet) {
                String region = next.getString("region");
                String domestic = "R1".equals(region) ? FinOrgDataAreaEnum.DOMESTIC.getValue() : FinOrgDataAreaEnum.OVERSEA.getValue();
                BigDecimal amount = next.getBigDecimal("amount");
                if (isCurrentAmount) {
                    resList.add(new Object[]{domestic, dateScopeEnum.getValue(), param.getBaseCurrency(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, amount});
                    continue;
                }
                resList.add(new Object[]{domestic, dateScopeEnum.getValue(), param.getBaseCurrency(), amount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
            }
        }
        filters.clear();
        filters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filters.add(new QFilter("loantype", "=", (Object)"sl"));
        filters.add(new QFilter("org.id", "in", param.getAllOrgIds()));
        filters.add(new QFilter("banksyndicate_entry.e_bank.id", "in", param.getAllBank()));
        if (isCurrentAmount) {
            filters.add(new QFilter("drawtype", "!=", (Object)"closeout"));
        } else {
            filters.add(FinOrgCoDataHelper.getDateFilter((String)"startintdate", (FinOrgDateScopeEnum)dateScopeEnum, (Date)param.getDataTime()));
        }
        String amountSelect = isCurrentAmount ? "notrepayamount * banksyndicate_entry.e_shareamount / drawamount as amount" : "banksyndicate_entry.e_shareamount as amount";
        try (DataSet accountRows = QueryServiceHelper.queryDataSet((String)FinOrgLoanLoader.class.getName(), (String)"cfm_loanbill", (String)("region,currency," + amountSelect), (QFilter[])filters.toArray(new QFilter[0]), null);
             DataSet rows = accountRows.groupBy(new String[]{"region", "currency"}).sum("amount").finish();
             DataSet tranDataSetRate = AmountTransHelper.tranDataSetRate((DataSet)rows, (Long)param.getViewId(), (Long)param.getBaseCurrency(), (String)"currency", Collections.singleton("amount"), (Date)param.getDataTime());){
            DataSet unitSet = tranDataSetRate.updateFields(AMOUNT_FIELD, UNIT_FIELD);
            Object object = null;
            try {
                for (Row next : unitSet) {
                    String region = next.getString("region");
                    String domestic = "R1".equals(region) ? FinOrgDataAreaEnum.DOMESTIC.getValue() : FinOrgDataAreaEnum.OVERSEA.getValue();
                    BigDecimal amount = next.getBigDecimal("amount");
                    if (isCurrentAmount) {
                        resList.add(new Object[]{domestic, dateScopeEnum.getValue(), param.getBaseCurrency(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, amount});
                        continue;
                    }
                    resList.add(new Object[]{domestic, dateScopeEnum.getValue(), param.getBaseCurrency(), amount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (unitSet != null) {
                    if (object != null) {
                        try {
                            unitSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        unitSet.close();
                    }
                }
            }
        }
        return resList;
    }

    private List<Object[]> loadLoanCost(ArchiveDataParam param) {
        ArrayList<Object[]> resList = new ArrayList<Object[]>(16);
        List yearDateList = FinOrgCoDataHelper.getTdaDateListParam((Date)param.getDataTime(), (FinOrgDateScopeEnum[])new FinOrgDateScopeEnum[]{FinOrgDateScopeEnum.YEAR, FinOrgDateScopeEnum.LAST_YEAR, FinOrgDateScopeEnum.YEAR_BEFORE_LAST});
        List curDateList = FinOrgCoDataHelper.getTdaDateListParam((Date)param.getDataTime(), (FinOrgDateScopeEnum[])new FinOrgDateScopeEnum[]{FinOrgDateScopeEnum.CURRENT});
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("org", "in", param.getAllOrgIds())).and(new QFilter("loantype", "=", (Object)"loan")).and(new QFilter("creditor", "in", param.getAllBank()));
        this.loadOrdinary(param, filter, yearDateList, resList);
        filter.and(new QFilter("cleardate", ">", (Object)param.getDataTime()).or(QFilter.isNull((String)"cleardate")));
        this.loadOrdinary(param, filter, curDateList, resList);
        filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("org", "in", param.getAllOrgIds())).and(new QFilter("loantype", "=", (Object)"sl"));
        this.loadSlLoad(param, filter, yearDateList, resList);
        filter = filter.and(new QFilter("cleardate", ">", (Object)param.getDataTime()).or(QFilter.isNull((String)"cleardate")));
        this.loadSlLoad(param, filter, curDateList, resList);
        return resList;
    }

    private void loadOrdinary(ArchiveDataParam param, QFilter filter, List<Object[]> dateList, List<Object[]> resList) {
        FinCostRequest request = new FinCostRequest(FinOrgLoanLoader.class.getName(), param.getDataTime(), param.getBaseCurrency(), param.getViewId(), dateList, filter);
        try (DataSet ordinaryRows = FinanceCostCommonHelper.getAllViewData((FinCostRequest)request).groupBy(new String[]{"region", "customtype"}).sum("avgbalance").sum("interest").finish();
             DataSet unitSet = ordinaryRows.updateFields(RATE_FIELD, UNIT_RATE);){
            this.addToList(resList, unitSet, param);
        }
    }

    private void loadSlLoad(ArchiveDataParam param, QFilter filter, List<Object[]> dateList, List<Object[]> resList) {
        FinCostRequest request = new FinCostRequest(FinOrgLoanLoader.class.getName(), param.getDataTime(), param.getBaseCurrency(), param.getViewId(), dateList, filter);
        QFilter slFilter = new QFilter("banksyndicate_entry.e_bank.id", "in", param.getAllBank()).and(filter);
        try (DataSet slRows = FinanceCostCommonHelper.getAllViewData((FinCostRequest)request);
             DataSet slFilterRows = FinOrgLoanLoader.splitBankcateData(slFilter, slRows).groupBy(new String[]{"region", "customtype"}).sum("avgbalance").sum("interest").finish();
             DataSet unitSet = slFilterRows.updateFields(RATE_FIELD, UNIT_RATE);){
            this.addToList(resList, unitSet, param);
        }
    }

    private void addToList(List<Object[]> resList, DataSet ordinaryRows, ArchiveDataParam param) {
        for (Row row : ordinaryRows) {
            String region = row.getString("region");
            String domestic = "R1".equals(region) ? FinOrgDataAreaEnum.DOMESTIC.getValue() : FinOrgDataAreaEnum.OVERSEA.getValue();
            resList.add(new Object[]{domestic, row.get("customtype"), param.getBaseCurrency(), BigDecimal.ZERO, row.get("interest"), row.get("avgbalance"), BigDecimal.ZERO});
        }
    }

    public static DataSet splitBankcateData(QFilter filter, DataSet result) {
        result = result.filter("financetype = 0");
        DataSet slLoanDataSet = FinanceCostCommonHelper.getFinanceCostDataSet((String)"FinanceCostDataHelper.querySlDataSet", (QFilter)filter, (String)"id,banksyndicate_entry.e_bank.id as ebank,banksyndicate_entry.e_shareamount as edrawamount");
        String[] fieldNames = result.getRowMeta().getFieldNames();
        result = result.join(slLoanDataSet).on("id", "id").select(fieldNames, new String[]{"ebank", "edrawamount"}).finish();
        result = result.updateFields(new String[]{"creditor", "avgbalance", "interest", "drawamount"}, new String[]{"case when edrawamount is null then creditor else ebank end", "case when edrawamount is null then avgbalance else avgbalance * (edrawamount / drawamount) end", "case when edrawamount is null then interest else interest * (edrawamount / drawamount) end", "case when edrawamount is null then drawamount else edrawamount end"});
        return result;
    }
}

