/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.opservice.evaluation;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.tmbrm.common.enums.EvalReportStatusEnum;
import kd.tmc.tmbrm.common.enums.EvaluationTaskStatusEnum;
import kd.tmc.tmbrm.common.enums.ScheduleStatusEnum;
import kd.tmc.tmbrm.common.helper.MessageSendHelper;

public class EvalReportCheckService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("ispass");
        selector.add("reportid");
        selector.add("checkopinion");
        selector.add("entryentity");
        selector.add("entryentity.eval_task");
        selector.add("entryentity.evalorg");
        selector.add("entryentity.taskid");
        selector.add("entryentity.orgid");
        selector.add("entryentity.rejectopinion");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject check : dataEntities) {
            boolean isPass = check.getBoolean("ispass");
            Long reportId = check.getLong("reportid");
            DynamicObject report = TmcDataServiceHelper.loadSingle((Object)reportId, (String)"tmbrm_eval_report", (String)"evalschedule,reportstatus,checker,checkopinion,checktime");
            if (isPass) {
                this.doPassExecute(check, report);
                continue;
            }
            this.doNotPassExecute(check, report);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject check : dataEntities) {
            boolean isPass = check.getBoolean("ispass");
            if (isPass) {
                return;
            }
            this.sendMessage(check);
        }
    }

    private void doPassExecute(DynamicObject check, DynamicObject report) {
        this.updateReport(report, check, true);
        Long scheduleId = report.getDynamicObject("evalschedule").getLong("id");
        this.updateSchedule(scheduleId, true);
        DynamicObject[] tasks = this.getTasks(scheduleId, check, true);
        this.updateTask(tasks, check, true);
    }

    private void doNotPassExecute(DynamicObject check, DynamicObject report) {
        this.updateReport(report, check, false);
        Long scheduleId = report.getDynamicObject("evalschedule").getLong("id");
        this.updateSchedule(scheduleId, false);
        DynamicObject[] tasks = this.getTasks(scheduleId, check, false);
        this.updateTask(tasks, check, false);
    }

    private void sendMessage(DynamicObject check) {
        DynamicObjectCollection entrys = check.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            MessageSendHelper.sendMessage((Long)entry.getLong("taskid"));
        }
    }

    private void updateReport(DynamicObject report, DynamicObject check, boolean pass) {
        report.set("reportstatus", (Object)(pass ? EvalReportStatusEnum.CHECKED.getValue() : EvalReportStatusEnum.REJECT.getValue()));
        report.set("checker", (Object)RequestContext.get().getCurrUserId());
        if (pass) {
            report.set("checkopinion", (Object)check.getString("checkopinion"));
        } else {
            DynamicObjectCollection checkEntrys = check.getDynamicObjectCollection("entryentity");
            StringBuilder opinions = new StringBuilder();
            for (DynamicObject entry : checkEntrys) {
                opinions.append(entry.getString("rejectopinion")).append(";");
            }
            report.set("checkopinion", (Object)opinions.toString());
        }
        report.set("checktime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
    }

    private void updateSchedule(Long scheduleId, boolean pass) {
        DynamicObject schedule = TmcDataServiceHelper.loadSingle((Object)scheduleId, (String)"tmbrm_eval_schedule", (String)"schstatus");
        schedule.set("schstatus", (Object)(pass ? ScheduleStatusEnum.CHECKED.getValue() : ScheduleStatusEnum.TOEVALUATED.getValue()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schedule});
    }

    private DynamicObject[] getTasks(Long scheduleId, DynamicObject check, boolean pass) {
        DynamicObject[] tasks = TmcDataServiceHelper.load((String)"tmbrm_evalute_task", (String)"evaluator,billstatus,evaluatestatus,ratifyuser,ratifytext,", (QFilter[])new QFilter[]{new QFilter("schedule", "=", (Object)scheduleId)});
        DynamicObjectCollection checkEntrys = check.getDynamicObjectCollection("entryentity");
        if (!pass) {
            Set noPassTaskIds = checkEntrys.stream().map(o -> o.getLong("taskid")).collect(Collectors.toSet());
            tasks = (DynamicObject[])Arrays.stream(tasks).filter(o -> noPassTaskIds.contains(o.getLong("id"))).toArray(DynamicObject[]::new);
        }
        return tasks;
    }

    private void updateTask(DynamicObject[] tasks, DynamicObject check, boolean pass) {
        for (DynamicObject task : tasks) {
            if (!pass) {
                DynamicObjectCollection checkEntrys = check.getDynamicObjectCollection("entryentity");
                DynamicObject currEntry = checkEntrys.stream().filter(o -> task.getLong("id") == o.getLong("taskid")).findFirst().get();
                task.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                task.set("ratifytext", (Object)currEntry.getString("rejectopinion"));
            } else {
                task.set("ratifytext", (Object)check.getString("checkopinion"));
            }
            task.set("evaluatestatus", (Object)(pass ? EvaluationTaskStatusEnum.RATIFY.getValue() : EvaluationTaskStatusEnum.UNSETTLE.getValue()));
            task.set("ratifyuser", (Object)RequestContext.get().getCurrUserId());
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
    }
}

