/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.opservice.evaluation;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.EvalReportStatusEnum;
import kd.tmc.tmbrm.common.enums.EvaluationTaskStatusEnum;
import kd.tmc.tmbrm.common.enums.ScheduleStatusEnum;

public class EvalTerminateService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("endopinion");
        selector.add("billtype");
        selector.add("billid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject terminate : dataEntities) {
            DynamicObject schedule;
            DynamicObject report;
            String billType = terminate.getString("billtype");
            Long billId = terminate.getLong("billid");
            String terminateText = terminate.getString("endopinion");
            if ("report".equals(billType)) {
                report = TmcDataServiceHelper.loadSingle((Object)billId, (String)"tmbrm_eval_report", (String)"terminator,endtime,endopinion,evalschedule,reportstatus");
                schedule = TmcDataServiceHelper.loadSingle((Object)report.getDynamicObject("evalschedule").getPkValue(), (String)"tmbrm_eval_schedule", (String)"terminator,endtime,endopinion,schstatus");
            } else {
                schedule = TmcDataServiceHelper.loadSingle((Object)billId, (String)"tmbrm_eval_schedule", (String)"terminator,endtime,endopinion,schstatus");
                report = TmcDataServiceHelper.loadSingle((String)"tmbrm_eval_report", (String)"terminator,endtime,endopinion,evalschedule,reportstatus", (QFilter[])new QFilter[]{new QFilter("evalschedule.id", "=", schedule.getPkValue())});
            }
            DynamicObject[] tasks = TmcDataServiceHelper.load((String)"tmbrm_evalute_task", (String)"terminator,endtime,terminatetext,evaluatestatus", (QFilter[])new QFilter[]{new QFilter("schedule.id", "=", schedule.getPkValue())});
            this.updateSchedule(schedule, terminateText);
            this.updateTasks(tasks, terminateText);
            this.updateReport(report, terminateText);
        }
    }

    private void updateReport(DynamicObject report, String terminateText) {
        if (EmptyUtil.isNoEmpty((DynamicObject)report)) {
            report.set("terminator", (Object)RequestContext.get().getCurrUserId());
            report.set("endtime", (Object)new Date());
            report.set("endopinion", (Object)terminateText);
            report.set("reportstatus", (Object)EvalReportStatusEnum.TERMINATED.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
        }
    }

    private void updateTasks(DynamicObject[] tasks, String terminateText) {
        if (EmptyUtil.isNoEmpty((Object[])tasks)) {
            for (DynamicObject task : tasks) {
                task.set("terminator", (Object)RequestContext.get().getCurrUserId());
                task.set("endtime", (Object)new Date());
                task.set("terminatetext", (Object)terminateText);
                task.set("evaluatestatus", (Object)EvaluationTaskStatusEnum.TERMINATED.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])tasks);
        }
    }

    private void updateSchedule(DynamicObject schedule, String terminateText) {
        schedule.set("terminator", (Object)RequestContext.get().getCurrUserId());
        schedule.set("endtime", (Object)new Date());
        schedule.set("endopinion", (Object)terminateText);
        schedule.set("schstatus", (Object)ScheduleStatusEnum.TERMINATED.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schedule});
    }
}

