/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ArchiveGenerateCoDataTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ArchiveGenerateCoDataTask.class);
    private static final int PROCESS_BATCH = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] data;
        String entityNumber = "tmbrm_finorg_archives";
        QFilter[] filters = new QFilter[]{QFilter.exists((String)"finorg"), QFilter.exists((String)"orgview")};
        if (map.containsKey("ids")) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(filters));
            List idList = Arrays.stream(StringUtils.split((String)map.get("ids").toString(), (String)",")).map(Long::parseLong).collect(Collectors.toList());
            filterList.add(new QFilter("id", "in", idList));
            filters = filterList.toArray(new QFilter[0]);
        }
        if ((data = (DynamicObject[])QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])filters).toArray((Object[])new DynamicObject[0])).length == 0) {
            return;
        }
        logger.info("\u540c\u6b65\u72b6\u6001\u53c2\u65701" + data.length);
        ArrayList errors = new ArrayList();
        List dataList = Arrays.stream(data).collect(Collectors.toList());
        List dataParts = Lists.partition(dataList, (int)10);
        for (List dataPartList : dataParts) {
            DynamicObject[] dataPart = dataPartList.toArray(new DynamicObject[0]);
            List idList = Arrays.stream(dataPart).map(t -> t.get("id")).map(String::valueOf).collect(Collectors.toList());
            Map request = MutexServiceHelper.batchRequest(idList, (String)entityNumber, (String)"gencodata");
            List requestIds = MutexServiceHelper.getRequestResultList((DynamicObject[])dataPart, errors, (Map)request);
            try {
                OperationResult result;
                if (requestIds.size() > 0) {
                    Object[] longIds = requestIds.stream().map(Long::valueOf).toArray();
                    result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"gencodata", (String)entityNumber, (Object[])longIds, (OperateOption)OperateOption.create());
                } else {
                    result = new OperationResult();
                }
                for (OperateErrorInfo error : errors) {
                    result.addErrorInfo(error);
                }
            }
            finally {
                if (requestIds.size() <= 0) continue;
                MutexServiceHelper.batchRelease((List)requestIds, (String)entityNumber, (String)"gencodata");
            }
        }
    }
}

