/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.validate.access;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.business.validate.access.AccessInfoSaveValidator;
import kd.tmc.tmbrm.business.validate.access.ServeyInfoSaveValidator;

public class AccessApplySubmitValidator
extends AbstractTmcBizOppValidator {
    private ServeyInfoSaveValidator surveyValidator = new ServeyInfoSaveValidator();
    private AccessInfoSaveValidator evaluateValidator = new AccessInfoSaveValidator();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("accesstype");
        selector.add("finorgtype");
        selector.add("banksetting");
        selector.add("entersurvey");
        selector.add("enteraccesseval");
        selector.addAll(this.surveyValidator.getSelector());
        selector.addAll(this.evaluateValidator.getSelector());
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedData : dataEntity) {
            DynamicObject entity = extendedData.getDataEntity();
            DynamicObject finOrgType = entity.getDynamicObject("finorgtype");
            String number = EmptyUtil.isNoEmpty((DynamicObject)finOrgType) ? finOrgType.getString("number") : "";
            boolean isBank = FinOrgTypeEnum.BANK.getNumber().equals(number);
            if (!isBank || !EmptyUtil.isEmpty((DynamicObject)entity.getDynamicObject("banksetting"))) continue;
            this.addMessage(extendedData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u7c7b\u522b\u3002", (String)"AccessApplySubmitValidator_0", (String)"tmc-tmbrm-business", (Object[])new Object[0]));
        }
        this.surveyValidator.getErrorMessage((ExtendedDataEntity[])Arrays.stream(dataEntity).filter(t -> t.getDataEntity().getBoolean("entersurvey")).toArray(ExtendedDataEntity[]::new)).forEach(t -> this.addMessage((ExtendedDataEntity)t.item1, (String)t.item2));
        this.evaluateValidator.getErrorMessage((ExtendedDataEntity[])Arrays.stream(dataEntity).filter(t -> t.getDataEntity().getBoolean("enteraccesseval")).toArray(ExtendedDataEntity[]::new)).forEach(t -> this.addMessage((ExtendedDataEntity)t.item1, (String)t.item2));
    }
}

