/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.validate.archives;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinOrgArchivesSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("fintype");
        selector.add("finorg");
        selector.add("shareentry");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            BigDecimal sum;
            DynamicObject finOrgArchive = dataEntity.getDataEntity();
            DynamicObjectCollection shareEntry = finOrgArchive.getDynamicObjectCollection("shareentry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)shareEntry) && (sum = shareEntry.stream().map(e -> e.getBigDecimal("spercent")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.valueOf(100.0)) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6301\u80a1\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u80fd\u8d85\u8fc7100%\u3002", (String)"FinOrgArchivesSaveValidator_0", (String)"tmc-tmbrm-business", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("fintype", "=", finOrgArchive.getDynamicObject("fintype").getPkValue());
            DynamicObject finOrg = finOrgArchive.getDynamicObject("finorg");
            qFilter.and("finorg", "=", finOrg.getPkValue());
            DynamicObjectCollection existArchives = QueryServiceHelper.query((String)"tmbrm_finorg_archives", (String)"billno", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)1);
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)existArchives)) continue;
            DynamicObject existArchive = (DynamicObject)existArchives.get(0);
            if (finOrgArchive.getString("billno").equals(existArchive.getString("billno"))) continue;
            String finOrgName = finOrg.getString("name");
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784\u201c%1$s\u201d\u5df2\u5b58\u5728\u6863\u6848\uff08\u6863\u6848\u7f16\u53f7\uff1a%2$s\uff09\u3002\u53ea\u80fd\u5bf9\u8fd8\u6ca1\u6709\u521b\u5efa\u6863\u6848\u7684\u91d1\u878d\u673a\u6784\u521b\u5efa\u6863\u6848\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinOrgArchivesSaveValidator_1", (String)"tmc-tmbrm-business", (Object[])new Object[0]), finOrgName, existArchive.getString("billno")));
        }
    }
}

