/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.validate.archives;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinOrgArchivesUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("billstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Set archiveNumbers = Arrays.stream(dataEntities).map(v -> v.getDataEntity().getString("billno")).collect(Collectors.toSet());
        DynamicObjectCollection changeRecords = QueryServiceHelper.query((String)"tmbrm_archives_chg", (String)"srcbillno", (QFilter[])new QFilter[]{new QFilter("srcbillno", "in", archiveNumbers)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)changeRecords)) {
            return;
        }
        Map<String, DynamicObject> changeRecordsMap = changeRecords.stream().collect(Collectors.toMap(v -> v.getString("srcbillno"), v -> v));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finOrgArchive = dataEntity.getDataEntity();
            DynamicObject changeRecord = changeRecordsMap.get(finOrgArchive.getString("billno"));
            String billStatus = finOrgArchive.getString("billstatus");
            if (BillStatusEnum.AUDIT.getValue().equals(billStatus) && EmptyUtil.isEmpty((DynamicObject)changeRecord)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u4e14\u6ca1\u6709\u53d8\u66f4\u8bb0\u5f55\u7684\u6863\u6848\u624d\u80fd\u64cd\u4f5c\u53cd\u5ba1\u6838\u3002", (String)"FinOrgArchivesUnAuditValidator_0", (String)"tmc-tmbrm-business", (Object[])new Object[0]));
        }
    }
}

