/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.validate.evaluation;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.tmbrm.common.enums.EvalOrgWeightEnum;

public class EvalScheduleSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("fromdate");
        selector.add("todate");
        selector.add("evaldate");
        selector.add("finishdate");
        selector.add("entryentity");
        selector.add("evalorgwgt");
        selector.add("entryentity.evaluateorgwgt");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            BigDecimal sum;
            DynamicObject evalSchedule = dataEntity.getDataEntity();
            Date evalDate = evalSchedule.getDate("evaldate");
            Date finishDate = evalSchedule.getDate("finishdate");
            if (finishDate.before(evalDate)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u9884\u8ba1\u5b8c\u6210\u65e5\u671f\u201d\u5e94\u5927\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4ef7\u65e5\u671f\u201d\u3002", (String)"EvalScheduleSaveValidator_0", (String)"tmc-tmbrm-business", (Object[])new Object[0]));
            }
            Date evalFromDate = evalSchedule.getDate("fromdate");
            Date evalToDate = evalSchedule.getDate("todate");
            if (evalToDate.compareTo(evalFromDate) <= 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8bc4\u4ef7\u671f\u95f4\u81f3\u201d\u5e94\u5927\u4e8e\u201c\u8bc4\u4ef7\u671f\u95f4\u4ece\u201d\u3002", (String)"EvalScheduleSaveValidator_1", (String)"tmc-tmbrm-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection entries = evalSchedule.getDynamicObjectCollection("entryentity");
            String evalOrgWeight = evalSchedule.getString("evalorgwgt");
            if (!EvalOrgWeightEnum.ORG.getValue().equals(evalOrgWeight) || (sum = entries.stream().map(e -> e.getBigDecimal("evaluateorgwgt")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.valueOf(100.0)) == 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ec4\u7ec7\u6743\u91cd\u4e4b\u548c\u5e94\u4e3a100%\u3002", (String)"EvalScheduleSaveValidator_2", (String)"tmc-tmbrm-business", (Object[])new Object[0]));
        }
    }
}

