/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.validate.evaluation;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.EvalMethodEnum;
import kd.tmc.tmbrm.common.helper.EvalTaskHelper;

public class EvalTaskAutoScoreValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedule");
        selector.add("entryentity.finorg");
        selector.addAll(IntStream.range(0, 50).boxed().map(t -> "entryentity.item" + t).collect(Collectors.toList()));
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject task = dataEntity.getDataEntity();
            DynamicObject schedule = task.getDynamicObject("schedule");
            DynamicObject proposal = schedule.getDynamicObject("evalproposal");
            DynamicObjectCollection itemList = EvalTaskHelper.getProposalItemEntry((Long)proposal.getLong("id"));
            Map itemMap = EvalTaskHelper.getEvalItemsByIds((DynamicObjectCollection)itemList);
            boolean hasAutoScoreItem = false;
            for (DynamicObject itemDO : itemList) {
                DynamicObject item = itemDO.getDynamicObject("item");
                item = (DynamicObject)itemMap.get(item.getPkValue());
                String evaMethod = item.getString("evamethod");
                if (!EvalMethodEnum.AUTO.getValue().equals(evaMethod)) continue;
                hasAutoScoreItem = true;
                break;
            }
            if (!hasAutoScoreItem) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u4ef7\u4efb\u52a1\u4e2d\u6709\u81ea\u52a8\u8bc4\u5206\u7684\u8bc4\u4ef7\u9879\u76ee\uff0c\u624d\u5141\u8bb8\u91cd\u65b0\u81ea\u52a8\u8bc4\u5206\u3002", (String)"EvalTaskAutoScoreValidator_0", (String)"tmc-tmbrm-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection entrys = task.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject finOrg = entry.getDynamicObject("finorg");
                if (!EmptyUtil.isEmpty((DynamicObject)finOrg)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u91d1\u878d\u673a\u6784\u8bc4\u4ef7\u5206\u5f55\u7b2c%s\u884c\u91d1\u878d\u673a\u6784\u3002", (String)"EvalTaskAutoScoreValidator_1", (String)"tmc-tmbrm-business", (Object[])new Object[0]), i + 1));
            }
        }
    }
}

