/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.validate.evaluation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class EvaluationTaskSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedule");
        selector.add("schedule.evalproposal");
        selector.add("entryentity");
        selector.add("entryentity.finorg");
        selector.addAll(IntStream.range(0, 50).boxed().map(t -> "entryentity.item" + t).collect(Collectors.toList()));
        selector.add("entryentity.plusinfo");
        selector.add("entryentity.minusinfo");
        selector.add("entryentity.detailscore_tag");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedData : dataEntity) {
            DynamicObject schedule;
            DynamicObject taskEntity = extendedData.getDataEntity();
            if (!taskEntity.containsProperty("schedule") || EmptyUtil.isEmpty((DynamicObject)(schedule = taskEntity.getDynamicObject("schedule"))) || !schedule.containsProperty("evalproposal")) continue;
            DynamicObject proposal = taskEntity.getDynamicObject("schedule.evalproposal");
            proposal = TmcDataServiceHelper.loadSingleFromCache((Object)proposal.getPkValue(), (String)"tmbrm_evaluateproposal");
            DynamicObjectCollection itemList = proposal.getDynamicObjectCollection("entryentity");
            Object[] itemIds = itemList.stream().map(t -> t.getDynamicObject("item").getPkValue()).toArray();
            Map itemMap = TmcDataServiceHelper.loadFromCache((Object[])itemIds, (String)"tmbrm_evaluationitem");
            List<Integer> pluginList = this.getConditionIndex(itemList, itemMap, t -> "extraadd".equals(t.getString("extraaddorsub")));
            List<Integer> minusList = this.getConditionIndex(itemList, itemMap, t -> "extrasub".equals(t.getString("extraaddorsub")));
            DynamicObjectCollection rowList = taskEntity.getDynamicObjectCollection("entryentity");
            this.checkRowTip(rowList, pluginList, "plusinfo", extendedData, ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u91d1\u878d\u673a\u6784[%2$s]\uff1a\u5c5e\u6027\u4e3a\u989d\u5916\u52a0\u5206\u9879\u76ee\u7684\u8bc4\u4ef7\u9879\u76ee\u7684\u8bc4\u5206\u5927\u4e8e0\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u989d\u5916\u52a0\u5206\u8bf4\u660e\u3002", (String)"EvaluationTaskSaveValidator_0", (String)"tmc-tmbrm-business", (Object[])new Object[0]));
            this.checkRowTip(rowList, minusList, "minusinfo", extendedData, ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u91d1\u878d\u673a\u6784[%2$s]\uff1a\u5c5e\u6027\u4e3a\u989d\u5916\u51cf\u5206\u9879\u76ee\u7684\u8bc4\u4ef7\u9879\u76ee\u7684\u8bc4\u5206\u5927\u4e8e0\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u989d\u5916\u51cf\u5206\u8bf4\u660e\u3002", (String)"EvaluationTaskSaveValidator_1", (String)"tmc-tmbrm-business", (Object[])new Object[0]));
            String defaultZero = StringUtils.join((Iterable)itemList.stream().map(t -> "0").collect(Collectors.toList()), (String)",");
            for (DynamicObject row : rowList) {
                if (!EmptyUtil.isBlank((CharSequence)row.getString("detailscore_tag"))) continue;
                row.set("detailscore_tag", (Object)defaultZero);
            }
        }
    }

    private List<Integer> getConditionIndex(DynamicObjectCollection itemList, Map<Object, DynamicObject> itemMap, Predicate<DynamicObject> preFun) {
        int len = itemList.size();
        ArrayList<Integer> resList = new ArrayList<Integer>(len);
        for (int i = 0; i < len; ++i) {
            DynamicObject object = ((DynamicObject)itemList.get(i)).getDynamicObject("item");
            if (!preFun.test(object = itemMap.get(object.getPkValue()))) continue;
            resList.add(i);
        }
        return resList;
    }

    private void checkRowTip(DynamicObjectCollection rowList, List<Integer> idxList, String infoField, ExtendedDataEntity extendedData, String tip) {
        if (EmptyUtil.isEmpty(idxList)) {
            return;
        }
        block0: for (int i = 0; i < rowList.size(); ++i) {
            DynamicObject row = (DynamicObject)rowList.get(i);
            String info = row.getString(infoField);
            if (EmptyUtil.isNotBlank((CharSequence)info)) continue;
            for (Integer idx : idxList) {
                if (row.getBigDecimal("item" + idx).compareTo(BigDecimal.ZERO) == 0) continue;
                this.addErrorMessage(extendedData, String.format(tip, i + 1, row.getLocaleString("finorg.name").getLocaleValue()));
                continue block0;
            }
        }
    }
}

