/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.business.validate.model;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.util.EmptyUtil;

public class EvaluationItemSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("maxscore");
        selector.add("ruleentry");
        selector.add("ruleentry.scorefrom");
        selector.add("ruleentry.scoreto");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendData : dataEntity) {
            DynamicObject evaluationItem = extendData.getDataEntity();
            BigDecimal maxScore = evaluationItem.getBigDecimal("maxscore");
            if (maxScore.compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u9879\u76ee\u6700\u9ad8\u5206\u503c\u5fc5\u987b\u5927\u4e8e0\u3002\u8be5\u5206\u503c\u53d6\u81ea\u8bc4\u5206\u89c4\u5219\u4e2d\u5f97\u5206\u7684\u6700\u5927\u503c\u3002\u8bf7\u68c0\u67e5\u8bc4\u5206\u89c4\u5219\u5206\u5f55\u4e2d\u7684\u201c\u5f97\u5206\u201d\u3002", (String)"EvaluationItemSaveValidator_04", (String)"tmc-tmbrm-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection ruleEntrys = evaluationItem.getDynamicObjectCollection("ruleentry");
            for (DynamicObject ruleEntry : ruleEntrys) {
                BigDecimal toScore;
                BigDecimal fromScore = ruleEntry.getBigDecimal("scorefrom");
                if (EmptyUtil.isEmpty((BigDecimal)fromScore)) {
                    fromScore = Constants.ZERO;
                }
                if (EmptyUtil.isEmpty((BigDecimal)(toScore = ruleEntry.getBigDecimal("scoreto")))) {
                    toScore = Constants.ZERO;
                }
                if (toScore.compareTo(fromScore) >= 0) continue;
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u540c\u4e00\u8bc4\u5206\u7ec6\u5219\u4e2d\uff0c\u201c\u6570\u503c\u4ece\uff08\u5927\u4e8e\u7b49\u4e8e\uff09\u201d\u5e94\u8be5 \u2264 \u201c\u6570\u503c\u81f3\uff08\u5c0f\u4e8e\uff09\u201d\u3002", (String)"EvaluationItemSaveValidator_03", (String)"tmc-tmbrm-business", (Object[])new Object[0]));
            }
        }
    }
}

