/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.mservice.eval;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.BankEvalWayEnum;
import kd.tmc.tmbrm.common.enums.EvalOrgWeightEnum;
import kd.tmc.tmbrm.common.model.EvalExtraAddOrSubModel;
import kd.tmc.tmbrm.common.model.EvalItemScoreModel;
import kd.tmc.tmbrm.common.model.EvalReportScoreModel;
import org.apache.commons.lang3.StringUtils;

public class CalculateScoreExecute {
    private static final Log logger = LogFactory.getLog(CalculateScoreExecute.class);
    private DynamicObject[] tasks;
    private DynamicObject schedule;
    private String evalOrgWgt;
    private EvalOrgWeightEnum orgWeightEnum;
    private boolean isSpecify;
    private int targetSize;
    private DynamicObject evalProposal;
    private List<DynamicObject> allEvalTargets;
    private Map<Long, BigDecimal> evalScoreCache = new HashMap<Long, BigDecimal>(16);

    public CalculateScoreExecute(DynamicObject schedule) {
        this.schedule = schedule;
        this.init();
    }

    private void init() {
        this.tasks = TmcDataServiceHelper.load((String)"tmbrm_evalute_task", (String)"org,evaluator,entryentity.finorg,entryentity.detailscore_tag,entryentity.totalscore,entryentity.plusinfo,entryentity.minusinfo", (QFilter[])new QFilter[]{new QFilter("schedule.id", "=", this.schedule.getPkValue())});
        this.evalOrgWgt = this.schedule.getString("evalorgwgt");
        this.orgWeightEnum = EvalOrgWeightEnum.getEnumByValue((String)this.evalOrgWgt);
        this.isSpecify = this.schedule.getBoolean("specify");
        this.allEvalTargets = this.getAllEvalTarget();
        Long proposalId = this.schedule.getDynamicObject("evalproposal").getLong("id");
        this.evalProposal = TmcDataServiceHelper.loadSingleFromCache((Object)proposalId, (String)"tmbrm_evaluateproposal");
        logger.info("CalculateScoreExecute.init...evalOrgWgt: " + this.evalOrgWgt + " isSpecify: " + this.isSpecify + " targetSize: " + this.targetSize);
    }

    public List<EvalReportScoreModel> calcReportResultScores() {
        ArrayList<EvalReportScoreModel> scores = new ArrayList<EvalReportScoreModel>(this.targetSize);
        for (DynamicObject target : this.allEvalTargets) {
            EvalReportScoreModel scoreResult = new EvalReportScoreModel();
            Long finOrgId = this.getFinOrgId(target);
            scoreResult.setFinOrgId(finOrgId);
            scoreResult.setEvalScore(this.calcEvalScore(finOrgId));
            scoreResult.setDetailScore(this.calcDetailScore(finOrgId));
            scores.add(scoreResult);
        }
        logger.info("\u3010\u8bc4\u4ef7\u62a5\u544a\u3011\u8ba1\u7b97\u8bc4\u4ef7\u7ed3\u679c\u5f97\u5206\u8be6\u60c5\uff1a" + JSONArray.toJSONString(scores));
        return scores;
    }

    public List<EvalReportScoreModel> calcReportOrgDetailScores() {
        ArrayList<EvalReportScoreModel> scores = new ArrayList<EvalReportScoreModel>(this.targetSize);
        for (DynamicObject target : this.allEvalTargets) {
            EvalReportScoreModel scoreResult = new EvalReportScoreModel();
            Long finOrgId = this.getFinOrgId(target);
            scoreResult.setFinOrgId(finOrgId);
            scoreResult.setEvalScore(this.calcEvalScore(finOrgId));
            scoreResult.setDetailScore(this.calcOrgScore(finOrgId));
            scores.add(scoreResult);
        }
        logger.info("\u3010\u8bc4\u4ef7\u62a5\u544a\u3011\u8ba1\u7b97\u7ec4\u7ec7\u8bc4\u4ef7\u660e\u7ec6\u8be6\u60c5\uff1a" + JSONArray.toJSONString(scores));
        return scores;
    }

    private Long getFinOrgId(DynamicObject target) {
        if (this.isSpecify) {
            return target.getDynamicObject("fbasedataid").getLong("id");
        }
        return target.getDynamicObject("finorg").getLong("id");
    }

    public List<EvalExtraAddOrSubModel> calcExtraAddOrSubScores(String extraType) {
        ArrayList<EvalExtraAddOrSubModel> scores = new ArrayList<EvalExtraAddOrSubModel>(10);
        ArrayList<EvalItemScoreModel> allTargetScores = new ArrayList<EvalItemScoreModel>(this.allEvalTargets.size() * this.tasks.length);
        for (DynamicObject target : this.allEvalTargets) {
            Long finOrgId = this.getFinOrgId(target);
            List<EvalItemScoreModel> orgItemScores = this.getAllTaskDetailScore(finOrgId);
            allTargetScores.addAll(orgItemScores);
        }
        Map<String, List<EvalItemScoreModel>> mapGroupByFinOrgIdAndOrg = allTargetScores.stream().filter(o -> o.getExtraAddOrSub().equals(extraType)).collect(Collectors.groupingBy(v -> v.getFinOrgId() + "-" + v.getOrgId()));
        for (Map.Entry<String, List<EvalItemScoreModel>> entry : mapGroupByFinOrgIdAndOrg.entrySet()) {
            EvalExtraAddOrSubModel model = new EvalExtraAddOrSubModel();
            String[] splitKeys = StringUtils.split((String)entry.getKey(), (String)"-");
            model.setFinOrgId(Long.valueOf(splitKeys[0]));
            model.setOrgId(Long.valueOf(splitKeys[1]));
            List<EvalItemScoreModel> scoreList = entry.getValue();
            EvalItemScoreModel firstScore = scoreList.get(0);
            model.setTotalScore(firstScore.getTotalScore());
            model.setEvaluatorId(firstScore.getEvaluatorId());
            model.setOrgScore(firstScore.getOrgScore());
            model.setAddOrSubnfo("extraadd".equals(extraType) ? firstScore.getPlusInfo() : firstScore.getMinusInfo());
            List eachScores = scoreList.stream().map(EvalItemScoreModel::getScore).collect(Collectors.toList());
            BigDecimal addScore = eachScores.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            if (EmptyUtil.isEmpty((BigDecimal)addScore)) continue;
            model.setScore(addScore);
            scores.add(model);
        }
        scores.sort(new Comparator<EvalExtraAddOrSubModel>(){

            @Override
            public int compare(EvalExtraAddOrSubModel o1, EvalExtraAddOrSubModel o2) {
                int comp = o1.getFinOrgId().compareTo(o2.getFinOrgId());
                if (comp != 0) {
                    return comp;
                }
                return o1.getOrgId().compareTo(o2.getOrgId());
            }
        });
        logger.info("\u3010\u8bc4\u4ef7\u62a5\u544a\u3011\u8ba1\u7b97\u7ec4\u7ec7\u52a0\u51cf\u5206\u5f97\u5206\u8be6\u60c5\uff1a" + JSONArray.toJSONString(scores));
        return scores;
    }

    private BigDecimal calcEvalScore(Long finOrgId) {
        BigDecimal evalScore = this.evalScoreCache.get(finOrgId);
        if (EmptyUtil.isNoEmpty((BigDecimal)evalScore)) {
            return evalScore;
        }
        Map<Long, BigDecimal> allTaskScore = this.getAllTaskScore(finOrgId);
        switch (this.orgWeightEnum) {
            case AVERAGE: {
                evalScore = this.getAverageScore(allTaskScore);
                break;
            }
            case ORG: {
                evalScore = this.getOrgWeightScore(allTaskScore);
                break;
            }
        }
        this.evalScoreCache.put(finOrgId, evalScore);
        return evalScore;
    }

    private Map<Long, BigDecimal> calcDetailScore(Long finOrgId) {
        Map<Long, BigDecimal> result = null;
        List<EvalItemScoreModel> orgItemScores = this.getAllTaskDetailScore(finOrgId);
        switch (this.orgWeightEnum) {
            case AVERAGE: {
                result = this.getAverageDetailScore(orgItemScores);
                break;
            }
            case ORG: {
                result = this.getOrgWeightDetailScore(orgItemScores);
                break;
            }
        }
        return result;
    }

    private Map<Long, BigDecimal> calcOrgScore(Long finOrgId) {
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(this.tasks.length * 2);
        for (DynamicObject task : this.tasks) {
            Long evalOrgId = task.getDynamicObject("org").getLong("id");
            DynamicObject finOrgScoreInfo = this.getScoreInfo(task, finOrgId);
            BigDecimal evalScore = Constants.ZERO;
            if (EmptyUtil.isNoEmpty((DynamicObject)finOrgScoreInfo)) {
                evalScore = finOrgScoreInfo.getBigDecimal("totalscore");
            }
            result.put(evalOrgId, evalScore);
        }
        return result;
    }

    private BigDecimal getAverageScore(Map<Long, BigDecimal> allTaskScore) {
        return allTaskScore.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(allTaskScore.size()), 2, RoundingMode.HALF_UP);
    }

    private Map<Long, BigDecimal> getAverageDetailScore(List<EvalItemScoreModel> orgItemScores) {
        Map<Long, List<EvalItemScoreModel>> mapListGroupByNumber = orgItemScores.stream().collect(Collectors.groupingBy(EvalItemScoreModel::getItemId));
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(mapListGroupByNumber.size() * 2);
        mapListGroupByNumber.forEach((id, mapByNumberList) -> {
            OptionalDouble averageOpt = mapByNumberList.stream().mapToDouble(map -> map.getScore().doubleValue()).average();
            averageOpt.ifPresent(average -> result.put((Long)id, BigDecimal.valueOf(average).setScale(2, RoundingMode.HALF_UP)));
        });
        return result;
    }

    private BigDecimal getOrgWeightScore(Map<Long, BigDecimal> allTaskScore) {
        BigDecimal orgWeightScore = BigDecimal.ZERO;
        DynamicObjectCollection orgWeightEntrys = this.schedule.getDynamicObjectCollection("entryentity");
        for (Map.Entry<Long, BigDecimal> entry : allTaskScore.entrySet()) {
            BigDecimal weight = this.getOrgWeight(entry.getKey(), orgWeightEntrys).divide(Constants.ONE_HUNDRED, 2, RoundingMode.HALF_UP);
            BigDecimal orgScore = entry.getValue();
            orgWeightScore = orgWeightScore.add(orgScore.multiply(weight));
        }
        return orgWeightScore;
    }

    private Map<Long, BigDecimal> getOrgWeightDetailScore(List<EvalItemScoreModel> orgItemScores) {
        Map<Long, List<EvalItemScoreModel>> mapListGroupByNumber = orgItemScores.stream().collect(Collectors.groupingBy(EvalItemScoreModel::getItemId));
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(mapListGroupByNumber.size() * 2);
        mapListGroupByNumber.forEach((number, mapByNumberList) -> {
            BigDecimal orgWeightScore = BigDecimal.ZERO;
            for (EvalItemScoreModel itemScore : mapByNumberList) {
                orgWeightScore = orgWeightScore.add(itemScore.getScore().multiply(itemScore.getWeight())).setScale(2, RoundingMode.HALF_UP);
            }
            result.put((Long)number, orgWeightScore);
        });
        return result;
    }

    private Map<Long, BigDecimal> getAllTaskScore(Long finOrgId) {
        HashMap<Long, BigDecimal> allTaskScore = new HashMap<Long, BigDecimal>(this.tasks.length * 2);
        for (DynamicObject task : this.tasks) {
            DynamicObject finOrgScoreInfo = this.getScoreInfo(task, finOrgId);
            if (EmptyUtil.isEmpty((DynamicObject)finOrgScoreInfo)) continue;
            BigDecimal evalScore = finOrgScoreInfo.getBigDecimal("totalscore");
            allTaskScore.put(task.getDynamicObject("org").getLong("id"), evalScore);
        }
        return allTaskScore;
    }

    private List<EvalItemScoreModel> getAllTaskDetailScore(Long finOrgId) {
        DynamicObjectCollection evalItemEntry = this.evalProposal.getDynamicObjectCollection("entryentity");
        BigDecimal totalScore = this.calcEvalScore(finOrgId);
        DynamicObjectCollection orgWeightEntrys = this.schedule.getDynamicObjectCollection("entryentity");
        ArrayList<EvalItemScoreModel> itemScores = new ArrayList<EvalItemScoreModel>(evalItemEntry.size() * this.tasks.length);
        for (DynamicObject task : this.tasks) {
            DynamicObject finOrgScoreInfo = this.getScoreInfo(task, finOrgId);
            if (EmptyUtil.isEmpty((DynamicObject)finOrgScoreInfo)) continue;
            BigDecimal orgScore = finOrgScoreInfo.getBigDecimal("totalscore");
            String detailScore = finOrgScoreInfo.getString("detailscore_tag");
            String[] splitScore = detailScore.split(",");
            Long orgId = task.getDynamicObject("org").getLong("id");
            BigDecimal weight = Constants.ONE;
            if (this.orgWeightEnum == EvalOrgWeightEnum.ORG) {
                weight = this.getOrgWeight(orgId, orgWeightEntrys).divide(Constants.ONE_HUNDRED, 2, RoundingMode.HALF_UP);
            }
            for (int i = 0; i < evalItemEntry.size(); ++i) {
                DynamicObject evalItem = ((DynamicObject)evalItemEntry.get(i)).getDynamicObject("item");
                Long id = evalItem.getLong("id");
                BigDecimal score = new BigDecimal(splitScore[i]);
                EvalItemScoreModel itemScore = new EvalItemScoreModel(id, score, orgId, weight);
                itemScore.setFinOrgId(finOrgId);
                itemScore.setExtraAddOrSub(evalItem.getString("extraaddorsub"));
                itemScore.setDeduct(evalItem.getBoolean("isdeduct"));
                itemScore.setTotalScore(totalScore);
                itemScore.setOrgScore(orgScore);
                itemScore.setPlusInfo(finOrgScoreInfo.getString("plusinfo"));
                itemScore.setMinusInfo(finOrgScoreInfo.getString("minusinfo"));
                itemScore.setEvaluatorId(Long.valueOf(task.getDynamicObject("evaluator").getLong("id")));
                itemScores.add(itemScore);
            }
        }
        return itemScores;
    }

    private List<DynamicObject> getAllEvalTarget() {
        if (this.isSpecify) {
            String evalWay = this.schedule.getString("evalway");
            DynamicObject finType = this.schedule.getDynamicObject("fintype");
            DynamicObjectCollection evalTargets = BankEvalWayEnum.BRANCH.getValue().equals(evalWay) || !FinOrgTypeEnum.BANK.getNumber().equals(finType.getString("number")) ? this.schedule.getDynamicObjectCollection("evaltargetfin") : this.schedule.getDynamicObjectCollection("evaltarget");
            this.targetSize = evalTargets.size();
            return evalTargets;
        }
        ArrayList<DynamicObject> allTargets = new ArrayList<DynamicObject>(10);
        ArrayList<Long> exsitId = new ArrayList<Long>(10);
        for (DynamicObject task : this.tasks) {
            DynamicObjectCollection entrys = task.getDynamicObjectCollection("entryentity");
            for (DynamicObject targetEntry : entrys) {
                Long finOrgId = targetEntry.getDynamicObject("finorg").getLong("id");
                if (exsitId.contains(finOrgId)) continue;
                exsitId.add(finOrgId);
                allTargets.add(targetEntry);
            }
        }
        this.targetSize = allTargets.size();
        return allTargets;
    }

    private BigDecimal getOrgWeight(Long orgId, DynamicObjectCollection orgWeightEntrys) {
        DynamicObject orgWeight = orgWeightEntrys.stream().filter(o -> o.getDynamicObject("evaluateorg").getLong("id") == orgId.longValue()).findFirst().get();
        return orgWeight.getBigDecimal("evaluateorgwgt");
    }

    private DynamicObject getScoreInfo(DynamicObject task, Long finOrgId) {
        DynamicObjectCollection entrys = task.getDynamicObjectCollection("entryentity");
        return entrys.stream().filter(o -> o.getDynamicObject("finorg").getLong("id") == finOrgId.longValue()).findFirst().orElse(null);
    }
}

