/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.mservice.eval.impl;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.EvalReportStatusEnum;
import kd.tmc.tmbrm.common.enums.EvalWayEnum;
import kd.tmc.tmbrm.common.enums.ScheduleStatusEnum;
import kd.tmc.tmbrm.common.model.EvalExtraAddOrSubModel;
import kd.tmc.tmbrm.common.model.EvalReportScoreModel;
import kd.tmc.tmbrm.common.property.EvaluationReportProp;
import kd.tmc.tmbrm.mservice.eval.CalculateScoreExecute;
import kd.tmc.tmbrm.mservice.eval.IEvalReportService;

public class EvalReportService
implements IEvalReportService {
    private static final Log logger = LogFactory.getLog(EvalReportService.class);
    private static final String DEFAULT_ENCODING = "UTF-8";

    @Override
    public void genEvalReport(List<Long> taskIds) throws KDException {
        logger.info("\u751f\u6210\u8bc4\u4ef7\u62a5\u544a\uff0c\u4efb\u52a1\u6570\u91cf\uff1a" + taskIds.size());
        if (taskIds.size() < 1) {
            return;
        }
        DynamicObject evalTask = TmcDataServiceHelper.loadSingle((Object)taskIds.get(0), (String)"tmbrm_evalute_task");
        DynamicObject evalSchedule = evalTask.getDynamicObject("schedule");
        boolean exit = this.isExitNotAuditTask(evalSchedule, taskIds, false);
        if (exit) {
            String taskNo = evalTask.getString("billno");
            logger.info(taskNo + " \u4e0d\u662f\u6700\u540e\u4e00\u4e2a\u8bc4\u4ef7\u4efb\u52a1\uff0c\u4e0d\u751f\u6210\u8bc4\u4ef7\u62a5\u544a");
            return;
        }
        this.doGenReport(evalSchedule);
        this.updateSchedule(evalSchedule, ScheduleStatusEnum.EVALUATED.getValue());
    }

    @Override
    public void deleteEvalReport(List<Long> taskIds) {
        if (taskIds.size() < 1) {
            return;
        }
        logger.info("\u5220\u9664\u8bc4\u4ef7\u62a5\u544a\uff0c\u4efb\u52a1\u6570\u91cf\uff1a" + taskIds.size());
        DynamicObject evalTask = TmcDataServiceHelper.loadSingle((Object)taskIds.get(0), (String)"tmbrm_evalute_task");
        DynamicObject evalSchedule = evalTask.getDynamicObject("schedule");
        boolean exit = this.isExitNotAuditTask(evalSchedule, taskIds, true);
        if (exit) {
            String taskNo = evalTask.getString("billno");
            logger.info(taskNo + " \u4e0d\u662f\u6700\u540e\u4e00\u4e2a\u8bc4\u4ef7\u4efb\u52a1\uff0c\u4e0d\u5220\u9664\u8bc4\u4ef7\u62a5\u544a");
            return;
        }
        this.updateSchedule(evalSchedule, ScheduleStatusEnum.TOEVALUATED.getValue());
        QFilter[] filters = new QFilter[]{new QFilter("evalschedule", "=", evalSchedule.getPkValue())};
        boolean exitReport = TmcDataServiceHelper.exists((String)"tmbrm_eval_report", (QFilter[])filters);
        if (exitReport) {
            DeleteServiceHelper.delete((String)"tmbrm_eval_report", (QFilter[])filters);
        }
    }

    private void doGenReport(DynamicObject evalSchedule) throws KDException {
        logger.info("\u751f\u6210\u8bc4\u4ef7\u62a5\u544a\u5f00\u59cb...");
        DynamicObject report = this.getReportBill(evalSchedule);
        String scheduleNo = evalSchedule.getString("number");
        logger.info(scheduleNo + " -- \u751f\u6210\u8bc4\u4ef7\u62a5\u544a");
        this.setBaseInfo(report, evalSchedule);
        CalculateScoreExecute scoreExecute = new CalculateScoreExecute(evalSchedule);
        try {
            this.setEvalReportResult(report, scoreExecute);
            this.setEvalReportOrgDetail(report, scoreExecute);
            this.setOrgBonusNote(report, scoreExecute);
            this.setOrgMinusNote(report, scoreExecute);
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u8bc4\u4ef7\u62a5\u544a\uff0c\u8ba1\u7b97\u8bc4\u4ef7\u7ed3\u679c\u62a5\u9519", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u8bc4\u4ef7\u62a5\u544a\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"EvalReportService_01", (String)"tmc-tmbrm-mservice", (Object[])new Object[]{e.getMessage()}));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
        logger.info("\u751f\u6210\u8bc4\u4ef7\u62a5\u544a\u7ed3\u675f...");
    }

    private DynamicObject getReportBill(DynamicObject evalSchedule) {
        DynamicObject report = TmcDataServiceHelper.loadSingle((String)"tmbrm_eval_report", (QFilter[])new QFilter[]{new QFilter("evalschedule.id", "=", evalSchedule.getPkValue())});
        if (EmptyUtil.isEmpty((DynamicObject)report)) {
            report = TmcDataServiceHelper.newDynamicObject((String)"tmbrm_eval_report");
            CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)"tmbrm_eval_report", (DynamicObject)report, null);
            if (null == codeRule) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u8bc4\u4ef7\u62a5\u544a\u7684\u7f16\u7801\u89c4\u5219\uff0c\u5426\u5219\u65e0\u6cd5\u751f\u6210\u8bc4\u4ef7\u62a5\u544a\u3002", (String)"EvalReportService_00", (String)"tmc-tmbrm-mservice", (Object[])new Object[0]));
            }
            CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)report);
            String reportNumber = codeRule.getNumber();
            report.set("billno", (Object)reportNumber);
        }
        return report;
    }

    private void setEvalReportResult(DynamicObject report, CalculateScoreExecute scoreExecute) throws IOException {
        List<EvalReportScoreModel> reportScoreResults = scoreExecute.calcReportResultScores();
        DynamicObjectCollection resultEntry = report.getDynamicObjectCollection("resultentry");
        resultEntry.clear();
        for (EvalReportScoreModel scoreResult : reportScoreResults) {
            DynamicObject entry = resultEntry.addNew();
            entry.set("result_finorg", (Object)scoreResult.getFinOrgId());
            entry.set("resultevalpoint", (Object)scoreResult.getEvalScore());
            String str = SerializationUtils.serializeToBase64((Object)scoreResult.getDetailScore());
            entry.set("detailscore_tag", (Object)GzipUtils.compress((String)str, (String)DEFAULT_ENCODING));
        }
    }

    private void setEvalReportOrgDetail(DynamicObject report, CalculateScoreExecute scoreExecute) throws IOException {
        List<EvalReportScoreModel> orgScoreResults = scoreExecute.calcReportOrgDetailScores();
        DynamicObjectCollection detailEntry = report.getDynamicObjectCollection("detailentry");
        detailEntry.clear();
        for (EvalReportScoreModel scoreResult : orgScoreResults) {
            DynamicObject entry = detailEntry.addNew();
            entry.set("detail_finorg", (Object)scoreResult.getFinOrgId());
            entry.set("detail_evalpoint", (Object)scoreResult.getEvalScore());
            String str = SerializationUtils.serializeToBase64((Object)scoreResult.getDetailScore());
            entry.set("org_detailscore_tag", (Object)GzipUtils.compress((String)str, (String)DEFAULT_ENCODING));
        }
    }

    private void setOrgBonusNote(DynamicObject report, CalculateScoreExecute scoreExecute) {
        List<EvalExtraAddOrSubModel> extraList = scoreExecute.calcExtraAddOrSubScores("extraadd");
        this.setExtraInfo(report, extraList, "bonusentry");
    }

    private void setOrgMinusNote(DynamicObject report, CalculateScoreExecute scoreExecute) {
        List<EvalExtraAddOrSubModel> extraList = scoreExecute.calcExtraAddOrSubScores("extrasub");
        this.setExtraInfo(report, extraList, "minusentry");
    }

    private void setExtraInfo(DynamicObject report, List<EvalExtraAddOrSubModel> extraList, String entryProp) {
        DynamicObjectCollection detailEntry = report.getDynamicObjectCollection(entryProp);
        detailEntry.clear();
        Map extraPropMap = EvaluationReportProp.getExtraMap((String)entryProp);
        for (EvalExtraAddOrSubModel model : extraList) {
            DynamicObject entry = detailEntry.addNew();
            entry.set((String)extraPropMap.get("bonus_finorg"), (Object)model.getFinOrgId());
            entry.set((String)extraPropMap.get("bonus_evalpoint"), (Object)model.getTotalScore());
            entry.set((String)extraPropMap.get("bonuspoint"), (Object)model.getScore());
            entry.set((String)extraPropMap.get("plusinfo"), (Object)model.getAddOrSubnfo());
            entry.set((String)extraPropMap.get("bonus_org"), (Object)model.getOrgId());
            entry.set((String)extraPropMap.get("bonus_orgpoint"), (Object)model.getOrgScore());
            entry.set((String)extraPropMap.get("bonus_evaliator"), (Object)model.getEvaluatorId());
        }
    }

    private void setBaseInfo(DynamicObject report, DynamicObject evalSchedule) {
        report.set("org", (Object)evalSchedule.getDynamicObject("org"));
        report.set("evalschedule", (Object)evalSchedule);
        report.set("actualdate", (Object)new Date());
        report.set("reportstatus", (Object)EvalReportStatusEnum.WAIT_CHECK.getValue());
        report.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        report.set("generatetime", (Object)new Date());
        String finOrgType = FinOrgTypeEnum.BANK.getNumber().equals(evalSchedule.getDynamicObject("fintype").get("number")) && EvalWayEnum.HEAD.getValue().equals(evalSchedule.getString("evalway")) ? "bd_bankcgsetting" : "bd_finorginfo";
        report.set("finorgtype", (Object)finOrgType);
    }

    private boolean isExitNotAuditTask(DynamicObject evalSchedule, List<Long> taskIds, boolean isAudit) {
        QFilter filter = new QFilter("schedule.id", "=", evalSchedule.getPkValue());
        filter.and("id", "not in", taskIds);
        filter.and(new QFilter("billstatus", isAudit ? "=" : "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        return TmcDataServiceHelper.exists((String)"tmbrm_evalute_task", (QFilter[])new QFilter[]{filter});
    }

    private void updateSchedule(DynamicObject schedule, String schStatus) {
        schedule.set("schstatus", (Object)schStatus);
        SaveServiceHelper.update((DynamicObject)schedule);
    }
}

