/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.access;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.AccessApplyWfsNodeEnum;
import kd.tmc.tmbrm.common.enums.AccessBusiTypeEnum;
import kd.tmc.tmbrm.formplugin.access.AccessApplyPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AccessApplyEdit
extends AccessApplyPlugin
implements BeforeF7SelectListener {
    private static final String CACHE_VALIDATOR = "cache_validator";
    private static final String CACHE_EVALUATEITEM = "cache_evaluateitem";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid evalItemGrid = (EntryGrid)this.getControl("evalitementry");
        evalItemGrid.addCellClickListener((CellClickListener)this);
        BasedataEdit evalOrg = (BasedataEdit)this.getControl("evaluateorg");
        evalOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)showParameter.getAppId(), (String)this.getDataEntityName(), (String)this.getPermissionItem());
            showParameter.setCustomParam("range", (Object)orgIdSet);
        });
        BasedataEdit parent = (BasedataEdit)this.getControl("parent");
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finOrgType = (BasedataEdit)this.getControl("finorgtype");
        finOrgType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setViewVisibleAndInput();
        this.setDefaultData();
        this.cleanDataFromCopy();
    }

    private void cleanDataFromCopy() {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        if (param.containsKey("iscopy") && ((Boolean)param.get("iscopy")).booleanValue()) {
            IDataModel model = this.getModel();
            model.setValue("isgenfinorg", (Object)false);
            model.setValue("finorgnumber", null);
            model.setValue("invalidstatus", (Object)false);
            this.getView().updateView("invalidstatus");
            model.setValue("evalname", model.getValue("finorgname"));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("accesstype".equals(name)) {
            this.viewVisibleSetByAccessType();
            this.changeFinOrgType();
            this.cleanOptionField();
            this.setDefaultData();
        } else if ("bebank".equals(name)) {
            this.changeBeBank();
        } else if ("finorgname".equals(name)) {
            model.setValue("evalname", model.getValue("finorgname"));
        } else if ("evalproposal".equals(name)) {
            this.setEvalItemDetail();
        } else if ("inputscore".equals(name)) {
            this.calculateEvalScore();
        } else if ("finorgtype".equals(name)) {
            this.setBankSettingMustInput();
            model.setValue("parent", null);
        } else if (StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"billstatus", "company"})) {
            this.viewVisibleSetByAccessType();
        }
    }

    private void cleanOptionField() {
        IDataModel model = this.getModel();
        model.setValue("bebank", null);
        model.setValue("bankshortname", null);
        model.setValue("banknature", null);
        model.setValue("banksetting", null);
        model.setValue("parent", null);
        model.setValue("unioncode", null);
        model.setValue("swiftcode", null);
        model.setValue("parent", null);
        model.setValue("parent", null);
        model.setValue("parent", null);
    }

    private void setEvalItemDetail() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject proposal = (DynamicObject)model.getValue("evalproposal");
        if (EmptyUtil.isEmpty((DynamicObject)proposal)) {
            return;
        }
        DynamicObjectCollection itemList = proposal.getDynamicObjectCollection("entryentity");
        if (itemList.size() > 0) {
            model.deleteEntryData("evalitementry");
            model.batchCreateNewEntryRow("evalitementry", itemList.size());
            for (int i = 0; i < itemList.size(); ++i) {
                DynamicObject object = (DynamicObject)itemList.get(i);
                model.setValue("evalitem", (Object)object.getDynamicObject("item"), i);
                model.setValue("itemweight", (Object)object.getBigDecimal("weight"), i);
            }
            model.setValue("evalscore", (Object)BigDecimal.ZERO);
            this.showEvalRuleForm(((DynamicObject)itemList.get(0)).getDynamicObject("item").getPkValue().toString());
        }
    }

    private void calculateEvalScore() {
        BigDecimal maxScore;
        IDataModel model = this.getModel();
        DynamicObjectCollection evalEntry = model.getEntryEntity("evalitementry");
        EntryGrid control = (EntryGrid)this.getControl("evalitementry");
        int[] selectRows = control.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int row = control.getSelectRows()[0];
        DynamicObject evalRow = (DynamicObject)evalEntry.get(row);
        DynamicObject item = evalRow.getDynamicObject("evalitem");
        BigDecimal input = evalRow.getBigDecimal("inputscore");
        if (input.compareTo(maxScore = item.getBigDecimal("maxscore")) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u6570\u503c\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8be5\u8bc4\u4ef7\u9879\u76ee\u7684\u201c\u6700\u9ad8\u5206\u503c\u201d\u3002", (String)"AccessApplyEdit_1", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("inputscore", (Object)maxScore, row);
            return;
        }
        boolean isdeduct = item.getBoolean("isdeduct");
        BigDecimal sign = isdeduct ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        DynamicObject proposal = (DynamicObject)model.getValue("evalproposal");
        DynamicObject propItemRow = (DynamicObject)proposal.getDynamicObjectCollection("entryentity").get(row);
        BigDecimal itemScore = sign.multiply(input).multiply(propItemRow.getBigDecimal("weight")).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        model.setValue("itemscore", (Object)itemScore, row);
        evalEntry.stream().map(t -> t.getBigDecimal("itemscore")).reduce(BigDecimal::add).ifPresent(t -> model.setValue("evalscore", t));
    }

    private void setViewVisibleAndInput() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map params = showParameter.getCustomParams();
        String formKey = (String)params.get("formkey");
        if ("tmbrm_access_apply_s".equals(formKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"accessevalinfoap"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"surveydate", "surveyinfo"});
            this.addSurveyEntry(this.getModel());
        } else if ("tmbrm_access_apply_ac".equals(formKey)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"evaluateorg", "evaluatedate", "evalproposal", "bankevalway"});
        } else {
            this.viewVisibleSetByAccessType();
        }
        EntryGrid control = (EntryGrid)this.getControl("shareholdingentry");
        HashMap<String, Object> editMap = new HashMap<String, Object>(16);
        editMap.put("min", BigDecimal.ZERO);
        editMap.put("minm", "(");
        editMap.put("max", BigDecimal.valueOf(100L));
        editMap.put("maxm", "]");
        editMap.put("mi", true);
        editMap.put("nt", "D");
        editMap.put("pc", 23);
        editMap.put("roundMethod", "1");
        editMap.put("sc", 2);
        editMap.put("type", "number");
        editMap.put("vas", "underline");
        editMap.put("zs", false);
        control.setColumnProperty("spercent", "editor", editMap);
    }

    private void viewVisibleSetByAccessType() {
        boolean survey = false;
        boolean access = false;
        IDataModel model = this.getModel();
        DynamicObject accessType = (DynamicObject)model.getValue("accesstype");
        if (EmptyUtil.isNoEmpty((DynamicObject)accessType)) {
            survey = accessType.getBoolean("survey");
            access = accessType.getBoolean("access");
        }
        String billStatus = (String)model.getValue("billstatus");
        boolean invalid = (Boolean)model.getValue("invalidstatus");
        if (BillStatusEnum.SAVE.getValue().equals(billStatus) && !invalid) {
            DynamicObject company = (DynamicObject)model.getValue("company");
            long orgId = EmptyUtil.isNoEmpty((DynamicObject)company) ? company.getLong("id") : RequestContext.get().getOrgId();
            boolean enterSurveyParam = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.TMBRM.getId(), (long)orgId, (String)"entersurveyinfo");
            boolean enterAccessEvalParam = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.TMBRM.getId(), (long)orgId, (String)"enteraccessevalinfo");
            survey = survey && enterSurveyParam;
            access = access && enterAccessEvalParam;
            model.setValue("entersurvey", (Object)survey);
            model.setValue("enteraccesseval", (Object)access);
        } else {
            String billId = this.getModel().getValue("id").toString();
            Map map = WorkflowServiceHelper.getBizProcessStatus((String[])new String[]{billId});
            List processStatus = (List)map.get(billId);
            if (EmptyUtil.isNoEmpty((Object)processStatus)) {
                String currNode = ((BizProcessStatus)processStatus.get(0)).getCurrentNodeName();
                if (AccessApplyWfsNodeEnum.SUBMIT.getEnumBridge().equals(currNode) || AccessApplyWfsNodeEnum.SURVEY.getEnumBridge().equals(currNode)) {
                    survey = false;
                    access = false;
                } else if (AccessApplyWfsNodeEnum.ACCESS.getEnumBridge().equals(currNode)) {
                    access = false;
                }
            }
        }
        this.getView().setVisible(Boolean.valueOf(survey), new String[]{"surveyinfoap"});
        this.getView().setVisible(Boolean.valueOf(access), new String[]{"accessevalinfoap"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)survey, (String[])new String[]{"surveydate", "surveyinfo", "surveyelement", "evaluation", "surveyuser"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)access, (String[])new String[]{"evaluateorg", "evaluatedate", "evalproposal", "bankevalway", "inputscore"});
    }

    private void setDefaultData() {
        IDataModel model = this.getModel();
        String billStatus = (String)model.getValue("billstatus");
        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            this.addSurveyEntry(model);
        }
        this.setBankSettingMustInput();
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"evalname", (Object)model.getValue("finorgname"));
    }

    private void addSurveyEntry(IDataModel model) {
        DynamicObjectCollection entryEntity = model.getEntryEntity("surveyentry");
        boolean invalid = (Boolean)model.getValue("invalidstatus");
        if (!invalid && EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            model.batchCreateNewEntryRow("surveyentry", 1);
            model.setValue("surveyuser", (Object)RequestContext.get().getCurrUserId(), 0);
        }
    }

    private void setBankSettingMustInput() {
        DynamicObject finOrgType = (DynamicObject)this.getModel().getValue("finorgtype");
        String number = EmptyUtil.isNoEmpty((DynamicObject)finOrgType) ? finOrgType.getString("number") : "";
        boolean isBank = FinOrgTypeEnum.BANK.getNumber().equals(number);
        BasedataEdit control = (BasedataEdit)this.getControl("banksetting");
        control.setMustInput(isBank);
    }

    @Override
    public void cellClick(CellClickEvent cellClickEvent) {
        super.cellClick(cellClickEvent);
        this.processClick(cellClickEvent);
    }

    @Override
    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        super.cellClick(cellClickEvent);
        this.processClick(cellClickEvent);
    }

    private void processClick(CellClickEvent event) {
        EntryGrid source;
        if (event.getSource() instanceof EntryGrid && "evalitementry".equals((source = (EntryGrid)event.getSource()).getEntryKey())) {
            DynamicObject item = ((DynamicObject)this.getModel().getEntryEntity("evalitementry").get(event.getRow())).getDynamicObject("evalitem");
            this.showEvalRuleForm(item.getPkValue().toString());
        }
    }

    private void showEvalRuleForm(String itemId) {
        String cacheRow = this.getPageCache().get(CACHE_EVALUATEITEM);
        if (EmptyUtil.isNotBlank((CharSequence)cacheRow) && cacheRow.equals(itemId)) {
            return;
        }
        this.getPageCache().put(CACHE_EVALUATEITEM, itemId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setFormId("tmbrm_accessapply_ruleap");
        parameter.getOpenStyle().setTargetKey("rulepanel");
        parameter.setCustomParam("evalitem", (Object)itemId);
        this.getView().showForm(parameter);
    }

    private void changeFinOrgType() {
        IDataModel model = this.getModel();
        DynamicObject accessType = (DynamicObject)model.getValue("accesstype");
        if (EmptyUtil.isNoEmpty((DynamicObject)accessType) && StringUtils.equalsAny((CharSequence)accessType.getString("businesstype"), (CharSequence[])new CharSequence[]{AccessBusiTypeEnum.NEW.getValue(), AccessBusiTypeEnum.BRANCH.getValue()})) {
            model.setValue("finorgtype", (Object)TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorgtype", (QFilter[])new QFilter("number", "=", (Object)FinOrgTypeEnum.BANK.getNumber()).toArray()));
        } else {
            model.setValue("finorgtype", null);
        }
    }

    private void changeBeBank() {
        IDataModel model = this.getModel();
        if (EmptyUtil.isEmpty((Object)model.getValue("bebank"))) {
            return;
        }
        DynamicObject beBank = (DynamicObject)model.getValue("bebank");
        model.setValue("finorgname", (Object)beBank.getString("name"));
        model.setValue("unioncode", (Object)beBank.getString("union_number"));
        model.setValue("swiftcode", (Object)beBank.getString("swift_code"));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("parent".equals(propName)) {
            DynamicObject typeObj = (DynamicObject)this.getModel().getValue("finorgtype");
            if (EmptyUtil.isNoEmpty((DynamicObject)typeObj)) {
                ListShowParameter listShowPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("finorgtype", "=", typeObj.getPkValue());
                listShowPara.getListFilterParameter().setFilter(filter);
                listShowPara.setCustomParam("finType", typeObj.getPkValue());
            }
        } else if ("finorgtype".equals(propName)) {
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            parameter.getListFilterParameter().setFilter(new QFilter("number", "!=", (Object)FinOrgTypeEnum.BANK.getNumber()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject archivesBill;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"save", "submit"})) {
            this.validateSave(args);
            this.getModel().forceClearNoDataRow();
        } else if ("invalidaccess".equals(operateKey) && EmptyUtil.isNoEmpty((DynamicObject)(archivesBill = TmcBotpHelper.getTargetBill((String)this.getDataEntityName(), (Object)this.getModel().getValue("id"), (String)"tmbrm_finorg_archives")))) {
            String archivesStatus = archivesBill.getString("billstatus");
            if (!BillStatusEnum.SAVE.getValue().equals(archivesStatus)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u51c6\u5165\u7533\u8bf7\u5df2\u751f\u6210\u91d1\u878d\u673a\u6784\u6863\u6848\u4e14\u975e\u6682\u5b58\u72b6\u6001\uff08\u6863\u6848\u7f16\u53f7\uff1a%s\uff09\uff0c\u4f5c\u5e9f\u51c6\u5165\u7533\u8bf7\u4e0d\u4f1a\u8054\u52a8\u5220\u9664\u6863\u6848\uff0c\u5982\u9700\u66f4\u65b0\u6216\u5220\u9664\u6863\u6848\uff0c\u8bf7\u5230\u91d1\u878d\u673a\u6784\u6863\u6848\u83dc\u5355\u64cd\u4f5c\u3002", (String)"AccessApplyEdit_2", (String)"tmc-tmbrm-formplugin", (Object[])new Object[]{this.getModel().getValue("billno")}), MessageBoxOptions.OK);
            }
        }
    }

    private void validateSave(BeforeDoOperationEventArgs args) {
        List list;
        String validItem = this.getPageCache().get(CACHE_VALIDATOR);
        if (StringUtils.isNotBlank((CharSequence)validItem) && CollectionUtils.isNotEmpty((Collection)(list = SerializationUtils.fromJsonStringToList((String)validItem, String.class)))) {
            args.setCancel(true);
            String join = StringUtils.join((Iterable)list, (String)"\uff1b");
            this.getView().showErrorNotification(join);
        }
    }
}

