/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.property.TmcTreeNodeProp;
import kd.tmc.fbp.common.property.TmcTreeNodeRefProp;
import kd.tmc.fbp.common.property.TmcTreeNodeTypeProp;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.tree.AbstractTmcTreeList;

public class SurveyElementTreeList
extends AbstractTmcTreeList {
    protected static final TmcTreeNodeTypeProp NODE_NON_LEAF = new TmcTreeNodeTypeProp("non_leaf", TmcTreeNodeTypeProp.ROOT, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    protected static final TmcTreeNodeTypeProp NODE_LEAF = new TmcTreeNodeTypeProp("leaf", TmcTreeNodeTypeProp.ROOT, TmcTreeNodeTypeProp.LeafMode.LEAF);

    protected List<TmcTreeNodeTypeProp> getTreeNodeTypeList() {
        return Arrays.asList(NODE_NON_LEAF, NODE_LEAF);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode != null) {
            rootNode.setText(ResManager.loadKDString((String)"\u4ea7\u54c1\u4e0e\u670d\u52a1\u9879\u76ee", (String)"SurveyElementTreeList_0", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
        }
    }

    protected List<TmcTreeNodeRefProp> loadTreeNodeList(TmcTreeNodeProp currNode) {
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        List<TmcTreeNodeRefProp> nodeList = null;
        QFilter qFilter = new QFilter("group.number", "=", (Object)"CPYFWXM");
        if (TmcTreeNodeTypeProp.ROOT.equals((Object)nodeType)) {
            qFilter.and("level", "=", (Object)1);
            nodeList = this.loadTreeNodeList(qFilter);
        } else if (NODE_NON_LEAF.equals((Object)nodeType)) {
            String pkValue = (String)currNode.getRefEntityPkValue();
            qFilter.and("parent.id", "=", (Object)Long.valueOf(pkValue));
            nodeList = this.loadTreeNodeList(qFilter);
        }
        return nodeList;
    }

    protected QFilter getBillListFilter(TmcTreeNodeProp currNode) {
        Object refId = currNode.getRefEntityPkValue();
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (EmptyUtil.isNoEmpty((Object)refId)) {
            filter = filter.and("item.id", "=", (Object)Long.valueOf(refId.toString()));
        }
        return filter;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        TreeNode currNode = this.getNodeById(e.getNodeId());
        TmcTreeNodeProp treeNodeProp = new TmcTreeNodeProp(currNode, this.getTreeModel().getRoot(), this.getTreeNodeTypeList());
        TmcTreeNodeTypeProp nodeType = treeNodeProp.getNodeType();
        if (NODE_LEAF.equals((Object)nodeType) || NODE_NON_LEAF.equals((Object)nodeType)) {
            Object refId = treeNodeProp.getRefEntityPkValue();
            this.getPageCache().put("item", refId.toString());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        TmcTreeNodeProp currNodeProp;
        if ("new".equals(evt.getOperationKey()) && (currNodeProp = this.getCurrentNodeModel()).isRoot()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5de6\u6811\u9009\u62e9\u5408\u9002\u7684\u8282\u70b9\uff0c\u518d\u65b0\u589e\u6216\u4fee\u6539\u8d44\u6599\u3002", (String)"SurveyElementTreeList_1", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private List<TmcTreeNodeRefProp> loadTreeNodeList(QFilter qFilter) {
        DynamicObjectCollection serviceItems = QueryServiceHelper.query((String)"bos_assistantdata_detail", (String)"number,name,id,level,isleaf", (QFilter[])qFilter.toArray(), (String)"number asc");
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(serviceItems.size());
        for (DynamicObject serviceItem : serviceItems) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            node.setNodeName(serviceItem.getString("name"));
            Boolean isleaf = (Boolean)serviceItem.get("isleaf");
            node.setNodeType(isleaf != false ? NODE_LEAF : NODE_NON_LEAF);
            node.setRefEntityPkValue((Object)serviceItem.getString("id"));
            nodeList.add(node);
        }
        return nodeList;
    }
}

