/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.archives;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.FinOrgDataAreaEnum;
import kd.tmc.tmbrm.common.enums.FinOrgDateScopeEnum;
import kd.tmc.tmbrm.common.helper.FinOrgCoDataHelper;
import kd.tmc.tmbrm.common.property.FinOrgCoDataProp;
import org.apache.commons.collections4.CollectionUtils;

public class FinOrgCoDataFormEdit
extends AbstractFormPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid evalItemGrid = (EntryGrid)this.getControl("dploanentry");
        evalItemGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String manageOrg = (String)parameter.getCustomParam("manageorg");
        String billId = (String)parameter.getCustomParam("id");
        String currency = (String)parameter.getCustomParam("currency");
        String unit = (String)parameter.getCustomParam("unit");
        this.fillCoData(Long.parseLong(billId), Long.parseLong(manageOrg), Long.parseLong(currency), unit);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CardEntry cardPanel = (CardEntry)this.getControl("dploanentry");
        cardPanel.selectCard(Integer.valueOf(0));
        this.getView().setVisible(Boolean.FALSE, FinOrgCoDataProp.DEPOSIT_LOAN_PANEL);
        this.getView().setVisible(Boolean.TRUE, new String[]{FinOrgCoDataProp.DEPOSIT_LOAN_PANEL[0]});
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid source;
        super.entryRowClick(evt);
        if (evt.getSource() instanceof EntryGrid && "dploanentry".equals((source = (EntryGrid)evt.getSource()).getEntryKey())) {
            this.getView().setVisible(Boolean.FALSE, FinOrgCoDataProp.DEPOSIT_LOAN_PANEL);
            this.getView().setVisible(Boolean.TRUE, new String[]{FinOrgCoDataProp.DEPOSIT_LOAN_PANEL[evt.getRow()]});
        }
    }

    private void fillCoData(long billId, long orgId, Long tarCurrencyId, String unit) {
        DynamicObject coData = TmcDataServiceHelper.loadSingle((Object)billId, (String)"tmbrm_finorg_codata");
        this.convertAmount(coData, orgId, tarCurrencyId, unit);
        this.setDataModelHead(coData, "totalaccount", "domesticaccount", "overseaaccount", "dicrectaccount");
        this.setDepositData(coData);
        this.setLoanData(coData);
        this.setCreditData(coData);
        this.setBondData(coData);
        this.setDpLoanData();
        this.setSettleData(coData);
    }

    private void setDepositData(DynamicObject coData) {
        this.setSubEntry(coData, "depositentry", "1", t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("depositarea")) && BigDecimal.ZERO.compareTo(t.getBigDecimal("depositamount")) != 0, "deposittype", "depositamount", "depositincome", "depositavgamount");
        this.setSubEntry(coData, "depositentry", "2", t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("depositarea")) && BigDecimal.ZERO.compareTo(t.getBigDecimal("depositamount")) != 0, "deposittype", "depositamount", "depositincome", "depositavgamount");
        this.setSubEntry(coData, "depositentry", "3", t -> BigDecimal.ZERO.compareTo(t.getBigDecimal("depositamount")) != 0, "deposittype", "depositamount", "depositincome", "depositavgamount");
        this.calculateRate("depositentry", "depositamount", "depositrate");
        this.accEntryToField("depositentry", "depositavgrate", (p, q) -> FinOrgCoDataHelper.rateToString((BigDecimal)p.getBigDecimal("depositincome" + q), (BigDecimal)p.getBigDecimal("depositavgamount" + q)));
        this.setBalanceVal();
    }

    private void setBalanceVal() {
        block0: for (String suffix : FinOrgCoDataProp.ALL_SUFFIX) {
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("depositentry" + suffix);
            for (DynamicObject object : entryList) {
                if (!"0".equals(object.getString("deposittype" + suffix))) continue;
                object.set("depositavgrate" + suffix, (Object)"--");
                continue block0;
            }
        }
    }

    private void calculateRate(String entry, String amountKey, String rateKey) {
        IDataModel model = this.getModel();
        for (String suffix : FinOrgCoDataProp.ALL_SUFFIX) {
            model.getEntryEntity(entry + suffix).stream().map(t -> t.getBigDecimal(amountKey + suffix)).reduce(BigDecimal::add).ifPresent(t -> model.getEntryEntity(entry + suffix).forEach(w -> w.set(rateKey + suffix, (Object)FinOrgCoDataHelper.rateToString((BigDecimal)w.getBigDecimal(amountKey + suffix), (BigDecimal)t))));
        }
    }

    private void setLoanData(DynamicObject coData) {
        this.setValueFromEntry(coData, "loanentry", "1", t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("loanarea")) && !FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loanaccuamount", t -> t.getBigDecimal("loanamount")));
        this.setRateValueFromEntry(coData, t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("loanarea")) && !FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loancost1");
        this.setValueFromEntry(coData, "loanentry", "1", t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loancurbalance", t -> t.getBigDecimal("loancurbalance")));
        this.setRateValueFromEntry(coData, t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loancurcost1");
        this.setValueFromEntry(coData, "loanentry", "1", t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.YEAR.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loanyearamount", t -> t.getBigDecimal("loanamount")));
        this.setRateValueFromEntry(coData, t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.YEAR.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loanyearcost1");
        this.setValueFromEntry(coData, "loanentry", "1", t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.LAST_YEAR.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loanlastyearamount", t -> t.getBigDecimal("loanamount")));
        this.setRateValueFromEntry(coData, t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.LAST_YEAR.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loanlastyearcost1");
        this.setValueFromEntry(coData, "loanentry", "2", t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("loanarea")) && !FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loanaccuamount", t -> t.getBigDecimal("loanamount")));
        this.setRateValueFromEntry(coData, t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("loanarea")) && !FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loancost2");
        this.setValueFromEntry(coData, "loanentry", "2", t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loancurbalance", t -> t.getBigDecimal("loancurbalance")));
        this.setRateValueFromEntry(coData, t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loancurcost2");
        this.setValueFromEntry(coData, "loanentry", "2", t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.YEAR.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loanyearamount", t -> t.getBigDecimal("loanamount")));
        this.setRateValueFromEntry(coData, t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.YEAR.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loanyearcost2");
        this.setValueFromEntry(coData, "loanentry", "2", t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.LAST_YEAR.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loanlastyearamount", t -> t.getBigDecimal("loanamount")));
        this.setRateValueFromEntry(coData, t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("loanarea")) && FinOrgDateScopeEnum.LAST_YEAR.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loanlastyearcost2");
        this.setValueFromEntry(coData, "loanentry", "3", t -> !FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loanaccuamount", t -> t.getBigDecimal("loanamount")));
        this.setRateValueFromEntry(coData, t -> !FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loancost3");
        this.setValueFromEntry(coData, "loanentry", "3", t -> FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loancurbalance", t -> t.getBigDecimal("loancurbalance")));
        this.setRateValueFromEntry(coData, t -> FinOrgDateScopeEnum.CURRENT.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loancurcost3");
        this.setValueFromEntry(coData, "loanentry", "3", t -> FinOrgDateScopeEnum.YEAR.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loanyearamount", t -> t.getBigDecimal("loanamount")));
        this.setRateValueFromEntry(coData, t -> FinOrgDateScopeEnum.YEAR.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loanyearcost3");
        this.setValueFromEntry(coData, "loanentry", "3", t -> FinOrgDateScopeEnum.LAST_YEAR.getValue().equals(t.getString("loandatescope")), Tuple.create((Object)"loanlastyearamount", t -> t.getBigDecimal("loanamount")));
        this.setRateValueFromEntry(coData, t -> FinOrgDateScopeEnum.LAST_YEAR.getValue().equals(t.getString("loandatescope")), t -> t.getBigDecimal("loancost"), t -> t.getBigDecimal("loanavgbalance"), "loanlastyearcost3");
    }

    private void setCreditData(DynamicObject coData) {
        this.setValueFromEntry(coData, "creditentry", "1", t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("creditarea")), Tuple.create((Object)"creditamount", t -> t.getBigDecimal("creditamount")), Tuple.create((Object)"creditaccuuse", t -> (BigDecimal)FinOrgCoDataHelper.addMulti((Object[])new BigDecimal[]{t.getBigDecimal("credityear"), t.getBigDecimal("creditlastyear"), t.getBigDecimal("creditnextyear")})), Tuple.create((Object)"credityearuse", t -> t.getBigDecimal("credityear")), Tuple.create((Object)"creditlasyearuse", t -> t.getBigDecimal("creditlastyear")));
        this.setValueFromEntry(coData, "creditentry", "2", t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("creditarea")), Tuple.create((Object)"creditamount", t -> t.getBigDecimal("creditamount")), Tuple.create((Object)"creditaccuuse", t -> (BigDecimal)FinOrgCoDataHelper.addMulti((Object[])new BigDecimal[]{t.getBigDecimal("credityear"), t.getBigDecimal("creditlastyear"), t.getBigDecimal("creditnextyear")})), Tuple.create((Object)"credityearuse", t -> t.getBigDecimal("credityear")), Tuple.create((Object)"creditlasyearuse", t -> t.getBigDecimal("creditlastyear")));
        this.setValueFromEntry(coData, "creditentry", "3", t -> true, Tuple.create((Object)"creditamount", t -> t.getBigDecimal("creditamount")), Tuple.create((Object)"creditaccuuse", t -> (BigDecimal)FinOrgCoDataHelper.addMulti((Object[])new BigDecimal[]{t.getBigDecimal("credityear"), t.getBigDecimal("creditlastyear"), t.getBigDecimal("creditnextyear")})), Tuple.create((Object)"credityearuse", t -> t.getBigDecimal("credityear")), Tuple.create((Object)"creditlasyearuse", t -> t.getBigDecimal("creditlastyear")));
    }

    private void setBondData(DynamicObject coData) {
        this.setValueFromEntry(coData, "bondentry", "1", t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("bondarea")), Tuple.create((Object)"bondinveaccu", t -> t.getBigDecimal("bondinveamount")), Tuple.create((Object)"bondconaccu", t -> t.getBigDecimal("bondconamount")));
        this.setValueFromEntry(coData, "bondentry", "1", t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("bondarea")) && FinOrgDateScopeEnum.YEAR.getValue().equals(t.getString("bonddatescope")), Tuple.create((Object)"bondinveyear", t -> t.getBigDecimal("bondinveamount")), Tuple.create((Object)"bondconyear", t -> t.getBigDecimal("bondconamount")));
        this.setValueFromEntry(coData, "bondentry", "1", t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("bondarea")) && FinOrgDateScopeEnum.LAST_YEAR.getValue().equals(t.getString("bonddatescope")), Tuple.create((Object)"bondinvelastyear", t -> t.getBigDecimal("bondinveamount")), Tuple.create((Object)"bondconlastyear", t -> t.getBigDecimal("bondconamount")));
        this.setValueFromEntry(coData, "bondentry", "2", t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("bondarea")), Tuple.create((Object)"bondinveaccu", t -> t.getBigDecimal("bondinveamount")), Tuple.create((Object)"bondconaccu", t -> t.getBigDecimal("bondconamount")));
        this.setValueFromEntry(coData, "bondentry", "2", t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("bondarea")) && FinOrgDateScopeEnum.YEAR.getValue().equals(t.getString("bonddatescope")), Tuple.create((Object)"bondinveyear", t -> t.getBigDecimal("bondinveamount")), Tuple.create((Object)"bondconyear", t -> t.getBigDecimal("bondconamount")));
        this.setValueFromEntry(coData, "bondentry", "2", t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("bondarea")) && FinOrgDateScopeEnum.LAST_YEAR.getValue().equals(t.getString("bonddatescope")), Tuple.create((Object)"bondinvelastyear", t -> t.getBigDecimal("bondinveamount")), Tuple.create((Object)"bondconlastyear", t -> t.getBigDecimal("bondconamount")));
        this.setValueFromEntry(coData, "bondentry", "3", t -> true, Tuple.create((Object)"bondinveaccu", t -> t.getBigDecimal("bondinveamount")), Tuple.create((Object)"bondconaccu", t -> t.getBigDecimal("bondconamount")));
        this.setValueFromEntry(coData, "bondentry", "3", t -> FinOrgDateScopeEnum.YEAR.getValue().equals(t.getString("bonddatescope")), Tuple.create((Object)"bondinveyear", t -> t.getBigDecimal("bondinveamount")), Tuple.create((Object)"bondconyear", t -> t.getBigDecimal("bondconamount")));
        this.setValueFromEntry(coData, "bondentry", "3", t -> FinOrgDateScopeEnum.LAST_YEAR.getValue().equals(t.getString("bonddatescope")), Tuple.create((Object)"bondinvelastyear", t -> t.getBigDecimal("bondinveamount")), Tuple.create((Object)"bondconlastyear", t -> t.getBigDecimal("bondconamount")));
    }

    private void setValueFromEntry(DynamicObject coData, String entry, String suffix, Predicate<DynamicObject> filter, Tuple<String, Function<DynamicObject, Object>> ... mapList) {
        List list = coData.getDynamicObjectCollection(entry).stream().filter(filter).collect(Collectors.toList());
        for (Tuple<String, Function<DynamicObject, Object>> item : mapList) {
            list.stream().map((Function)item.item2).reduce(FinOrgCoDataHelper::add).ifPresent(t -> this.getModel().setValue((String)item.item1 + suffix, t));
        }
    }

    private void setRateValueFromEntry(DynamicObject coData, Predicate<DynamicObject> filter, Function<DynamicObject, BigDecimal> topMapper, Function<DynamicObject, BigDecimal> subMapper, String key) {
        Tuple tuple = coData.getDynamicObjectCollection("loanentry").stream().filter(filter).collect(Collectors.toList()).stream().map(t -> Tuple.create(topMapper.apply((DynamicObject)t), subMapper.apply((DynamicObject)t))).reduce((p, q) -> Tuple.create((Object)FinOrgCoDataHelper.add((Object)p.item1, (Object)q.item1), (Object)FinOrgCoDataHelper.add((Object)p.item2, (Object)q.item2))).orElseGet(() -> Tuple.create((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
        this.getModel().setValue(key, (Object)FinOrgCoDataHelper.rateToString((BigDecimal)((BigDecimal)tuple.item1), (BigDecimal)((BigDecimal)tuple.item2)));
    }

    private void setDpLoanData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("dploanentry");
        for (Supplier fun : FinOrgCoDataProp.DEPOSIT_LOAN_NAME) {
            DynamicObject object = entryEntity.addNew();
            object.set("sumlabel", fun.get());
        }
        model.getEntryEntity("depositentry3").stream().map(t -> t.getBigDecimal("depositamount3")).reduce(FinOrgCoDataHelper::add).ifPresent(t -> model.setValue("sumamount", t, 0));
        model.getEntryEntity("depositentry1").stream().map(t -> t.getBigDecimal("depositamount1")).reduce(FinOrgCoDataHelper::add).ifPresent(t -> model.setValue("domesticamount", t, 0));
        model.getEntryEntity("depositentry2").stream().map(t -> t.getBigDecimal("depositamount2")).reduce(FinOrgCoDataHelper::add).ifPresent(t -> model.setValue("overseaamount", t, 0));
        model.setValue("sumamount", model.getValue("loanaccuamount3"), 1);
        model.setValue("domesticamount", model.getValue("loanaccuamount1"), 1);
        model.setValue("overseaamount", model.getValue("loanaccuamount2"), 1);
        model.setValue("sumamount", model.getValue("creditamount3"), 2);
        model.setValue("domesticamount", model.getValue("creditamount1"), 2);
        model.setValue("overseaamount", model.getValue("creditamount2"), 2);
        model.setValue("sumamount", model.getValue("bondinveaccu3"), 3);
        model.setValue("domesticamount", model.getValue("bondinveaccu1"), 3);
        model.setValue("overseaamount", model.getValue("bondinveaccu2"), 3);
    }

    private void convertAmount(DynamicObject coData, long orgId, Long tarCurrencyId, String unit) {
        if ("100000000".equals(unit) && 1L == tarCurrencyId) {
            return;
        }
        HashMap<Long, BigDecimal> rateMap = new HashMap<Long, BigDecimal>(16);
        if (1L != tarCurrencyId) {
            List currencyList = FinOrgCoDataProp.ENTRY_CURRENCY_MAP.keySet().stream().flatMap(t -> coData.getDynamicObjectCollection(t).stream().filter(w -> Objects.nonNull(w.getDynamicObject((String)((Tuple)FinOrgCoDataProp.ENTRY_CURRENCY_MAP.get((Object)t)).item1))).map(w -> w.getDynamicObject((String)((Tuple)FinOrgCoDataProp.ENTRY_CURRENCY_MAP.get((Object)t)).item1).getLong("id"))).distinct().collect(Collectors.toList());
            DataSet exChangeDataSet = TmcBusinessBaseHelper.getExChangeDataSet(currencyList, (Long)tarCurrencyId, (long)orgId, (Date)new Date(), (boolean)true);
            Object object = null;
            try {
                for (Row next : exChangeDataSet) {
                    rateMap.put(next.getLong("tarcurrency"), next.getBigDecimal("rate"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (exChangeDataSet != null) {
                    if (object != null) {
                        try {
                            exChangeDataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        exChangeDataSet.close();
                    }
                }
            }
        }
        BigDecimal tarUnit = new BigDecimal(unit);
        BigDecimal defUnit = new BigDecimal("100000000");
        for (Map.Entry entry : FinOrgCoDataProp.ENTRY_CURRENCY_MAP.entrySet()) {
            DynamicObjectCollection entryList = coData.getDynamicObjectCollection((String)entry.getKey());
            if (CollectionUtils.isEmpty((Collection)entryList)) continue;
            Tuple tuple = (Tuple)entry.getValue();
            BigDecimal rate = BigDecimal.ONE;
            if (Objects.nonNull(((DynamicObject)entryList.get(0)).getDynamicObject((String)tuple.item1))) {
                long curCurrencyId = ((DynamicObject)entryList.get(0)).getDynamicObject((String)tuple.item1).getLong("id");
                rate = rateMap.getOrDefault(curCurrencyId, BigDecimal.ONE);
            }
            for (DynamicObject object : entryList) {
                for (String key : (String[])tuple.item2) {
                    BigDecimal amount = object.getBigDecimal(key).multiply(defUnit).multiply(rate).divide(tarUnit, 10, RoundingMode.HALF_UP);
                    object.set(key, (Object)amount);
                }
            }
        }
    }

    private void setSettleData(DynamicObject coData) {
        this.setSubEntry(coData, "settleentry", "1", t -> FinOrgDataAreaEnum.DOMESTIC.getValue().equals(t.getString("settlearea")), "yearscope", "inamount", "outamount", "innum", "outnum");
        this.setSubEntry(coData, "settleentry", "2", t -> FinOrgDataAreaEnum.OVERSEA.getValue().equals(t.getString("settlearea")), "yearscope", "inamount", "outamount", "innum", "outnum");
        this.setSubEntry(coData, "settleentry", "3", t -> true, "yearscope", "inamount", "outamount", "innum", "outnum");
        this.accEntryToField("settleentry", "ioamount", (p, q) -> FinOrgCoDataHelper.mergeColumn((DynamicObject)p, (String[])this.withSuffix((String)q, "inamount", "outamount")));
        this.accEntryToField("settleentry", "ionum", (p, q) -> FinOrgCoDataHelper.mergeColumn((DynamicObject)p, (String[])this.withSuffix((String)q, "innum", "outnum")));
        this.setHeadValueInEntry(FinOrgDateScopeEnum.YEAR.getValue(), "ioamount", "curyearamount", BigDecimal.ZERO);
        this.setHeadValueInEntry(FinOrgDateScopeEnum.YEAR.getValue(), "ionum", "curyearnum", 0);
        this.setHeadValueInEntry(FinOrgDateScopeEnum.LAST_YEAR.getValue(), "ioamount", "lastyearamount", BigDecimal.ZERO);
        this.setHeadValueInEntry(FinOrgDateScopeEnum.LAST_YEAR.getValue(), "ionum", "lastyearnum", 0);
    }

    private void setDataModelHead(DynamicObject coData, String ... keys) {
        IDataModel model = this.getModel();
        for (String key : keys) {
            model.setValue(key, coData.get(key));
        }
    }

    private void setSubEntry(DynamicObject coData, String sourceEntry, String targetSuffix, Predicate<DynamicObject> filter, String groupKey, String ... dataKeys) {
        List dataList = coData.getDynamicObjectCollection(sourceEntry).stream().filter(filter).collect(Collectors.groupingBy(t -> t.getString(groupKey))).values().stream().map(t -> FinOrgCoDataHelper.mergeList((List)t, (String[])dataKeys)).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(dataList)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(sourceEntry + targetSuffix);
        for (DynamicObject data : dataList) {
            DynamicObject object = entryEntity.addNew();
            object.set(groupKey + targetSuffix, data.get(groupKey));
            for (String key : dataKeys) {
                object.set(key + targetSuffix, data.get(key));
            }
        }
    }

    private String[] withSuffix(String suffix, String ... keys) {
        return (String[])Arrays.stream(keys).map(t -> t + suffix).toArray(String[]::new);
    }

    private void accEntryToField(String entryName, String targetField, BiFunction<DynamicObject, String, Object> tranFun) {
        for (String suffix : FinOrgCoDataProp.ALL_SUFFIX) {
            DynamicObjectCollection entryList = this.getModel().getEntryEntity(entryName + suffix);
            for (DynamicObject object : entryList) {
                object.set(targetField + suffix, tranFun.apply(object, suffix));
            }
        }
    }

    private void setHeadValueInEntry(Object filterValue, String getKey, String key, Object defValue) {
        Object res = null;
        Optional<DynamicObject> optional = this.getModel().getEntryEntity("settleentry3").stream().filter(t -> filterValue.equals(t.get("yearscope3"))).findFirst();
        if (optional.isPresent()) {
            res = optional.get().get(getKey + "3");
        }
        res = null == res ? defValue : res;
        this.getModel().setValue(key, res);
    }
}

