/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.evaluation;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class EvalReportCheckEdit
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String CURR_ROW = "currrow";
    private static final String CALLBACK_KEY = "task_callback";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        TextEdit textEdit = (TextEdit)this.getView().getControl("eval_task");
        textEdit.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String fieldName = ((Control)evt.getSource()).getKey();
        if ("eval_task".equals(fieldName)) {
            this.showTaskList();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long reportId = (Long)formShowParameter.getCustomParam("reportId");
        this.getModel().setValue("reportid", (Object)reportId);
        this.getModel().setDataChanged(false);
    }

    public void entryRowClick(RowClickEvent evt) {
        String fieldName = ((Control)evt.getSource()).getKey();
        if (fieldName.equals("entryentity")) {
            this.getPageCache().put(CURR_ROW, String.valueOf(evt.getRow()));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (CALLBACK_KEY.equals(e.getActionId())) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)rows)) {
                List billIds = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                DynamicObject[] tasks = TmcDataServiceHelper.load((String)"tmbrm_evalute_task", (String)"billno,org", (QFilter[])new QFilter("id", "in", billIds).toArray());
                int currRow = Integer.parseInt(this.getPageCache().get(CURR_ROW));
                this.setCheckTask(tasks[0], currRow);
                if (rows.size() > 1) {
                    IDataModel model = this.getModel();
                    currRow = model.getEntryRowCount("entryentity");
                    model.batchCreateNewEntryRow("entryentity", rows.size() - 1);
                    for (int i = 1; i < tasks.length; ++i) {
                        this.setCheckTask(tasks[i], currRow);
                        ++currRow;
                    }
                }
            }
            this.getPageCache().remove(CURR_ROW);
        }
    }

    private void setCheckTask(DynamicObject evalTask, int currRow) {
        this.getModel().setValue("eval_task", (Object)evalTask.getString("billno"), currRow);
        this.getModel().setValue("taskid", (Object)evalTask.getLong("id"), currRow);
        this.getModel().setValue("evalorg", (Object)evalTask.getDynamicObject("org").getString("name"), currRow);
        this.getModel().setValue("orgid", (Object)evalTask.getDynamicObject("org").getLong("id"), currRow);
    }

    private void showTaskList() {
        Long reportId = (Long)this.getModel().getValue("reportid");
        DynamicObject report = TmcDataServiceHelper.loadSingle((Object)reportId, (String)"tmbrm_eval_report", (String)"evalschedule");
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"tmbrm_evalute_task", (boolean)true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY));
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("schedule.id", "=", report.getDynamicObject("evalschedule").getPkValue()));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        List hasTaskIds = this.getModel().getEntryEntity("entryentity").stream().map(t -> t.getLong("taskid")).collect(Collectors.toList());
        if (!hasTaskIds.isEmpty()) {
            qFilters.add(new QFilter("id", "not in", hasTaskIds));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

