/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.evaluation;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.property.EvaluationReportProp;

public class EvalReportEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
TabSelectListener {
    private static final Log logger = LogFactory.getLog(EvalReportEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid bonusEntry = (EntryGrid)this.getView().getControl("bonusentry");
        bonusEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid minusEntry = (EntryGrid)this.getView().getControl("minusentry");
        minusEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid orgEntry = (EntryGrid)this.getView().getControl("detailentry");
        orgEntry.addHyperClickListener((HyperLinkClickListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillView billView = (BillView)e.getSource();
        Object finOrgId = billView.getFormShowParameter().getCustomParam("finorg");
        DynamicObject schedule = (DynamicObject)this.getModel().getValue("evalschedule");
        this.fillWeightEntryData(schedule);
        this.filterEntryData("resultentry", "result_finorg", finOrgId);
        this.filterEntryData("detailentry", "detail_finorg", finOrgId);
        this.filterEntryData("bonusentry", "bonus_finorg", finOrgId);
        this.filterEntryData("minusentry", "minus_finorg", finOrgId);
        this.addResultEntryDynamicColumnAndFillData(schedule);
        this.addOrgEntryDynamicColumnAndFillData(schedule);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_export_result"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_export_org", "bar_export_bonus", "bar_export_minus"});
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        DynamicObject schedule = (DynamicObject)this.getModel().getValue("evalschedule");
        DynamicObject task = null;
        switch (fieldName = evt.getFieldName()) {
            case "bonuspoint": {
                Map entryProps = EvaluationReportProp.getExtraMap((String)"bonusentry");
                task = this.getEntryTask(schedule, entryProps, "bonusentry", evt.getRowIndex());
                break;
            }
            case "minuspoint": {
                Map entryProps = EvaluationReportProp.getExtraMap((String)"minusentry");
                task = this.getEntryTask(schedule, entryProps, "minusentry", evt.getRowIndex());
                break;
            }
            default: {
                task = this.getDynamicEntryTask(schedule, evt.getRowIndex(), fieldName);
            }
        }
        this.showTaskBill(task);
    }

    public void tabSelected(TabSelectEvent event) {
        String key;
        switch (key = event.getTabKey()) {
            case "evaldetailap": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_export_org"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_export_result", "bar_export_bonus", "bar_export_minus"});
                break;
            }
            case "bonusnoteap": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_export_bonus"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_export_result", "bar_export_org", "bar_export_minus"});
                break;
            }
            case "minusnoteap": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_export_minus"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_export_org", "bar_export_bonus", "bar_export_result"});
                break;
            }
            default: {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_export_result"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_export_org", "bar_export_bonus", "bar_export_minus"});
            }
        }
    }

    private DynamicObject getDynamicEntryTask(DynamicObject schedule, int idx, String fieldName) {
        DynamicObject currReport = this.getCurrModel();
        DynamicObjectCollection orgEntry = currReport.getDynamicObjectCollection("detailentry");
        DynamicObject row = (DynamicObject)orgEntry.get(idx);
        String detailScore = row.getString("org_detailscore_tag");
        Map<Long, BigDecimal> scores = this.deSerialScores(detailScore);
        String[] splitFields = fieldName.split("org");
        int fieldIdx = Integer.parseInt(splitFields[1]);
        ArrayList<Long> orgIds = new ArrayList<Long>(scores.keySet());
        Long orgId = (Long)orgIds.get(fieldIdx);
        return QueryServiceHelper.queryOne((String)"tmbrm_evalute_task", (String)"id", (QFilter[])new QFilter[]{new QFilter("schedule.id", "=", schedule.getPkValue()), new QFilter("org.id", "=", (Object)orgId)});
    }

    private DynamicObject getEntryTask(DynamicObject schedule, Map<String, String> entryProps, String entryName, int idx) {
        DynamicObject currReport = this.getCurrModel();
        DynamicObjectCollection bonusEntry = currReport.getDynamicObjectCollection(entryName);
        DynamicObject row = (DynamicObject)bonusEntry.get(idx);
        DynamicObject evalOrg = row.getDynamicObject(entryProps.get("bonus_org"));
        return QueryServiceHelper.queryOne((String)"tmbrm_evalute_task", (String)"id", (QFilter[])new QFilter[]{new QFilter("schedule.id", "=", schedule.getPkValue()), new QFilter("org.id", "=", evalOrg.getPkValue())});
    }

    private void showTaskBill(DynamicObject task) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("tmbrm_evalute_task");
        parameter.setPkId(task.get("id"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private DynamicObject getCurrModel() {
        return TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"tmbrm_eval_report");
    }

    private void addResultEntryDynamicColumnAndFillData(DynamicObject schedule) {
        Long proposalId = schedule.getDynamicObject("evalproposal").getLong("id");
        DynamicObject proposal = TmcDataServiceHelper.loadSingleFromCache((Object)proposalId, (String)"tmbrm_evaluateproposal");
        DynamicObjectCollection itemList = proposal.getDynamicObjectCollection("entryentity");
        Object[] itemIds = itemList.stream().map(t -> t.getDynamicObject("item").getPkValue()).toArray();
        Map itemMap = TmcDataServiceHelper.loadFromCache((Object[])itemIds, (String)"tmbrm_evaluationitem");
        Map entryProps = EvaluationReportProp.getDetailMap((String)"resultentry");
        this.addDynamicColumnHeader(itemMap, entryProps, false);
        this.fillScoreData(entryProps, itemMap, false);
    }

    private void addOrgEntryDynamicColumnAndFillData(DynamicObject schedule) {
        DynamicObjectCollection orgList = schedule.getDynamicObjectCollection("entryentity");
        Object[] orgIds = orgList.stream().map(t -> t.getDynamicObject("evaluateorg").getPkValue()).toArray();
        Map orgMap = TmcDataServiceHelper.loadFromCache((Object[])orgIds, (String)"bos_org");
        Map entryProps = EvaluationReportProp.getDetailMap((String)"detailentry");
        this.addDynamicColumnHeader(orgMap, entryProps, true);
        this.fillScoreData(entryProps, orgMap, true);
    }

    private void fillScoreData(Map<String, String> entryProps, Map<Object, DynamicObject> headerMap, boolean isOrg) {
        DynamicObjectCollection resultEntry = (DynamicObjectCollection)this.getModel().getValue(entryProps.get("resultentry"));
        for (DynamicObject row : resultEntry) {
            String detailScore = row.getString(entryProps.get("detailscore_tag"));
            Map<Long, BigDecimal> scores = this.deSerialScores(detailScore);
            int index = 0;
            if (isOrg) {
                for (Map.Entry<Object, BigDecimal> entry : scores.entrySet()) {
                    row.set(entryProps.get("key") + index, (Object)entry.getValue());
                    ++index;
                }
                continue;
            }
            for (Map.Entry<Object, BigDecimal> entry : headerMap.entrySet()) {
                Long id = (Long)entry.getKey();
                BigDecimal score = scores.get(id);
                row.set(entryProps.get("key") + index, (Object)score);
                ++index;
            }
        }
        this.getView().updateView(entryProps.get("resultentry"));
        this.getModel().setDataChanged(false);
    }

    private void addDynamicColumnHeader(Map<Object, DynamicObject> itemMap, Map<String, String> entryProps, boolean isOrg) {
        DynamicObjectCollection resultEntry = (DynamicObjectCollection)this.getModel().getValue(entryProps.get("resultentry"));
        if (EmptyUtil.isEmpty((DynamicObjectCollection)resultEntry)) {
            return;
        }
        String detailScore = ((DynamicObject)resultEntry.get(0)).getString(entryProps.get("detailscore_tag"));
        Map<Long, BigDecimal> scores = this.deSerialScores(detailScore);
        int index = 0;
        EntryGrid control = (EntryGrid)this.getControl(entryProps.get("resultentry"));
        if (isOrg) {
            for (Map.Entry<Long, BigDecimal> score : scores.entrySet()) {
                DynamicObject item = itemMap.get(score.getKey());
                String key = entryProps.get("key") + index;
                control.setColumnProperty(key, "header", (Object)new LocaleString(item.getString("name")));
                control.setColumnProperty(key, "id", (Object)(entryProps.get("key") + score.getKey()));
                ++index;
            }
        } else {
            for (Map.Entry<Object, DynamicObject> item : itemMap.entrySet()) {
                DynamicObject itemObj = item.getValue();
                String key = entryProps.get("key") + index;
                control.setColumnProperty(key, "header", (Object)new LocaleString(itemObj.getString("name")));
                control.setColumnProperty(key, "k", (Object)(entryProps.get("key") + item.getKey()));
                ++index;
            }
        }
        control.setColumnProperty(entryProps.get("result_finorg"), "isFixed", (Object)Boolean.TRUE);
        control.setColumnProperty(entryProps.get("resultevalpoint"), "isFixed", (Object)Boolean.TRUE);
        this.getView().setVisible(Boolean.FALSE, (String[])IntStream.range(scores.size(), 50).boxed().map(t -> (String)entryProps.get("key") + t).toArray(String[]::new));
    }

    private void fillWeightEntryData(DynamicObject schedule) {
        DynamicObjectCollection wgtEntry = schedule.getDynamicObjectCollection("entryentity");
        ArrayList list = new ArrayList(wgtEntry.size());
        for (DynamicObject entry : wgtEntry) {
            HashMap<String, Object> entryMap = new HashMap<String, Object>(6);
            entryMap.put("evaluateorg", entry.getDynamicObject("evaluateorg"));
            entryMap.put("evaluateorgwgt", entry.getBigDecimal("evaluateorgwgt"));
            entryMap.put("description", entry.getString("description"));
            list.add(entryMap);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        boolean dataChanged = model.getDataChanged();
        model.beginInit();
        TmcViewInputHelper.batchFillEntity((String)"weightentry", (AbstractFormDataModel)model, list);
        model.endInit();
        this.getView().updateView("weightentry");
        model.setDataChanged(dataChanged);
    }

    private void filterEntryData(String entryKey, String finOrgKey, Object finOrgId) {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey);
        if (EmptyUtil.isNoEmpty((Object)finOrgId)) {
            entry.removeIf(e -> !finOrgId.equals(e.getDynamicObject(finOrgKey).getPkValue()));
        }
        this.getView().updateView(entryKey);
    }

    private Map<Long, BigDecimal> deSerialScores(String detailScore) {
        String detail = null;
        try {
            detail = GzipUtils.uncompress((String)detailScore, (String)"UTF-8");
        }
        catch (IOException ex) {
            logger.error("\u89e3\u6790\u5206\u6570\u660e\u7ec6\u9519\u8bef\uff1a", (Throwable)ex);
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)detail);
    }
}

