/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.evaluation;

import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EvalReportPlugin
extends AbstractFormPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && !operationResult.getSuccessPkIds().isEmpty()) {
            String operateKey = args.getOperateKey();
            long successId = (Long)operationResult.getSuccessPkIds().get(0);
            switch (operateKey) {
                case "check": {
                    this.openCheckParamForm(successId, new CloseCallBack((IFormPlugin)this, "check_callback"));
                    break;
                }
                case "terminate": {
                    this.openEndParamForm(successId, new CloseCallBack((IFormPlugin)this, "end_callback"));
                    break;
                }
                case "trackschedule": {
                    this.openScheduleForm(successId);
                    break;
                }
                case "tracktask": {
                    this.openTaskListForm(successId);
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().invokeOperation("refresh");
    }

    private void openCheckParamForm(Long reportId, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = this.createFormShowParameter("tmbrm_report_check");
        showParameter.setCustomParam("reportId", (Object)reportId);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void openEndParamForm(Long reportId, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = this.createFormShowParameter("tmbrm_evalschedule_end");
        showParameter.setCustomParam("billtype", (Object)"report");
        showParameter.setCustomParam("billid", (Object)reportId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bc4\u4ef7\u62a5\u544a\u7ec8\u6b62", (String)"EvalReportPlugin_0", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void openScheduleForm(Long reportId) {
        Long scheduleId = this.getScheduleId(reportId);
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("tmbrm_eval_schedule");
        parameter.setPkId((Object)scheduleId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void openTaskListForm(Long reportId) {
        Long scheduleId = this.getScheduleId(reportId);
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("tmbrm_evalute_task");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter qFilter = new QFilter("schedule.id", "=", (Object)scheduleId);
        parameter.getListFilterParameter().setFilter(qFilter);
        parameter.getCustomParams().put("dataSource", "bizBill");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private Long getScheduleId(Long reportId) {
        DynamicObject report = QueryServiceHelper.queryOne((String)"tmbrm_eval_report", (String)"evalschedule.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
        return report.getLong("evalschedule.id");
    }

    private FormShowParameter createFormShowParameter(String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }
}

