/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.evaluation;

import kd.bos.context.RequestContext;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class EvalScheduleList
extends AbstractTmcListPlugin {
    public static final String ASSIGN = "assign";
    public static final String QUERY_REPORT = "queryreport";
    private static final String QUERY_TASK = "querytask";
    public static final String TERMINATE = "terminate";
    private static final Long PRO_ID = 401L;
    private static final String TMBRM_APP = "TMBRM";
    private static final String TMBRM_APP_ID = "34HTXX81G8FI";
    private static final Log logger = LogFactory.getLog(EvalScheduleList.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult appBizLicense = LicenseServiceHelper.checkByAppAndBizObj((String)TMBRM_APP_ID, (String)"tmbrm_access_apply", (Long)RequestContext.get().getCurrUserId());
        if (!appBizLicense.getHasLicense().booleanValue()) {
            logger.info("checkByAppAndBizObj fail");
            e.setCancel(true);
            e.setCancelMessage(appBizLicense.getMsg());
            e.setCancelFormShowParameter(appBizLicense.getCancelFormShowParameter());
            return;
        }
        logger.info("checkByAppAndBizObj pass");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "assign": 
            case "terminate": 
            case "querytask": {
                this.checkSelectedId(args);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if ("callback_terminate".equals(event.getActionId()) && EmptyUtil.isNoEmpty((Object)returnData)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void checkSelectedId(BeforeDoOperationEventArgs args) {
        Long selectedId = this.getSelectedId();
        if (selectedId == null) {
            args.setCancel(true);
        }
    }
}

