/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.evaluation;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcFormHelper;

public class EvalSchedulePlugin
extends AbstractFormPlugin {
    public static final String CALLBACK_TERMINATE = "callback_terminate";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("queryreport".equals(operateKey)) {
            IFormView view = this.getView();
            if (view instanceof BillView) {
                Long evalScheduleId = (Long)this.getModel().getValue("id");
                this.beforeDoQueryReport(args, this.getView(), evalScheduleId);
            } else if (view instanceof ListView) {
                Long selectedId = this.getSelectedId();
                if (selectedId == null) {
                    args.setCancel(true);
                    return;
                }
                this.beforeDoQueryReport(args, this.getView(), selectedId);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            if ("terminate".equals(operateKey)) {
                FormShowParameter formShowParameter = TmcFormHelper.createFormShowParameter((String)"tmbrm_evalschedule_end");
                HashMap<String, String> params = new HashMap<String, String>(4);
                params.put("billtype", "schedule");
                params.put("billid", (String)operationResult.getSuccessPkIds().get(0));
                formShowParameter.setCustomParams(params);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_TERMINATE));
                this.getView().showForm(formShowParameter);
            }
            if ("queryreport".equals(operateKey)) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("tmbrm_eval_report");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatusValue(OperationStatus.VIEW.getValue());
                EntityOperate operate = (EntityOperate)args.getSource();
                showParameter.setPkId((Object)Long.valueOf(operate.getOption().getVariableValue("reportId")));
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private void beforeDoQueryReport(BeforeDoOperationEventArgs args, IFormView view, Long evalScheduleId) {
        QFilter qFilter = new QFilter("evalschedule", "=", (Object)evalScheduleId);
        DynamicObject report = QueryServiceHelper.queryOne((String)"tmbrm_eval_report", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (report == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u6ca1\u6709\u5173\u8054\u7684\u8bc4\u4ef7\u62a5\u544a\u3002", (String)"EvalSchedulePlugin_0", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else {
            EntityOperate operate = (EntityOperate)args.getSource();
            operate.getOption().setVariableValue("reportId", String.valueOf(report.getLong("id")));
        }
    }

    protected Long getSelectedId() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvalSchedulePlugin_1", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
            return null;
        }
        HashSet<Long> idSet = new HashSet<Long>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            idSet.add((Long)selectedRow.getPrimaryKeyValue());
        }
        if (idSet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\u3002", (String)"EvalSchedulePlugin_2", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
            return null;
        }
        return (Long)selectedRows.get(0).getPrimaryKeyValue();
    }
}

