/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.evaluation;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.helper.EvaluationAssistanceHelper;
import org.apache.commons.lang3.StringUtils;

public class EvaluationAssistRefDataEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"reftoolbarap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadData();
    }

    private void loadData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String finOrgType = (String)parameter.getCustomParam("finorgtype");
        String finOrgs = (String)parameter.getCustomParam("finorg");
        Long itemId = (Long)parameter.getCustomParam("evaluateitem");
        DynamicObject item = TmcDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"tmbrm_evaluationitem");
        DynamicObjectCollection itemRefList = item.getDynamicObjectCollection("refentry");
        int refSize = itemRefList.size();
        String hideField = "bd_bankcgsetting".equals(finOrgType) ? "ifinorg" : "ibank";
        this.getView().setVisible(Boolean.FALSE, new String[]{hideField});
        if (EmptyUtil.isNotBlank((CharSequence)finOrgs) && refSize > 0) {
            Map itemMap = EvaluationAssistanceHelper.getRefDataMap((Map)this.getView().getFormShowParameter().getCustomParams());
            IDataModel model = this.getModel();
            Object[] orgIds = (Long[])Arrays.stream(StringUtils.split((String)finOrgs, (String)",")).map(Long::parseLong).toArray(Long[]::new);
            DynamicObjectCollection entryEntity = model.getEntryEntity("refdataentry");
            String showField = "bd_bankcgsetting".equals(finOrgType) ? "ibank" : "ifinorg";
            Map orgMap = TmcDataServiceHelper.loadFromCache((Object[])orgIds, (String)finOrgType);
            for (Object org : orgIds) {
                DynamicObject object = entryEntity.addNew();
                object.set(showField, orgMap.get(org));
                for (int i = 0; i < refSize; ++i) {
                    DynamicObject refQuota = ((DynamicObject)itemRefList.get(i)).getDynamicObject("refquota");
                    String refKey = refQuota.getString("number");
                    String val = (String)itemMap.get(org + "#" + refKey);
                    val = EmptyUtil.isBlank((CharSequence)val) ? "" : val;
                    object.set("item" + i, (Object)val);
                }
            }
        }
        EntryGrid control = (EntryGrid)this.getControl("refdataentry");
        for (int i = 0; i < refSize; ++i) {
            control.setColumnProperty("item" + i, "header", (Object)((DynamicObject)itemRefList.get(i)).getDynamicObject("refquota").getLocaleString("name"));
        }
        this.getView().setVisible(Boolean.FALSE, (String[])IntStream.range(refSize, 20).boxed().map(t -> "item" + t).toArray(String[]::new));
        if (EmptyUtil.isBlank((CharSequence)finOrgs) || 0 == refSize) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"tb_export"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.selectRefRow();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tb_refreresh".equals(itemKey)) {
            this.loadData();
            this.selectRefRow();
        }
    }

    private void selectRefRow() {
        String row = (String)this.getView().getFormShowParameter().getCustomParam("row");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("refdataentry");
        if (entryGrid.getRuleCount() > 0) {
            entryGrid.selectRows(Integer.parseInt(row));
        }
    }
}

