/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.evaluation;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.EvaluationNatureEnum;
import kd.tmc.tmbrm.common.util.BigDecimalUtils;

public class EvaluationAssistRuleEdit
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.refreshRule();
    }

    private void refreshRule() {
        Long itemId = (Long)this.getView().getFormShowParameter().getCustomParam("evaluateitem");
        DynamicObject item = TmcDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"tmbrm_evaluationitem");
        DynamicObjectCollection ruleList = item.getDynamicObjectCollection("ruleentry");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String entry = "ruleentry";
        model.deleteEntryData(entry);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)ruleList)) {
            return;
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("itemname", new Object[0]);
        vs.addField("score", new Object[0]);
        vs.addField("scorefrom", new Object[0]);
        vs.addField("scoreto", new Object[0]);
        vs.addField("rulecomment", new Object[0]);
        for (DynamicObject data : ruleList) {
            String comment = data.getString("rulecomment");
            comment = EmptyUtil.isBlank((CharSequence)comment) ? " " : comment;
            vs.addRow(new Object[]{data.getString("itemname"), BigDecimalUtils.setScale((Object)data.get("score")), BigDecimalUtils.setScale((Object)data.get("scorefrom")), BigDecimalUtils.setScale((Object)data.get("scoreto")), comment});
        }
        model.batchCreateNewEntryRow(entry, vs);
        model.endInit();
        if (EvaluationNatureEnum.QUALITY.getValue().equals(item.getString("nature"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"scorefrom", "scoreto"});
        }
    }
}

